/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics.cdi;

import io.helidon.metrics.RegistryFactory;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
public class RegistryProducer {
    private static Supplier<RegistryFactory> factorySupplier = RegistryFactory.getRegistryFactory();

    private RegistryProducer() {
    }

    @Produces
    public static MetricRegistry getDefaultRegistry() {
        return RegistryProducer.getApplicationRegistry();
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    public static MetricRegistry getApplicationRegistry() {
        return factorySupplier.get().getRegistry(MetricRegistry.Type.APPLICATION);
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.BASE)
    public static MetricRegistry getBaseRegistry() {
        return factorySupplier.get().getRegistry(MetricRegistry.Type.BASE);
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.VENDOR)
    public static MetricRegistry getVendorRegistry() {
        return factorySupplier.get().getRegistry(MetricRegistry.Type.VENDOR);
    }

    static void clearApplicationRegistry() {
        MetricRegistry applicationRegistry = RegistryProducer.getApplicationRegistry();
        applicationRegistry.getNames().forEach(arg_0 -> ((MetricRegistry)applicationRegistry).remove(arg_0));
    }
}

