/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics.cdi;

import io.helidon.metrics.MetricsSupport;
import io.helidon.microprofile.metrics.cdi.DelegatingGauge;
import io.helidon.microprofile.metrics.cdi.InterceptorCounted;
import io.helidon.microprofile.metrics.cdi.InterceptorMetered;
import io.helidon.microprofile.metrics.cdi.InterceptorTimed;
import io.helidon.microprofile.metrics.cdi.MetricProducer;
import io.helidon.microprofile.metrics.cdi.MetricUtil;
import io.helidon.microprofile.metrics.cdi.RegistryProducer;
import io.helidon.microprofile.metrics.cdi.VendorDefined;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import javax.inject.Qualifier;
import javax.interceptor.Interceptor;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class MetricsCdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(MetricsCdiExtension.class.getName());
    private static final List<Class<? extends Annotation>> METRIC_ANNOTATIONS = Arrays.asList(Counted.class, Metered.class, Timed.class, Gauge.class);
    private final Map<Bean<?>, AnnotatedMember<?>> producers = new HashMap();
    private final Map<String, AnnotatedMethodConfigurator<?>> annotatedGaugeSites = new HashMap();

    private static <T> T getReference(BeanManager bm, Type type, Bean<?> bean) {
        return (T)bm.getReference(bean, type, bm.createCreationalContext(bean));
    }

    static <E extends Member & AnnotatedElement> void registerMetric(E element, Class<?> clazz, MetricUtil.LookupResult<? extends Annotation> lookupResult) {
        MetricRegistry registry = MetricsCdiExtension.getMetricRegistry();
        Annotation annotation = lookupResult.getAnnotation();
        if (annotation instanceof Counted) {
            Counted counted = (Counted)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, lookupResult.getType(), counted.name(), counted.absolute());
            Metadata meta = new Metadata(metricName, counted.displayName(), counted.description(), MetricType.COUNTER, counted.unit(), MetricsCdiExtension.toTags(counted.tags()));
            registry.counter(meta);
            LOGGER.log(Level.FINE, () -> "### Registered counter " + metricName);
        } else if (annotation instanceof Metered) {
            Metered metered = (Metered)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, lookupResult.getType(), metered.name(), metered.absolute());
            Metadata meta = new Metadata(metricName, metered.displayName(), metered.description(), MetricType.METERED, metered.unit(), MetricsCdiExtension.toTags(metered.tags()));
            registry.meter(meta);
            LOGGER.log(Level.FINE, () -> "### Registered meter " + metricName);
        } else if (annotation instanceof Timed) {
            Timed timed = (Timed)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, lookupResult.getType(), timed.name(), timed.absolute());
            Metadata meta = new Metadata(metricName, timed.displayName(), timed.description(), MetricType.TIMER, timed.unit(), MetricsCdiExtension.toTags(timed.tags()));
            registry.timer(meta);
            LOGGER.log(Level.FINE, () -> "### Registered timer " + metricName);
        }
    }

    static String toTags(String[] tags) {
        if (null == tags || tags.length == 0) {
            return "";
        }
        return String.join((CharSequence)",", tags);
    }

    static Class<?> getRealClass(Object object) {
        Class<?> result = object.getClass();
        while (result.isSynthetic()) {
            result = result.getSuperclass();
        }
        return result;
    }

    private static MetricRegistry getMetricRegistry() {
        return RegistryProducer.getDefaultRegistry();
    }

    public void before(@Observes BeforeBeanDiscovery discovery) {
        LOGGER.log(Level.FINE, () -> "### Before bean discovery " + discovery);
        MetricsSupport.create();
        RegistryProducer.clearApplicationRegistry();
        discovery.addAnnotatedType(RegistryProducer.class, "RegistryProducer");
        discovery.addAnnotatedType(MetricProducer.class, "MetricProducer");
        discovery.addAnnotatedType(InterceptorCounted.class, "InterceptorCounted");
        discovery.addAnnotatedType(InterceptorMetered.class, "InterceptorMetered");
        discovery.addAnnotatedType(InterceptorTimed.class, "InterceptorTimed");
    }

    private void registerMetrics(@Observes @WithAnnotations(value={Counted.class, Metered.class, Timed.class}) ProcessAnnotatedType<?> pat) {
        AnnotatedType type = pat.getAnnotatedType();
        Interceptor annot = (Interceptor)type.getAnnotation(Interceptor.class);
        if (annot != null) {
            return;
        }
        LOGGER.log(Level.FINE, () -> "### Processing annotations for " + pat.getAnnotatedType().getJavaClass().getName());
        AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
        Class clazz = configurator.getAnnotated().getJavaClass();
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        configurator.filterMethods(method -> !Modifier.isPrivate(method.getJavaMember().getModifiers())).forEach(method -> METRIC_ANNOTATIONS.forEach(annotation -> {
            MetricUtil.LookupResult lookupResult = MetricUtil.lookupAnnotation(method.getAnnotated().getJavaMember(), annotation, clazz);
            if (lookupResult != null) {
                MetricsCdiExtension.registerMetric(method.getAnnotated().getJavaMember(), clazz, lookupResult);
            }
        }));
        configurator.filterConstructors(constructor -> !Modifier.isPrivate(constructor.getJavaMember().getModifiers())).forEach(constructor -> METRIC_ANNOTATIONS.forEach(annotation -> {
            MetricUtil.LookupResult lookupResult = MetricUtil.lookupAnnotation(constructor.getAnnotated().getJavaMember(), annotation, clazz);
            if (lookupResult != null) {
                MetricsCdiExtension.registerMetric(constructor.getAnnotated().getJavaMember(), clazz, lookupResult);
            }
        }));
    }

    private void processInjectionPoints(@Observes ProcessInjectionPoint<?, ?> pip) {
        Type type = pip.getInjectionPoint().getType();
        if (type.equals(Counter.class) || type.equals(Histogram.class) || type.equals(Meter.class) || type.equals(Timer.class)) {
            pip.configureInjectionPoint().addQualifier((Annotation)VendorDefined.Literal.INSTANCE);
        }
    }

    private void recordProducerFields(@Observes ProcessProducerField<? extends org.eclipse.microprofile.metrics.Metric, ?> ppf) {
        Optional<Annotation> hasQualifier;
        Metric metric;
        LOGGER.log(Level.FINE, () -> "### recordProducerFields " + ppf.getBean().getBeanClass());
        if (!(MetricProducer.class.equals((Object)ppf.getBean().getBeanClass()) || (metric = (Metric)ppf.getAnnotatedProducerField().getAnnotation(Metric.class)) == null || (hasQualifier = ppf.getAnnotatedProducerField().getAnnotations().stream().filter(annotation -> annotation.annotationType().isAnnotationPresent(Qualifier.class)).findFirst()).isPresent() && !(hasQualifier.get() instanceof Default))) {
            this.producers.put((Bean<?>)ppf.getBean(), (AnnotatedMember<?>)ppf.getAnnotatedProducerField());
        }
    }

    private void recordProducerMethods(@Observes ProcessProducerMethod<? extends org.eclipse.microprofile.metrics.Metric, ?> ppm) {
        Optional<Annotation> hasQualifier;
        Metric metric;
        LOGGER.log(Level.FINE, () -> "### recordProducerMethods " + ppm.getBean().getBeanClass());
        if (!(MetricProducer.class.equals((Object)ppm.getBean().getBeanClass()) || (metric = (Metric)ppm.getAnnotatedProducerMethod().getAnnotation(Metric.class)) == null || (hasQualifier = ppm.getAnnotatedProducerMethod().getAnnotations().stream().filter(annotation -> annotation.annotationType().isAnnotationPresent(Qualifier.class)).findFirst()).isPresent() && !(hasQualifier.get() instanceof Default))) {
            this.producers.put((Bean<?>)ppm.getBean(), (AnnotatedMember<?>)ppm.getAnnotatedProducerMethod());
        }
    }

    private void registerProducers(@Observes AfterDeploymentValidation adv, BeanManager bm) {
        LOGGER.log(Level.FINE, () -> "### registerProducers");
        MetricRegistry registry = MetricsCdiExtension.getMetricRegistry();
        this.producers.entrySet().forEach(entry -> {
            Metric metric = (Metric)((AnnotatedMember)entry.getValue()).getAnnotation(Metric.class);
            if (metric != null) {
                String metricName = MetricUtil.getMetricName(new AnnotatedElementWrapper((AnnotatedMember)entry.getValue()), ((AnnotatedMember)entry.getValue()).getDeclaringType().getJavaClass(), MetricUtil.MatchingType.METHOD, metric.name(), metric.absolute());
                registry.register(metricName, (org.eclipse.microprofile.metrics.Metric)MetricsCdiExtension.getReference(bm, ((AnnotatedMember)entry.getValue()).getBaseType(), (Bean)entry.getKey()));
            }
        });
        this.producers.clear();
    }

    private void recordAnnotatedGaugeSite(@Observes @WithAnnotations(value={Gauge.class}) ProcessAnnotatedType<?> pat) {
        LOGGER.log(Level.FINE, () -> "### recordAnnoatedGaugeSite for class " + pat.getAnnotatedType().getJavaClass());
        AnnotatedType type = pat.getAnnotatedType();
        LOGGER.log(Level.FINE, () -> "### Processing annotations for " + type.getJavaClass().getName());
        AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
        Class clazz = configurator.getAnnotated().getJavaClass();
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        configurator.filterMethods(method -> method.getJavaMember().getDeclaringClass().equals(clazz) && !Modifier.isPrivate(method.getJavaMember().getModifiers()) && method.isAnnotationPresent(Gauge.class)).forEach(method -> {
            Method javaMethod = method.getAnnotated().getJavaMember();
            String explicitGaugeName = ((Gauge)method.getAnnotated().getAnnotation(Gauge.class)).name();
            String gaugeName = String.format("%s.%s", clazz.getName(), explicitGaugeName != null && explicitGaugeName.length() > 0 ? explicitGaugeName : javaMethod.getName());
            this.annotatedGaugeSites.put(gaugeName, (AnnotatedMethodConfigurator<?>)method);
            LOGGER.log(Level.FINE, () -> String.format("### Recorded annotated gauge with name %s", gaugeName));
        });
    }

    private void registerAnnotatedGauges(@Observes AfterDeploymentValidation adv, BeanManager bm) {
        LOGGER.log(Level.FINE, () -> "### registerGauges");
        MetricRegistry registry = MetricsCdiExtension.getMetricRegistry();
        this.annotatedGaugeSites.entrySet().forEach(gaugeSite -> {
            LOGGER.log(Level.FINE, () -> "### gaugeSite " + gaugeSite.toString());
            String gaugeName = (String)gaugeSite.getKey();
            AnnotatedMethodConfigurator site = (AnnotatedMethodConfigurator)gaugeSite.getValue();
            DelegatingGauge<?> dg = this.buildDelegatingGauge(gaugeName, site, bm);
            Gauge gaugeAnnotation = (Gauge)site.getAnnotated().getAnnotation(Gauge.class);
            Metadata md = new Metadata(gaugeName, gaugeAnnotation.displayName(), gaugeAnnotation.description(), MetricType.GAUGE, gaugeAnnotation.unit(), MetricsCdiExtension.toTags(gaugeAnnotation.tags()));
            LOGGER.log(Level.FINE, () -> String.format("### Registering gauge with metadata %s", md.toString()));
            registry.register(md, dg);
        });
        this.annotatedGaugeSites.clear();
    }

    private DelegatingGauge<?> buildDelegatingGauge(String gaugeName, AnnotatedMethodConfigurator<?> site, BeanManager bm) {
        Bean bean = (Bean)bm.getBeans(site.getAnnotated().getJavaMember().getDeclaringClass(), new Annotation[0]).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find bean for annotated gauge " + gaugeName));
        return DelegatingGauge.newInstance(site.getAnnotated().getJavaMember(), MetricsCdiExtension.getReference(bm, bean.getBeanClass(), bean), site.getAnnotated().getJavaMember().getReturnType());
    }

    static class AnnotatedElementWrapper
    implements AnnotatedElement,
    Member {
        private final AnnotatedMember<?> annotatedMember;

        AnnotatedElementWrapper(AnnotatedMember<?> annotatedMember) {
            this.annotatedMember = annotatedMember;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.annotatedMember.isAnnotationPresent(annotationClass);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.annotatedMember.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.annotatedMember.getAnnotations().toArray(new Annotation[0]);
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.annotatedMember.getDeclaringType().getJavaClass();
        }

        @Override
        public String getName() {
            return this.annotatedMember.getJavaMember().getName();
        }

        @Override
        public int getModifiers() {
            return this.annotatedMember.getJavaMember().getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.annotatedMember.getJavaMember().isSynthetic();
        }
    }
}

