/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

final class MetricUtil {
    private MetricUtil() {
    }

    static <E extends Member & AnnotatedElement, A extends Annotation> LookupResult<A> lookupAnnotation(E element, Class<? extends Annotation> annotClass, Class<?> clazz) {
        Annotation annotation = ((AnnotatedElement)element).getAnnotation(annotClass);
        if (annotation != null) {
            return new LookupResult<Annotation>(MatchingType.METHOD, annotation);
        }
        annotation = element.getDeclaringClass().getAnnotation(annotClass);
        if (annotation == null) {
            annotation = clazz.getAnnotation(annotClass);
        }
        return annotation == null ? null : new LookupResult<Annotation>(MatchingType.CLASS, annotation);
    }

    static <E extends Member & AnnotatedElement> String getMetricName(E element, Class<?> clazz, MatchingType matchingType, String explicitName, boolean absolute) {
        String result;
        if (matchingType == MatchingType.METHOD) {
            String string = result = explicitName == null || explicitName.isEmpty() ? MetricUtil.getElementName(element, clazz) : explicitName;
            if (!absolute) {
                Class<?> declaringClass = clazz;
                if (element instanceof Method) {
                    List<Method> methods = Arrays.asList(declaringClass.getDeclaredMethods());
                    while (!methods.contains(element)) {
                        declaringClass = declaringClass.getSuperclass();
                        methods = Arrays.asList(declaringClass.getDeclaredMethods());
                    }
                }
                result = declaringClass.getName() + "." + result;
            }
        } else if (matchingType == MatchingType.CLASS) {
            if (explicitName == null || explicitName.isEmpty()) {
                result = MetricUtil.getElementName(element, clazz);
                if (!absolute) {
                    result = clazz.getName() + "." + result;
                }
            } else {
                result = clazz.getPackage().getName() + "." + explicitName + "." + MetricUtil.getElementName(element, clazz);
            }
        } else {
            throw new InternalError("Unknown matching type");
        }
        return result;
    }

    static <E extends Member & AnnotatedElement> String getElementName(E element, Class<?> clazz) {
        return element instanceof Constructor ? clazz.getSimpleName() : element.getName();
    }

    static class LookupResult<A extends Annotation> {
        private final MatchingType type;
        private final A annotation;

        LookupResult(MatchingType type, A annotation) {
            this.type = type;
            this.annotation = annotation;
        }

        public MatchingType getType() {
            return this.type;
        }

        public A getAnnotation() {
            return this.annotation;
        }
    }

    static enum MatchingType {
        METHOD,
        CLASS;

    }
}

