/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics.cdi;

import io.helidon.microprofile.metrics.cdi.VendorDefined;
import java.lang.reflect.Constructor;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;

@ApplicationScoped
public class MetricProducer {
    private static Metadata newMetadata(InjectionPoint ip, Metric metric, MetricType metricType) {
        return metric == null ? new Metadata(MetricProducer.getName(ip), "", "", metricType, "none") : new Metadata(MetricProducer.getName(metric, ip), metric.displayName(), metric.description(), metricType, metric.unit(), MetricProducer.toTags(metric.tags()));
    }

    private static String toTags(String[] tags) {
        return tags.length == 0 ? "" : String.join((CharSequence)",", tags);
    }

    private static String getName(InjectionPoint ip) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(ip.getMember().getDeclaringClass().getName());
        fullName.append('.');
        fullName.append(ip.getMember().getName());
        if (ip.getMember() instanceof Constructor) {
            fullName.append("new");
        }
        return fullName.toString();
    }

    private static String getName(Metric metric, InjectionPoint ip) {
        StringBuilder fullName = new StringBuilder(metric.absolute() ? "" : ip.getMember().getDeclaringClass().getName() + ".");
        if (metric.name().isEmpty()) {
            fullName.append(ip.getMember().getName());
            if (ip.getMember() instanceof Constructor) {
                fullName.append(".new");
            }
        } else {
            fullName.append(metric.name());
        }
        return fullName.toString();
    }

    @Produces
    private Counter produceCounterDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceCounter(registry, ip);
    }

    @Produces
    @VendorDefined
    private Counter produceCounter(MetricRegistry registry, InjectionPoint ip) {
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return registry.counter(MetricProducer.newMetadata(ip, metric, MetricType.COUNTER));
    }

    @Produces
    private Meter produceMeterDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceMeter(registry, ip);
    }

    @Produces
    @VendorDefined
    private Meter produceMeter(MetricRegistry registry, InjectionPoint ip) {
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return registry.meter(MetricProducer.newMetadata(ip, metric, MetricType.METERED));
    }

    @Produces
    private Timer produceTimerDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceTimer(registry, ip);
    }

    @Produces
    @VendorDefined
    private Timer produceTimer(MetricRegistry registry, InjectionPoint ip) {
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return registry.timer(MetricProducer.newMetadata(ip, metric, MetricType.TIMER));
    }

    @Produces
    private Histogram produceHistogramDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceHistogram(registry, ip);
    }

    @Produces
    @VendorDefined
    private Histogram produceHistogram(MetricRegistry registry, InjectionPoint ip) {
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return registry.histogram(MetricProducer.newMetadata(ip, metric, MetricType.HISTOGRAM));
    }

    @Produces
    @VendorDefined
    private <T> Gauge<T> produceGauge(MetricRegistry registry, InjectionPoint ip) {
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return (Gauge)registry.getGauges().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(metric.name())).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not produce Gauge for injection point " + ip.toString())).getValue();
    }

    @Produces
    private <T> Gauge<T> produceGaugeDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceGauge(registry, ip);
    }
}

