/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics.cdi;

import io.helidon.microprofile.metrics.cdi.InterceptorBase;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;

@Counted
@Interceptor
@Priority(value=8)
final class InterceptorCounted
extends InterceptorBase<Counter, Counted> {
    @Inject
    InterceptorCounted(MetricRegistry registry) {
        super(registry, Counted.class, Counted::name, Counted::absolute, MetricRegistry::getCounters, "counter");
    }

    @Override
    protected Object prepareAndInvoke(Counter counter, Counted annot, InvocationContext context) throws Exception {
        counter.inc();
        return context.proceed();
    }

    @Override
    protected void postInvoke(Counter counter, Counted annot, InvocationContext context, Exception ex) {
        if (!annot.monotonic()) {
            counter.dec();
        }
    }
}

