/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics.cdi;

import io.helidon.microprofile.metrics.cdi.MetricUtil;
import io.helidon.microprofile.metrics.cdi.MetricsCdiExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;

@Dependent
abstract class InterceptorBase<T extends Metric, A extends Annotation> {
    private final MetricRegistry registry;
    private final Class<A> annotationClass;
    private final Function<A, String> nameFunction;
    private final Function<A, Boolean> isAbsoluteFunction;
    private final Function<MetricRegistry, SortedMap<String, T>> metricsMapFunction;
    private final String metricTypeName;

    InterceptorBase(MetricRegistry registry, Class<A> annotationClass, Function<A, String> nameFunction, Function<A, Boolean> isAbsoluteFunction, Function<MetricRegistry, SortedMap<String, T>> metricsMapFunction, String metricTypeName) {
        this.registry = registry;
        this.annotationClass = annotationClass;
        this.nameFunction = nameFunction;
        this.isAbsoluteFunction = isAbsoluteFunction;
        this.metricsMapFunction = metricsMapFunction;
        this.metricTypeName = metricTypeName;
    }

    protected <T> Optional<T> getMetric(Map<String, T> metricMap, String metricName) {
        return Optional.ofNullable(metricMap.get(metricName));
    }

    @AroundConstruct
    private Object aroundConstructor(InvocationContext context) throws Exception {
        return this.called(context, context.getConstructor());
    }

    @AroundInvoke
    private Object aroundMethod(InvocationContext context) throws Exception {
        return this.called(context, context.getMethod());
    }

    protected <E extends Member & AnnotatedElement> Class<?> getClass(InvocationContext context, E element) {
        return context.getTarget() != null ? MetricsCdiExtension.getRealClass(context.getTarget()) : element.getDeclaringClass();
    }

    private <E extends Member & AnnotatedElement> Object called(InvocationContext context, E element) throws Exception {
        MetricUtil.LookupResult lookupResult = MetricUtil.lookupAnnotation(element, this.annotationClass, this.getClass(context, element));
        if (lookupResult != null) {
            Object annot = lookupResult.getAnnotation();
            String metricName = MetricUtil.getMetricName(element, this.getClass(context, element), lookupResult.getType(), this.nameFunction.apply(annot), this.isAbsoluteFunction.apply(annot));
            Optional<Metric> metric = this.getMetric((Map)this.metricsMapFunction.apply(this.registry), metricName);
            Metric metricInstance = metric.orElseGet(() -> {
                throw new IllegalStateException("No " + this.metricTypeName + " with name [" + metricName + "] found in registry [" + this.registry + "]");
            });
            Exception ex = null;
            try {
                Object object = this.prepareAndInvoke(metricInstance, annot, context);
                return object;
            }
            catch (Exception e) {
                ex = e;
                throw e;
            }
            finally {
                this.postInvoke(metricInstance, annot, context, ex);
            }
        }
        return context.proceed();
    }

    protected abstract Object prepareAndInvoke(T var1, A var2, InvocationContext var3) throws Exception;

    protected void postInvoke(T metricInstance, A annotation, InvocationContext context, Exception ex) throws Exception {
    }
}

