/*
 * Decompiled with CFR 0.152.
 */
package com.hujiang.gradle.plugin.android.aspectjx.internal.procedure;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.hujiang.gradle.plugin.android.aspectjx.internal.concurrent.BatchTaskScheduler;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.AJXTask;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.AbsProcedure;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.DoAspectProcedure;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.ProcedureContext;
import com.hujiang.gradle.plugin.android.aspectjx.internal.utils.AJXUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/DoAspectProcedure;", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/AbsProcedure;", "procedureContext", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext;", "(Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext;)V", "deleteOutput", "", "inputOutput", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/DoAspectProcedure$InputOutput;", "doWorkContinuously", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "process", "processDirectoryInput", "isIncrement", "dirInput", "Lcom/android/build/api/transform/DirectoryInput;", "outputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "processJarInput", "status", "Lcom/android/build/api/transform/Status;", "runAJXTask", "InputOutput", "aspectjx"})
public final class DoAspectProcedure
extends AbsProcedure {
    public DoAspectProcedure(@NotNull ProcedureContext procedureContext) {
        Intrinsics.checkNotNullParameter((Object)procedureContext, (String)"procedureContext");
        super(procedureContext);
    }

    @Override
    public boolean doWorkContinuously(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        this.process(transformInvocation);
        this.getProcedureContext().saveBuildConfig();
        return true;
    }

    private final void process(TransformInvocation transformInvocation) {
        BatchTaskScheduler batchTaskScheduler = new BatchTaskScheduler(0, 1, null);
        boolean isIncremental = transformInvocation.isIncremental();
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Collection collection = transformInvocation.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"transformInvocation.inputs");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TransformInput transformInput = (TransformInput)element$iv;
            boolean bl = false;
            Collection collection2 = transformInput.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"transformInput.directoryInputs");
            Iterable $this$forEach$iv2 = collection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DirectoryInput dirInput = (DirectoryInput)element$iv2;
                boolean bl2 = false;
                batchTaskScheduler.schedule((Function0<Unit>)((Function0)new Function0<Unit>(this, isIncremental, dirInput, outputProvider){
                    final /* synthetic */ DoAspectProcedure this$0;
                    final /* synthetic */ boolean $isIncremental;
                    final /* synthetic */ DirectoryInput $dirInput;
                    final /* synthetic */ TransformOutputProvider $outputProvider;
                    {
                        this.this$0 = $receiver;
                        this.$isIncremental = $isIncremental;
                        this.$dirInput = $dirInput;
                        this.$outputProvider = $outputProvider;
                        super(0);
                    }

                    public final void invoke() {
                        DirectoryInput directoryInput = this.$dirInput;
                        Intrinsics.checkNotNullExpressionValue((Object)directoryInput, (String)"dirInput");
                        TransformOutputProvider transformOutputProvider = this.$outputProvider;
                        Intrinsics.checkNotNullExpressionValue((Object)transformOutputProvider, (String)"outputProvider");
                        DoAspectProcedure.access$processDirectoryInput(this.this$0, this.$isIncremental, directoryInput, transformOutputProvider);
                    }
                }));
            }
            Collection collection3 = transformInput.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"transformInput.jarInputs");
            $this$forEach$iv2 = collection3;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JarInput jarInput = (JarInput)element$iv2;
                boolean bl3 = false;
                batchTaskScheduler.schedule((Function0<Unit>)((Function0)new Function0<Unit>(jarInput, outputProvider, isIncremental, this){
                    final /* synthetic */ JarInput $jarInput;
                    final /* synthetic */ TransformOutputProvider $outputProvider;
                    final /* synthetic */ boolean $isIncremental;
                    final /* synthetic */ DoAspectProcedure this$0;
                    {
                        this.$jarInput = $jarInput;
                        this.$outputProvider = $outputProvider;
                        this.$isIncremental = $isIncremental;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        Format format = Format.JAR;
                        File inputFile = this.$jarInput.getFile();
                        File outputFile = this.$outputProvider.getContentLocation(this.$jarInput.getName(), this.$jarInput.getContentTypes(), this.$jarInput.getScopes(), format);
                        Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
                        Intrinsics.checkNotNullExpressionValue((Object)outputFile, (String)"outputFile");
                        InputOutput inputOutput = new InputOutput(format, inputFile, outputFile, outputFile);
                        Status status = this.$isIncremental ? this.$jarInput.getStatus() : Status.ADDED;
                        Intrinsics.checkNotNullExpressionValue((Object)status, (String)"status");
                        DoAspectProcedure.access$processJarInput(this.this$0, inputOutput, status);
                    }
                }));
            }
        }
        batchTaskScheduler.execute();
        batchTaskScheduler.shutDown();
    }

    private final void processDirectoryInput(boolean isIncrement, DirectoryInput dirInput, TransformOutputProvider outputProvider) {
        String[] $this$forEach$iv;
        ProcedureContext.BuildConfig buildConfig = this.getProcedureContext().getBuildConfig();
        ProcedureContext.BuildConfig lastBuildConfig = this.getProcedureContext().getLastBuildConfig();
        boolean existAspectFiles = buildConfig.existAspectFiles();
        Format format = Format.DIRECTORY;
        File dest = outputProvider.getContentLocation(dirInput.getName(), dirInput.getContentTypes(), dirInput.getScopes(), format);
        File matchedInputDir = new File(this.getProcedureContext().getWeaveTmpDir(), dirInput.getName() + File.separator + "input");
        File matchedOutputDir = new File(this.getProcedureContext().getWeaveTmpDir(), dirInput.getName() + File.separator + "output");
        Ref.BooleanRef matchedInputInvalidate = new Ref.BooleanRef();
        matchedInputInvalidate.element = this.getProcedureContext().isAspectFilesChanged();
        Function2 collectMatchedInputFile2 = (Function2)new Function2<File, Status, Unit>(this, dirInput, buildConfig, lastBuildConfig, matchedInputDir, matchedInputInvalidate, dest){
            final /* synthetic */ DoAspectProcedure this$0;
            final /* synthetic */ DirectoryInput $dirInput;
            final /* synthetic */ ProcedureContext.BuildConfig $buildConfig;
            final /* synthetic */ ProcedureContext.BuildConfig $lastBuildConfig;
            final /* synthetic */ File $matchedInputDir;
            final /* synthetic */ Ref.BooleanRef $matchedInputInvalidate;
            final /* synthetic */ File $dest;
            {
                this.this$0 = $receiver;
                this.$dirInput = $dirInput;
                this.$buildConfig = $buildConfig;
                this.$lastBuildConfig = $lastBuildConfig;
                this.$matchedInputDir = $matchedInputDir;
                this.$matchedInputInvalidate = $matchedInputInvalidate;
                this.$dest = $dest;
                super(2);
            }

            public final void invoke(@NotNull File inputFile, @NotNull Status status) {
                Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                this.this$0.logInfo("collectMatchedInputFile:" + status + '-' + inputFile.getPath());
                if (inputFile.isDirectory()) {
                    return;
                }
                String string = inputFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"inputFile.absolutePath");
                String string2 = this.$dirInput.getFile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dirInput.file.absolutePath");
                String packagePath = StringsKt.removePrefix((String)string, (CharSequence)string2);
                boolean isMatchedInput = this.$buildConfig.isMatchedInput(inputFile);
                boolean isMatchedInputLastBuild = this.$lastBuildConfig.isMatchedInput(inputFile);
                File matchedInputFile = new File(this.$matchedInputDir, packagePath);
                switch (processDirectoryInput.collectMatchedInputFile.WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: {
                        if (isMatchedInput) {
                            this.$matchedInputInvalidate.element = true;
                            FileUtils.copyFile((File)inputFile, (File)matchedInputFile);
                            break;
                        }
                        File outputFile = new File(this.$dest, packagePath);
                        FileUtils.copyFile((File)inputFile, (File)outputFile);
                        break;
                    }
                    case 2: {
                        if (isMatchedInputLastBuild) {
                            this.$matchedInputInvalidate.element = true;
                            FileUtils.copyFile((File)inputFile, (File)matchedInputFile);
                            break;
                        }
                        File outputFile = new File(this.$dest, packagePath);
                        FileUtils.copyFile((File)inputFile, (File)outputFile);
                        break;
                    }
                    case 3: {
                        if (isMatchedInputLastBuild) {
                            this.$matchedInputInvalidate.element = true;
                            FileUtils.deleteQuietly((File)matchedInputFile);
                            break;
                        }
                        File outputFile = new File(this.$dest, packagePath);
                        FileUtils.deleteQuietly((File)outputFile);
                    }
                }
            }
        };
        if (isIncrement) {
            String[] stringArray = dirInput.getChangedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"dirInput.changedFiles");
            $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                File file = (File)entry.getKey();
                Status status = (Status)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                Intrinsics.checkNotNullExpressionValue((Object)status, (String)"status");
                collectMatchedInputFile2.invoke((Object)file, (Object)status);
            }
        } else {
            File file = dirInput.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dirInput.file");
            AJXUtilsKt.eachFileRecurse(file, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>((Function2<? super File, ? super Status, Unit>)collectMatchedInputFile2){
                final /* synthetic */ Function2<File, Status, Unit> $collectMatchedInputFile;
                {
                    this.$collectMatchedInputFile = $collectMatchedInputFile;
                    super(1);
                }

                public final void invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$collectMatchedInputFile.invoke((Object)it, (Object)Status.ADDED);
                }
            }));
        }
        if (matchedInputInvalidate.element) {
            this.getProcedureContext().getBuildConfig().removeWeaveOutput(matchedInputDir);
            FileUtils.deleteQuietly((File)matchedOutputDir);
            $this$forEach$iv = matchedInputDir.list();
            if ($this$forEach$iv == null || $this$forEach$iv.length == 0) {
                return;
            }
            if (existAspectFiles) {
                Intrinsics.checkNotNullExpressionValue((Object)dest, (String)"dest");
                InputOutput inputOutput = new InputOutput(format, matchedInputDir, matchedOutputDir, dest);
                this.runAJXTask(inputOutput);
            } else {
                AJXUtilsKt.eachFileRecurse(matchedInputDir, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(matchedInputDir, dest){
                    final /* synthetic */ File $matchedInputDir;
                    final /* synthetic */ File $dest;
                    {
                        this.$matchedInputDir = $matchedInputDir;
                        this.$dest = $dest;
                        super(1);
                    }

                    public final void invoke(@NotNull File it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        String string = it.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.absolutePath");
                        String string2 = this.$matchedInputDir.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matchedInputDir.absolutePath");
                        String string3 = this.$dest.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dest.absolutePath");
                        String target = StringsKt.replaceFirst$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null);
                        FileUtils.copyFile((File)it, (File)new File(target));
                    }
                }));
            }
        }
    }

    private final void processJarInput(InputOutput inputOutput, Status status) {
        File inputFile = inputOutput.getInputFile();
        File outputFile = inputOutput.getOutputFile();
        ProcedureContext.BuildConfig buildConfig = this.getProcedureContext().getBuildConfig();
        boolean existAspectFiles = buildConfig.existAspectFiles();
        boolean isMatchedInput = buildConfig.isMatchedInput(inputFile);
        boolean needAspect = existAspectFiles && isMatchedInput;
        this.logInfo("processJarInput:" + status + '-' + inputFile.getPath());
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                if (needAspect) {
                    this.runAJXTask(inputOutput);
                    break;
                }
                FileUtils.copyFile((File)inputFile, (File)outputFile);
                break;
            }
            case 2: {
                this.deleteOutput(inputOutput);
                if (needAspect) {
                    this.runAJXTask(inputOutput);
                    break;
                }
                FileUtils.copyFile((File)inputFile, (File)outputFile);
                break;
            }
            case 3: {
                this.deleteOutput(inputOutput);
                break;
            }
            case 4: {
                if (!isMatchedInput || !this.getProcedureContext().isAspectFilesChanged()) break;
                this.deleteOutput(inputOutput);
                if (needAspect) {
                    this.runAJXTask(inputOutput);
                    break;
                }
                FileUtils.copyFile((File)inputFile, (File)outputFile);
            }
        }
    }

    private final void runAJXTask(InputOutput inputOutput) {
        ProcedureContext.CompileOptions compileOptions = this.getProcedureContext().getCompileOptions();
        Format format = inputOutput.getFormat();
        File inputFile = inputOutput.getInputFile();
        File outputFile = inputOutput.getOutputFile();
        File dest = inputOutput.getDest();
        AJXTask $this$runAJXTask_u24lambda_u2d4 = new AJXTask();
        boolean bl = false;
        $this$runAJXTask_u24lambda_u2d4.setDumpDirectory(this.getProcedureContext().getLogsDir());
        $this$runAJXTask_u24lambda_u2d4.setEncoding(compileOptions.getEncoding());
        $this$runAJXTask_u24lambda_u2d4.setSourceCompatibility(compileOptions.getSourceCompatibility());
        $this$runAJXTask_u24lambda_u2d4.setTargetCompatibility(compileOptions.getTargetCompatibility());
        $this$runAJXTask_u24lambda_u2d4.setBootClassPath(compileOptions.getBootClassPath());
        $this$runAJXTask_u24lambda_u2d4.setClassPath(compileOptions.getJavaCompileClasspath());
        $this$runAJXTask_u24lambda_u2d4.setAjcArgs(this.getProcedureContext().getBuildConfig().getExtension().getAjcArgs());
        $this$runAJXTask_u24lambda_u2d4.getAspectPath().add(this.getProcedureContext().getAspectFilesDir());
        if (format == Format.JAR) {
            $this$runAJXTask_u24lambda_u2d4.getInPath().add(inputFile);
            $this$runAJXTask_u24lambda_u2d4.setOutputJar(dest.getAbsolutePath());
        } else {
            $this$runAJXTask_u24lambda_u2d4.getInPath().add(inputFile);
            $this$runAJXTask_u24lambda_u2d4.setOutputDir(outputFile.getAbsolutePath());
        }
        long startTime = System.currentTimeMillis();
        $this$runAJXTask_u24lambda_u2d4.call();
        long cost = System.currentTimeMillis() - startTime;
        this.logInfo("weave [" + inputFile + "].[" + cost + "ms]");
        if (format == Format.JAR) {
            Object[] objectArray = new String[1];
            Intrinsics.checkNotNull((Object)$this$runAJXTask_u24lambda_u2d4.getOutputJar());
            List outputFiles = CollectionsKt.mutableListOf((Object[])objectArray);
            this.getProcedureContext().getBuildConfig().addWeaveOutput(inputFile, outputFiles, cost);
        } else {
            List outputFiles = new ArrayList();
            AJXUtilsKt.eachFileRecurse(outputFile, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(outputFile, dest, (List<String>)outputFiles){
                final /* synthetic */ File $outputFile;
                final /* synthetic */ File $dest;
                final /* synthetic */ List<String> $outputFiles;
                {
                    this.$outputFile = $outputFile;
                    this.$dest = $dest;
                    this.$outputFiles = $outputFiles;
                    super(1);
                }

                public final void invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = it.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.absolutePath");
                    String string2 = this.$outputFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outputFile.absolutePath");
                    String string3 = this.$dest.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dest.absolutePath");
                    String target = StringsKt.replaceFirst$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null);
                    this.$outputFiles.add(target);
                    FileUtils.copyFile((File)it, (File)new File(target));
                }
            }));
            this.getProcedureContext().getBuildConfig().addWeaveOutput(inputFile, outputFiles, cost);
        }
    }

    private final void deleteOutput(InputOutput inputOutput) {
        FileUtils.deleteQuietly((File)inputOutput.getOutputFile());
        this.getProcedureContext().getBuildConfig().removeWeaveOutput(inputOutput.getInputFile());
    }

    public static final /* synthetic */ void access$processDirectoryInput(DoAspectProcedure $this, boolean isIncrement, DirectoryInput dirInput, TransformOutputProvider outputProvider) {
        $this.processDirectoryInput(isIncrement, dirInput, outputProvider);
    }

    public static final /* synthetic */ void access$processJarInput(DoAspectProcedure $this, InputOutput inputOutput, Status status) {
        $this.processJarInput(inputOutput, status);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/DoAspectProcedure$InputOutput;", "", "format", "Lcom/android/build/api/transform/Format;", "inputFile", "Ljava/io/File;", "outputFile", "dest", "(Lcom/android/build/api/transform/Format;Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "getDest", "()Ljava/io/File;", "getFormat", "()Lcom/android/build/api/transform/Format;", "getInputFile", "getOutputFile", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "aspectjx"})
    public static final class InputOutput {
        @NotNull
        private final Format format;
        @NotNull
        private final File inputFile;
        @NotNull
        private final File outputFile;
        @NotNull
        private final File dest;

        public InputOutput(@NotNull Format format, @NotNull File inputFile, @NotNull File outputFile, @NotNull File dest) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            this.format = format;
            this.inputFile = inputFile;
            this.outputFile = outputFile;
            this.dest = dest;
        }

        @NotNull
        public final Format getFormat() {
            return this.format;
        }

        @NotNull
        public final File getInputFile() {
            return this.inputFile;
        }

        @NotNull
        public final File getOutputFile() {
            return this.outputFile;
        }

        @NotNull
        public final File getDest() {
            return this.dest;
        }

        @NotNull
        public final Format component1() {
            return this.format;
        }

        @NotNull
        public final File component2() {
            return this.inputFile;
        }

        @NotNull
        public final File component3() {
            return this.outputFile;
        }

        @NotNull
        public final File component4() {
            return this.dest;
        }

        @NotNull
        public final InputOutput copy(@NotNull Format format, @NotNull File inputFile, @NotNull File outputFile, @NotNull File dest) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            return new InputOutput(format, inputFile, outputFile, dest);
        }

        public static /* synthetic */ InputOutput copy$default(InputOutput inputOutput, Format format, File file, File file2, File file3, int n, Object object) {
            if ((n & 1) != 0) {
                format = inputOutput.format;
            }
            if ((n & 2) != 0) {
                file = inputOutput.inputFile;
            }
            if ((n & 4) != 0) {
                file2 = inputOutput.outputFile;
            }
            if ((n & 8) != 0) {
                file3 = inputOutput.dest;
            }
            return inputOutput.copy(format, file, file2, file3);
        }

        @NotNull
        public String toString() {
            return "InputOutput(format=" + this.format + ", inputFile=" + this.inputFile + ", outputFile=" + this.outputFile + ", dest=" + this.dest + ')';
        }

        public int hashCode() {
            int result = this.format.hashCode();
            result = result * 31 + this.inputFile.hashCode();
            result = result * 31 + this.outputFile.hashCode();
            result = result * 31 + this.dest.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InputOutput)) {
                return false;
            }
            InputOutput inputOutput = (InputOutput)other;
            if (this.format != inputOutput.format) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.inputFile, (Object)inputOutput.inputFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputFile, (Object)inputOutput.outputFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dest, (Object)inputOutput.dest);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            nArray[Status.ADDED.ordinal()] = 1;
            nArray[Status.CHANGED.ordinal()] = 2;
            nArray[Status.REMOVED.ordinal()] = 3;
            nArray[Status.NOTCHANGED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

