/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.api;

import com.t4a.api.AIAction;
import com.t4a.api.ActionGroup;
import com.t4a.api.GroupInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionList {
    private static final Logger log = LoggerFactory.getLogger(ActionList.class);
    private List<ActionGroup> groups = new ArrayList<ActionGroup>();
    private List<GroupInfo> groupInfo = new ArrayList<GroupInfo>();
    private Map<GroupInfo, String> groupActions = new HashMap<GroupInfo, String>();

    public void addAction(AIAction action) {
        ActionGroup group = new ActionGroup(action.getActionGroup(), action.getGroupDescription());
        if (this.groups.contains(group)) {
            group = this.groups.get(this.groups.indexOf(group));
        } else {
            this.groups.add(group);
            this.groupInfo.add(group.getGroupInfo());
        }
        group.addAction(action);
        String oldValue = this.groupActions.get(group.getGroupInfo());
        String value = action.getActionName();
        if (oldValue == null) {
            this.groupActions.put(group.getGroupInfo(), value);
        } else {
            value = oldValue + "," + value;
            this.groupActions.put(group.getGroupInfo(), value);
        }
    }

    public List<ActionGroup> getGroups() {
        return this.groups;
    }

    public List<GroupInfo> getGroupInfo() {
        return this.groupInfo;
    }

    public Map<GroupInfo, String> getGroupActions() {
        return this.groupActions;
    }

    public void setGroups(List<ActionGroup> groups) {
        this.groups = groups;
    }

    public void setGroupInfo(List<GroupInfo> groupInfo) {
        this.groupInfo = groupInfo;
    }

    public void setGroupActions(Map<GroupInfo, String> groupActions) {
        this.groupActions = groupActions;
    }

    public ActionList() {
    }

    public ActionList(List<ActionGroup> groups, List<GroupInfo> groupInfo, Map<GroupInfo, String> groupActions) {
        this.groups = groups;
        this.groupInfo = groupInfo;
        this.groupActions = groupActions;
    }
}

