/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.vishalmysore.a2a.domain.Message;
import io.github.vishalmysore.a2a.domain.TaskState;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public class TaskStatus {
    @JsonIgnore
    private String id;
    private TaskState state;
    private Message message;
    private String timestamp;

    public TaskStatus() {
        this.state = TaskState.SUBMITTED;
        this.setCurrentTimestamp();
    }

    public TaskStatus(TaskState state) {
        this.state = state;
        this.setCurrentTimestamp();
    }

    public TaskStatus(String state) {
        this.state = TaskState.forValue(state);
        this.setCurrentTimestamp();
    }

    private void setCurrentTimestamp() {
        this.timestamp = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
    }

    public String getId() {
        return this.id;
    }

    public TaskState getState() {
        return this.state;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    @JsonIgnore
    public void setId(String id) {
        this.id = id;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskStatus)) {
            return false;
        }
        TaskStatus other = (TaskStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        TaskState this$state = this.getState();
        TaskState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Message this$message = this.getMessage();
        Message other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        TaskState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Message $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    public String toString() {
        return "TaskStatus(id=" + this.getId() + ", state=" + this.getState() + ", message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

