/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.domain;

import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonRpcRequest {
    private String jsonrpc;
    private String method;
    private Object params;
    private Object id;

    public static JsonRpcRequest fromString(String jsonString) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (JsonRpcRequest)mapper.readValue(jsonString, JsonRpcRequest.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing JSON RPC request: " + e.getMessage(), e);
        }
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public String getMethod() {
        return this.method;
    }

    public Object getParams() {
        return this.params;
    }

    public Object getId() {
        return this.id;
    }

    public void setJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParams(Object params) {
        this.params = params;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public JsonRpcRequest(String jsonrpc, String method, Object params, Object id) {
        this.jsonrpc = jsonrpc;
        this.method = method;
        this.params = params;
        this.id = id;
    }

    public JsonRpcRequest() {
    }

    public String toString() {
        return "JsonRpcRequest(jsonrpc=" + this.getJsonrpc() + ", method=" + this.getMethod() + ", params=" + this.getParams() + ", id=" + this.getId() + ")";
    }
}

