/*
 * Decompiled with CFR 0.152.
 */
package com.github.takahirom.roborazzi;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J0\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0006\u0010\u001d\u001a\u00020\u0003J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0006\u0010\u001f\u001a\u00020\u0015J\u0006\u0010 \u001a\u00020\u0015J\u001e\u0010!\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020\u0003J\u0006\u0010#\u001a\u00020\u0015R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/github/takahirom/roborazzi/NeuQuant;", "", "thepic", "", "len", "", "sample", "([BII)V", "alphadec", "bias", "", "freq", "lengthcount", "netindex", "network", "", "[[I", "radpower", "samplefac", "thepicture", "alterneigh", "", "rad", "i", "b", "g", "r", "altersingle", "alpha", "colorMap", "contest", "inxbuild", "learn", "map", "process", "unbiasnet", "Companion", "roborazzi-painter"})
public final class NeuQuant {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int alphadec;
    @Nullable
    private byte[] thepicture;
    private int lengthcount;
    private int samplefac;
    @NotNull
    private int[][] network;
    @NotNull
    private int[] netindex = new int[256];
    @NotNull
    private int[] bias = new int[256];
    @NotNull
    private int[] freq = new int[256];
    @NotNull
    private int[] radpower = new int[32];
    private static final int netsize = 256;
    private static final int prime1 = 499;
    private static final int prime2 = 491;
    private static final int prime3 = 487;
    private static final int prime4 = 503;
    private static final int minpicturebytes = 1509;
    private static final int maxnetpos = 255;
    private static final int netbiasshift = 4;
    private static final int ncycles = 100;
    private static final int intbiasshift = 16;
    private static final int intbias = 65536;
    private static final int gammashift = 10;
    private static final int gamma = 1024;
    private static final int betashift = 10;
    private static final int beta = 64;
    private static final int betagamma = 65536;
    private static final int initrad = 32;
    private static final int radiusbiasshift = 6;
    private static final int radiusbias = 64;
    private static final int initradius = 2048;
    private static final int radiusdec = 30;
    private static final int alphabiasshift = 10;
    private static final int initalpha = 1024;
    private static final int radbiasshift = 8;
    private static final int radbias = 256;
    private static final int alpharadbshift = 18;
    private static final int alpharadbias = 262144;

    public NeuQuant(@Nullable byte[] thepic, int len, int sample) {
        int i = 0;
        int[] p = null;
        this.thepicture = thepic;
        this.lengthcount = len;
        this.samplefac = sample;
        this.network = new int[256][];
        for (i = 0; i < 256; ++i) {
            this.network[i] = new int[4];
            p = this.network[i];
            Intrinsics.checkNotNull((Object)p);
            p[2] = (i << 12) / 256;
            p[1] = p[2];
            p[0] = p[1];
            this.freq[i] = 256;
            this.bias[i] = 0;
        }
    }

    @NotNull
    public final byte[] colorMap() {
        byte[] map = new byte[768];
        int[] index = new int[256];
        int i = 0;
        while (i < 256) {
            int[] nArray = this.network[i];
            Intrinsics.checkNotNull((Object)nArray);
            index[nArray[3]] = i++;
        }
        int k = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            int j = index[i2];
            int n = k++;
            int[] nArray = this.network[j];
            Intrinsics.checkNotNull((Object)nArray);
            map[n] = (byte)nArray[0];
            int n2 = k++;
            int[] nArray2 = this.network[j];
            Intrinsics.checkNotNull((Object)nArray2);
            map[n2] = (byte)nArray2[1];
            int n3 = k++;
            int[] nArray3 = this.network[j];
            Intrinsics.checkNotNull((Object)nArray3);
            map[n3] = (byte)nArray3[2];
        }
        return map;
    }

    public final void inxbuild() {
        int i = 0;
        int j = 0;
        int smallpos = 0;
        int smallval = 0;
        int[] p = null;
        int[] q = null;
        int previouscol = 0;
        int startpos = 0;
        previouscol = 0;
        startpos = 0;
        for (i = 0; i < 256; ++i) {
            p = this.network[i];
            smallpos = i;
            Intrinsics.checkNotNull((Object)p);
            smallval = p[1];
            for (j = i + 1; j < 256; ++j) {
                q = this.network[j];
                Intrinsics.checkNotNull((Object)q);
                if (q[1] >= smallval) continue;
                smallpos = j;
                smallval = q[1];
            }
            q = this.network[smallpos];
            if (i != smallpos) {
                Intrinsics.checkNotNull((Object)q);
                j = q[0];
                q[0] = p[0];
                p[0] = j;
                j = q[1];
                q[1] = p[1];
                p[1] = j;
                j = q[2];
                q[2] = p[2];
                p[2] = j;
                j = q[3];
                q[3] = p[3];
                p[3] = j;
            }
            if (smallval == previouscol) continue;
            this.netindex[previouscol] = startpos + i >> 1;
            for (j = previouscol + 1; j < smallval; ++j) {
                this.netindex[j] = i;
            }
            previouscol = smallval;
            startpos = i;
        }
        this.netindex[previouscol] = startpos + 255 >> 1;
        for (j = previouscol + 1; j < 256; ++j) {
            this.netindex[j] = 255;
        }
    }

    public final void learn() {
        int i = 0;
        int j = 0;
        int b = 0;
        int g = 0;
        int r = 0;
        int radius = 0;
        int rad = 0;
        int alpha = 0;
        int step = 0;
        int delta = 0;
        int samplepixels = 0;
        byte[] p = null;
        int pix = 0;
        int lim = 0;
        if (this.lengthcount < 1509) {
            this.samplefac = 1;
        }
        this.alphadec = 30 + (this.samplefac - 1) / 3;
        p = this.thepicture;
        pix = 0;
        lim = this.lengthcount;
        samplepixels = this.lengthcount / (3 * this.samplefac);
        delta = samplepixels / 100;
        alpha = 1024;
        radius = 2048;
        rad = radius >> 6;
        if (rad <= 1) {
            rad = 0;
        }
        for (i = 0; i < rad; ++i) {
            this.radpower[i] = alpha * ((rad * rad - i * i) * 256 / (rad * rad));
        }
        step = this.lengthcount < 1509 ? 3 : (this.lengthcount % 499 != 0 ? 1497 : (this.lengthcount % 491 != 0 ? 1473 : (this.lengthcount % 487 != 0 ? 1461 : 1509)));
        i = 0;
        while (i < samplepixels) {
            Intrinsics.checkNotNull((Object)p);
            b = (p[pix + 0] & 0xFF) << 4;
            g = (p[pix + 1] & 0xFF) << 4;
            r = (p[pix + 2] & 0xFF) << 4;
            j = this.contest(b, g, r);
            this.altersingle(alpha, j, b, g, r);
            if (rad != 0) {
                this.alterneigh(rad, j, b, g, r);
            }
            if ((pix += step) >= lim) {
                pix -= this.lengthcount;
            }
            ++i;
            if (delta == 0) {
                delta = 1;
            }
            if (i % delta != 0) continue;
            alpha -= alpha / this.alphadec;
            if ((rad = (radius -= radius / 30) >> 6) <= 1) {
                rad = 0;
            }
            for (j = 0; j < rad; ++j) {
                this.radpower[j] = alpha * ((rad * rad - j * j) * 256 / (rad * rad));
            }
        }
    }

    public final int map(int b, int g, int r) {
        int i = 0;
        int j = 0;
        int dist = 0;
        int a = 0;
        int bestd = 0;
        int[] p = null;
        int best = 0;
        bestd = 1000;
        best = -1;
        i = this.netindex[g];
        j = i - 1;
        while (i < 256 || j >= 0) {
            if (i < 256) {
                p = this.network[i];
                Intrinsics.checkNotNull((Object)p);
                dist = p[1] - g;
                if (dist >= bestd) {
                    i = 256;
                } else {
                    ++i;
                    if (dist < 0) {
                        dist = -dist;
                    }
                    if ((a = p[0] - b) < 0) {
                        a = -a;
                    }
                    if ((dist += a) < bestd) {
                        a = p[2] - r;
                        if (a < 0) {
                            a = -a;
                        }
                        if ((dist += a) < bestd) {
                            bestd = dist;
                            best = p[3];
                        }
                    }
                }
            }
            if (j < 0) continue;
            p = this.network[j];
            Intrinsics.checkNotNull((Object)p);
            dist = g - p[1];
            if (dist >= bestd) {
                j = -1;
                continue;
            }
            --j;
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = p[0] - b) < 0) {
                a = -a;
            }
            if ((dist += a) >= bestd) continue;
            a = p[2] - r;
            if (a < 0) {
                a = -a;
            }
            if ((dist += a) >= bestd) continue;
            bestd = dist;
            best = p[3];
        }
        return best;
    }

    @NotNull
    public final byte[] process() {
        this.learn();
        this.unbiasnet();
        this.inxbuild();
        return this.colorMap();
    }

    public final void unbiasnet() {
        int i = 0;
        i = 0;
        while (i < 256) {
            int[] nArray = this.network[i];
            Intrinsics.checkNotNull((Object)nArray);
            int[] nArray2 = this.network[i];
            Intrinsics.checkNotNull((Object)nArray2);
            nArray[0] = nArray2[0] >> 4;
            int[] nArray3 = this.network[i];
            Intrinsics.checkNotNull((Object)nArray3);
            int[] nArray4 = this.network[i];
            Intrinsics.checkNotNull((Object)nArray4);
            nArray3[1] = nArray4[1] >> 4;
            int[] nArray5 = this.network[i];
            Intrinsics.checkNotNull((Object)nArray5);
            int[] nArray6 = this.network[i];
            Intrinsics.checkNotNull((Object)nArray6);
            nArray5[2] = nArray6[2] >> 4;
            int[] nArray7 = this.network[i];
            Intrinsics.checkNotNull((Object)nArray7);
            nArray7[3] = i++;
        }
    }

    private final void alterneigh(int rad, int i, int b, int g, int r) {
        int j = 0;
        int k = 0;
        int lo = 0;
        int hi = 0;
        int a = 0;
        int m = 0;
        int[] p = null;
        lo = i - rad;
        if (lo < -1) {
            lo = -1;
        }
        if ((hi = i + rad) > 256) {
            hi = 256;
        }
        j = i + 1;
        k = i - 1;
        m = 1;
        while (j < hi || k > lo) {
            int[] nArray;
            a = this.radpower[m++];
            if (j < hi) {
                p = this.network[j++];
                try {
                    Intrinsics.checkNotNull((Object)p);
                    nArray = p;
                    nArray[0] = nArray[0] - a * (p[0] - b) / 262144;
                    nArray = p;
                    nArray[1] = nArray[1] - a * (p[1] - g) / 262144;
                    nArray = p;
                    nArray[2] = nArray[2] - a * (p[2] - r) / 262144;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (k <= lo) continue;
            p = this.network[k--];
            try {
                Intrinsics.checkNotNull((Object)p);
                nArray = p;
                nArray[0] = nArray[0] - a * (p[0] - b) / 262144;
                nArray = p;
                nArray[1] = nArray[1] - a * (p[1] - g) / 262144;
                nArray = p;
                nArray[2] = nArray[2] - a * (p[2] - r) / 262144;
            }
            catch (Exception exception) {}
        }
    }

    private final void altersingle(int alpha, int i, int b, int g, int r) {
        int[] n = this.network[i];
        Intrinsics.checkNotNull((Object)n);
        int[] nArray = n;
        nArray[0] = nArray[0] - alpha * (n[0] - b) / 1024;
        n[1] = n[1] - alpha * (n[1] - g) / 1024;
        n[2] = n[2] - alpha * (n[2] - r) / 1024;
    }

    private final int contest(int b, int g, int r) {
        int n;
        int[] nArray;
        int i = 0;
        int dist = 0;
        int a = 0;
        int biasdist = 0;
        int betafreq = 0;
        int bestpos = 0;
        int bestbiaspos = 0;
        int bestd = 0;
        int bestbiasd = 0;
        int[] n2 = null;
        bestbiasd = bestd = Integer.MAX_VALUE;
        bestbiaspos = bestpos = -1;
        i = 0;
        while (i < 256) {
            n2 = this.network[i];
            Intrinsics.checkNotNull((Object)n2);
            dist = n2[0] - b;
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = n2[1] - g) < 0) {
                a = -a;
            }
            dist += a;
            a = n2[2] - r;
            if (a < 0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                bestd = dist;
                bestpos = i;
            }
            if ((biasdist = dist - (this.bias[i] >> 12)) < bestbiasd) {
                bestbiasd = biasdist;
                bestbiaspos = i;
            }
            betafreq = this.freq[i] >> 10;
            nArray = this.freq;
            n = i;
            nArray[n] = nArray[n] - betafreq;
            nArray = this.bias;
            n = i++;
            nArray[n] = nArray[n] + (betafreq << 10);
        }
        nArray = this.freq;
        n = bestpos;
        nArray[n] = nArray[n] + 64;
        nArray = this.bias;
        n = bestpos;
        nArray[n] = nArray[n] - 65536;
        return bestbiaspos;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/takahirom/roborazzi/NeuQuant$Companion;", "", "()V", "alphabiasshift", "", "alpharadbias", "alpharadbshift", "beta", "betagamma", "betashift", "gamma", "gammashift", "initalpha", "initrad", "initradius", "intbias", "intbiasshift", "maxnetpos", "minpicturebytes", "ncycles", "netbiasshift", "netsize", "prime1", "prime2", "prime3", "prime4", "radbias", "radbiasshift", "radiusbias", "radiusbiasshift", "radiusdec", "roborazzi-painter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

