/*
 * Decompiled with CFR 0.152.
 */
package com.github.takahirom.roborazzi;

import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b*\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 Z2\u00020\u0001:\u0001ZB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010I\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\u0003J\u0018\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010OJ\u0010\u0010P\u001a\u00020K2\b\u0010N\u001a\u0004\u0018\u00010OJ\u000e\u0010Q\u001a\u00020K2\u0006\u00102\u001a\u00020\u0003J\u0018\u0010R\u001a\u00020K2\u0006\u0010S\u001a\u00020\u00032\b\u0010N\u001a\u0004\u0018\u00010OJ\u0010\u0010T\u001a\u00020K2\b\u0010U\u001a\u0004\u0018\u00010OJ\u0010\u0010V\u001a\u00020K2\b\u0010N\u001a\u0004\u0018\u00010OJ\b\u0010W\u001a\u00020\u0003H\u0002J\u0018\u0010X\u001a\u00020K2\u0006\u0010Y\u001a\u00020\u00032\b\u0010N\u001a\u0004\u0018\u00010OR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u000b\"\u0004\b(\u0010\rR\u001a\u0010)\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u000b\"\u0004\b+\u0010\rR\u001a\u0010,\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u000b\"\u0004\b.\u0010\rR\u001a\u0010/\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000b\"\u0004\b1\u0010\rR\u001a\u00102\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u000b\"\u0004\b4\u0010\rR\u001a\u00105\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\"\"\u0004\b7\u0010$R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\"\"\u0004\b;\u0010$R\u001a\u0010<\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u000b\"\u0004\b>\u0010\rR\u001a\u0010?\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u000b\"\u0004\bA\u0010\rR\u001a\u0010B\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u000b\"\u0004\bD\u0010\rR\u001a\u0010E\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u000b\"\u0004\bG\u0010\rR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/github/takahirom/roborazzi/LZWEncoder;", "", "imgW", "", "imgH", "pixAry", "", "color_depth", "(II[BI)V", "ClearCode", "getClearCode", "()I", "setClearCode", "(I)V", "EOFCode", "getEOFCode", "setEOFCode", "a_count", "getA_count", "setA_count", "accum", "getAccum", "()[B", "setAccum", "([B)V", "clear_flg", "", "getClear_flg", "()Z", "setClear_flg", "(Z)V", "codetab", "", "getCodetab", "()[I", "setCodetab", "([I)V", "curPixel", "cur_accum", "getCur_accum", "setCur_accum", "cur_bits", "getCur_bits", "setCur_bits", "free_ent", "getFree_ent", "setFree_ent", "g_init_bits", "getG_init_bits", "setG_init_bits", "hsize", "getHsize", "setHsize", "htab", "getHtab", "setHtab", "initCodeSize", "masks", "getMasks", "setMasks", "maxbits", "getMaxbits", "setMaxbits", "maxcode", "getMaxcode", "setMaxcode", "maxmaxcode", "getMaxmaxcode", "setMaxmaxcode", "n_bits", "getN_bits", "setN_bits", "remaining", "MAXCODE", "char_out", "", "c", "", "outs", "Ljava/io/OutputStream;", "cl_block", "cl_hash", "compress", "init_bits", "encode", "os", "flush_char", "nextPixel", "output", "code", "Companion", "roborazzi-painter"})
@SourceDebugExtension(value={"SMAP\nAnimatedGifEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimatedGifEncoder.kt\ncom/github/takahirom/roborazzi/LZWEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1285:1\n1#2:1286\n*E\n"})
public final class LZWEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int imgW;
    private final int imgH;
    @Nullable
    private final byte[] pixAry;
    private final int initCodeSize;
    private int remaining;
    private int curPixel;
    private int n_bits;
    private int maxbits;
    private int maxcode;
    private int maxmaxcode;
    @NotNull
    private int[] htab;
    @NotNull
    private int[] codetab;
    private int hsize;
    private int free_ent;
    private boolean clear_flg;
    private int g_init_bits;
    private int ClearCode;
    private int EOFCode;
    private int cur_accum;
    private int cur_bits;
    @NotNull
    private int[] masks;
    private int a_count;
    @NotNull
    private byte[] accum;
    private static final int EOF = -1;
    public static final int BITS = 12;
    public static final int HSIZE = 5003;

    public LZWEncoder(int imgW, int imgH, @Nullable byte[] pixAry, int color_depth) {
        this.imgW = imgW;
        this.imgH = imgH;
        this.pixAry = pixAry;
        this.maxbits = 12;
        this.maxmaxcode = 4096;
        this.htab = new int[5003];
        this.codetab = new int[5003];
        this.hsize = 5003;
        int[] nArray = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
        this.masks = nArray;
        this.accum = new byte[256];
        this.initCodeSize = Math.max(2, color_depth);
    }

    public final int getN_bits() {
        return this.n_bits;
    }

    public final void setN_bits(int n) {
        this.n_bits = n;
    }

    public final int getMaxbits() {
        return this.maxbits;
    }

    public final void setMaxbits(int n) {
        this.maxbits = n;
    }

    public final int getMaxcode() {
        return this.maxcode;
    }

    public final void setMaxcode(int n) {
        this.maxcode = n;
    }

    public final int getMaxmaxcode() {
        return this.maxmaxcode;
    }

    public final void setMaxmaxcode(int n) {
        this.maxmaxcode = n;
    }

    @NotNull
    public final int[] getHtab() {
        return this.htab;
    }

    public final void setHtab(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.htab = nArray;
    }

    @NotNull
    public final int[] getCodetab() {
        return this.codetab;
    }

    public final void setCodetab(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.codetab = nArray;
    }

    public final int getHsize() {
        return this.hsize;
    }

    public final void setHsize(int n) {
        this.hsize = n;
    }

    public final int getFree_ent() {
        return this.free_ent;
    }

    public final void setFree_ent(int n) {
        this.free_ent = n;
    }

    public final boolean getClear_flg() {
        return this.clear_flg;
    }

    public final void setClear_flg(boolean bl) {
        this.clear_flg = bl;
    }

    public final int getG_init_bits() {
        return this.g_init_bits;
    }

    public final void setG_init_bits(int n) {
        this.g_init_bits = n;
    }

    public final int getClearCode() {
        return this.ClearCode;
    }

    public final void setClearCode(int n) {
        this.ClearCode = n;
    }

    public final int getEOFCode() {
        return this.EOFCode;
    }

    public final void setEOFCode(int n) {
        this.EOFCode = n;
    }

    public final int getCur_accum() {
        return this.cur_accum;
    }

    public final void setCur_accum(int n) {
        this.cur_accum = n;
    }

    public final int getCur_bits() {
        return this.cur_bits;
    }

    public final void setCur_bits(int n) {
        this.cur_bits = n;
    }

    @NotNull
    public final int[] getMasks() {
        return this.masks;
    }

    public final void setMasks(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.masks = nArray;
    }

    public final int getA_count() {
        return this.a_count;
    }

    public final void setA_count(int n) {
        this.a_count = n;
    }

    @NotNull
    public final byte[] getAccum() {
        return this.accum;
    }

    public final void setAccum(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.accum = byArray;
    }

    public final void char_out(byte c, @Nullable OutputStream outs) throws IOException {
        int n = this.a_count;
        this.a_count = n + 1;
        this.accum[n] = c;
        if (this.a_count >= 254) {
            this.flush_char(outs);
        }
    }

    public final void cl_block(@Nullable OutputStream outs) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outs);
    }

    public final void cl_hash(int hsize) {
        for (int i = 0; i < hsize; ++i) {
            this.htab[i] = -1;
        }
    }

    public final void compress(int init_bits, @Nullable OutputStream outs) throws IOException {
        int fcode = 0;
        int i = 0;
        int c = 0;
        int ent = 0;
        int disp = 0;
        int hsize_reg = 0;
        int hshift = 0;
        this.g_init_bits = init_bits;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << init_bits - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.a_count = 0;
        ent = this.nextPixel();
        hshift = 0;
        for (fcode = this.hsize; fcode < 65536; fcode *= 2) {
            ++hshift;
        }
        hshift = 8 - hshift;
        hsize_reg = this.hsize;
        this.cl_hash(hsize_reg);
        this.output(this.ClearCode, outs);
        block1: while (true) {
            int n;
            int it = n = this.nextPixel();
            boolean bl = false;
            c = it;
            if (n == -1) break;
            i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                disp = hsize_reg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    it = disp;
                    boolean bl2 = false;
                    if ((i -= it) < 0) {
                        i += hsize_reg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent, outs);
            ent = c;
            if (this.free_ent < this.maxmaxcode) {
                n = this.free_ent;
                this.free_ent = n + 1;
                this.codetab[i] = n;
                this.htab[i] = fcode;
                continue;
            }
            this.cl_block(outs);
        }
        this.output(ent, outs);
        this.output(this.EOFCode, outs);
    }

    public final void encode(@Nullable OutputStream os) throws IOException {
        OutputStream outputStream = os;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(this.initCodeSize);
        this.remaining = this.imgW * this.imgH;
        this.curPixel = 0;
        this.compress(this.initCodeSize + 1, os);
        os.write(0);
    }

    public final void flush_char(@Nullable OutputStream outs) throws IOException {
        if (this.a_count > 0) {
            OutputStream outputStream = outs;
            Intrinsics.checkNotNull((Object)outputStream);
            outputStream.write(this.a_count);
            outs.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    public final int MAXCODE(int n_bits) {
        return (1 << n_bits) - 1;
    }

    private final int nextPixel() {
        if (this.remaining == 0) {
            return -1;
        }
        this.remaining += -1;
        Intrinsics.checkNotNull((Object)this.pixAry);
        int n = this.curPixel;
        this.curPixel = n + 1;
        byte pix = this.pixAry[n];
        return pix & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public final void output(int code, @Nullable OutputStream outs) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? this.cur_accum | code << this.cur_bits : code;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outs);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                void it;
                int n;
                int n2 = n = this.g_init_bits;
                LZWEncoder lZWEncoder = this;
                LZWEncoder lZWEncoder2 = this;
                boolean bl = false;
                this.n_bits = it;
                Unit unit = Unit.INSTANCE;
                lZWEncoder2.maxcode = lZWEncoder.MAXCODE(n);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                int n = this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (code == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outs);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outs);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/takahirom/roborazzi/LZWEncoder$Companion;", "", "()V", "BITS", "", "EOF", "HSIZE", "roborazzi-painter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

