/*
 * Decompiled with CFR 0.152.
 */
package com.github.takahirom.roborazzi;

import android.graphics.Bitmap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/github/takahirom/roborazzi/BitmapToBufferedImageConverter;", "", "()V", "bitmapToImage", "Ljava/awt/image/BufferedImage;", "pixels", "", "width", "", "height", "convert", "bitmap", "Landroid/graphics/Bitmap;", "roborazzi-painter"})
public final class BitmapToBufferedImageConverter {
    @NotNull
    public static final BitmapToBufferedImageConverter INSTANCE = new BitmapToBufferedImageConverter();

    private BitmapToBufferedImageConverter() {
    }

    @NotNull
    public final BufferedImage convert(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)this.bitmapToImage(pixels, width, height), 0, 0, null);
        g.dispose();
        return image;
    }

    private final BufferedImage bitmapToImage(int[] pixels, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        image.setRGB(0, 0, width, height, pixels, 0, width);
        return image;
    }
}

