/*
 * Decompiled with CFR 0.152.
 */
package com.github.takahirom.roborazzi;

import com.github.takahirom.roborazzi.AwtRoboCanvas;
import com.github.takahirom.roborazzi.LZWEncoder;
import com.github.takahirom.roborazzi.NeuQuant;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\u0010H\u0002J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001eH\u0002J\u0006\u0010*\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0006J\u000e\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0006J\u000e\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0006J\u000e\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0006J\u0016\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0006J\u0010\u00109\u001a\u00020\u00102\b\u0010)\u001a\u0004\u0018\u00010\u001eJ\u0010\u0010:\u001a\u00020\u00042\b\u0010;\u001a\u0004\u0018\u00010\u0015J\u0010\u0010:\u001a\u00020\u00042\b\u0010<\u001a\u0004\u0018\u00010=J\b\u0010>\u001a\u00020\u0010H\u0002J\b\u0010?\u001a\u00020\u0010H\u0002J\b\u0010@\u001a\u00020\u0010H\u0002J\b\u0010A\u001a\u00020\u0010H\u0002J\b\u0010B\u001a\u00020\u0010H\u0002J\b\u0010C\u001a\u00020\u0010H\u0002J\u0010\u0010D\u001a\u00020\u00102\u0006\u0010E\u001a\u00020\u0006H\u0002J\u0010\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020=H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/github/takahirom/roborazzi/AnimatedGifEncoder;", "", "()V", "closeStream", "", "colorDepth", "", "colorTab", "", "delay", "dispose", "firstFrame", "height", "image", "Ljava/awt/image/BufferedImage;", "imagePixels", "", "getImagePixels", "()Lkotlin/Unit;", "indexedPixels", "out", "Ljava/io/OutputStream;", "palSize", "pixels", "repeat", "sample", "sizeSet", "started", "transIndex", "transparent", "Ljava/awt/Color;", "usedEntry", "", "width", "addFrame", "canvas", "Lcom/github/takahirom/roborazzi/AwtRoboCanvas;", "resizeImage", "", "analyzePixels", "findClosest", "c", "finish", "setDelay", "ms", "setDispose", "code", "setFrameRate", "fps", "", "setQuality", "quality", "setRepeat", "iter", "setSize", "w", "h", "setTransparent", "start", "os", "file", "", "writeGraphicCtrlExt", "writeImageDesc", "writeLSD", "writeNetscapeExt", "writePalette", "writePixels", "writeShort", "value", "writeString", "s", "roborazzi-painter"})
@SourceDebugExtension(value={"SMAP\nAnimatedGifEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimatedGifEncoder.kt\ncom/github/takahirom/roborazzi/AnimatedGifEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1285:1\n1#2:1286\n*E\n"})
public final class AnimatedGifEncoder {
    private int width;
    private int height;
    @Nullable
    private Color transparent;
    private int transIndex;
    private int repeat = -1;
    private int delay;
    private boolean started;
    @Nullable
    private OutputStream out;
    @Nullable
    private BufferedImage image;
    @Nullable
    private byte[] pixels;
    @Nullable
    private byte[] indexedPixels;
    private int colorDepth;
    @Nullable
    private byte[] colorTab;
    @NotNull
    private boolean[] usedEntry = new boolean[256];
    private int palSize = 7;
    private int dispose = -1;
    private boolean closeStream;
    private boolean firstFrame = true;
    private boolean sizeSet;
    private int sample = 10;

    public final void setDelay(int ms) {
        this.delay = Math.round((float)ms / 10.0f);
    }

    public final void setDispose(int code) {
        if (code >= 0) {
            this.dispose = code;
        }
    }

    public final void setRepeat(int iter) {
        if (iter >= 0) {
            this.repeat = iter;
        }
    }

    public final void setTransparent(@Nullable Color c) {
        this.transparent = c;
    }

    public final boolean addFrame(@NotNull AwtRoboCanvas canvas, double resizeImage) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        BufferedImage im = canvas.outputImage$roborazzi_painter(resizeImage);
        if (!this.started) {
            return false;
        }
        boolean ok = true;
        try {
            if (!this.sizeSet) {
                this.setSize(im.getWidth(), im.getHeight());
            }
            this.image = im;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
        }
        catch (IOException e) {
            ok = false;
        }
        return ok;
    }

    public final boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean ok = true;
        this.started = false;
        try {
            OutputStream outputStream = this.out;
            Intrinsics.checkNotNull((Object)outputStream);
            outputStream.write(59);
            OutputStream outputStream2 = this.out;
            Intrinsics.checkNotNull((Object)outputStream2);
            outputStream2.flush();
            if (this.closeStream) {
                OutputStream outputStream3 = this.out;
                Intrinsics.checkNotNull((Object)outputStream3);
                outputStream3.close();
            }
        }
        catch (IOException e) {
            ok = false;
        }
        this.transIndex = 0;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return ok;
    }

    public final void setFrameRate(float fps) {
        if (!(fps == 0.0f)) {
            this.delay = Math.round(100.0f / fps);
        }
    }

    public final void setQuality(int quality) {
        int localQuality = quality;
        if (localQuality < 1) {
            localQuality = 1;
        }
        this.sample = localQuality;
    }

    public final void setSize(int w, int h) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = w;
        this.height = h;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public final boolean start(@Nullable OutputStream os) {
        boolean bl;
        if (os == null) {
            return false;
        }
        boolean ok = true;
        this.closeStream = false;
        this.out = os;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException e) {
            ok = false;
        }
        boolean it = bl = ok;
        boolean bl2 = false;
        this.started = it;
        return bl;
    }

    public final boolean start(@Nullable String file) {
        boolean bl;
        boolean ok = false;
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(file));
            ok = this.start(this.out);
            this.closeStream = true;
        }
        catch (IOException e) {
            ok = false;
        }
        boolean it = bl = ok;
        boolean bl2 = false;
        this.started = it;
        return bl;
    }

    private final void analyzePixels() {
        Intrinsics.checkNotNull((Object)this.pixels);
        int len = this.pixels.length;
        int nPix = len / 3;
        this.indexedPixels = new byte[nPix];
        NeuQuant nq = new NeuQuant(this.pixels, len, this.sample);
        this.colorTab = nq.process();
        AnimatedGifEncoder $this$analyzePixels_u24lambda_u242 = this;
        boolean bl = false;
        int i = 0;
        while (true) {
            Intrinsics.checkNotNull((Object)$this$analyzePixels_u24lambda_u242.colorTab);
            if (i >= $this$analyzePixels_u24lambda_u242.colorTab.length) break;
            Intrinsics.checkNotNull((Object)$this$analyzePixels_u24lambda_u242.colorTab);
            byte temp = $this$analyzePixels_u24lambda_u242.colorTab[i];
            Intrinsics.checkNotNull((Object)$this$analyzePixels_u24lambda_u242.colorTab);
            Intrinsics.checkNotNull((Object)$this$analyzePixels_u24lambda_u242.colorTab);
            $this$analyzePixels_u24lambda_u242.colorTab[i] = $this$analyzePixels_u24lambda_u242.colorTab[i + 2];
            Intrinsics.checkNotNull((Object)$this$analyzePixels_u24lambda_u242.colorTab);
            $this$analyzePixels_u24lambda_u242.colorTab[i + 2] = temp;
            $this$analyzePixels_u24lambda_u242.usedEntry[i / 3] = false;
            i += 3;
        }
        int k = 0;
        for (int i2 = 0; i2 < nPix; ++i2) {
            Intrinsics.checkNotNull((Object)this.pixels);
            int n = this.pixels[k++] & 0xFF;
            Intrinsics.checkNotNull((Object)this.pixels);
            int n2 = this.pixels[k++] & 0xFF;
            Intrinsics.checkNotNull((Object)this.pixels);
            int index = nq.map(n, n2, this.pixels[k++] & 0xFF);
            this.usedEntry[index] = true;
            Intrinsics.checkNotNull((Object)this.indexedPixels);
            this.indexedPixels[i2] = (byte)index;
        }
        this.pixels = null;
        this.colorDepth = 8;
        this.palSize = 7;
        if (this.transparent != null) {
            Color color = this.transparent;
            Intrinsics.checkNotNull((Object)color);
            this.transIndex = this.findClosest(color);
        }
    }

    private final int findClosest(Color c) {
        if (this.colorTab == null) {
            return -1;
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int minpos = 0;
        int dmin = 0x1000000;
        Intrinsics.checkNotNull((Object)this.colorTab);
        int len = this.colorTab.length;
        for (int i = 0; i < len; ++i) {
            Intrinsics.checkNotNull((Object)this.colorTab);
            int dr = r - (this.colorTab[i++] & 0xFF);
            Intrinsics.checkNotNull((Object)this.colorTab);
            int dg = g - (this.colorTab[i++] & 0xFF);
            Intrinsics.checkNotNull((Object)this.colorTab);
            int db = b - (this.colorTab[i] & 0xFF);
            int d = dr * dr + dg * dg + db * db;
            int index = i / 3;
            if (!this.usedEntry[index] || d >= dmin) continue;
            dmin = d;
            minpos = index;
        }
        return minpos;
    }

    private final Unit getImagePixels() {
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        int w = bufferedImage.getWidth();
        BufferedImage bufferedImage2 = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage2);
        int h = bufferedImage2.getHeight();
        BufferedImage bufferedImage3 = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage3);
        int type = bufferedImage3.getType();
        if (w != this.width || h != this.height || type != 5) {
            BufferedImage temp = new BufferedImage(this.width, this.height, 5);
            Graphics2D g = temp.createGraphics();
            g.drawImage((Image)this.image, 0, 0, null);
            this.image = temp;
        }
        BufferedImage bufferedImage4 = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage4);
        DataBuffer dataBuffer = bufferedImage4.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferByte");
        this.pixels = ((DataBufferByte)dataBuffer).getData();
        return Unit.INSTANCE;
    }

    private final void writeGraphicCtrlExt() throws IOException {
        OutputStream outputStream = this.out;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(33);
        OutputStream outputStream2 = this.out;
        Intrinsics.checkNotNull((Object)outputStream2);
        outputStream2.write(249);
        OutputStream outputStream3 = this.out;
        Intrinsics.checkNotNull((Object)outputStream3);
        outputStream3.write(4);
        int transp = 0;
        int disp = 0;
        if (this.transparent == null) {
            transp = 0;
            disp = 0;
        } else {
            transp = 1;
            disp = 2;
        }
        if (this.dispose >= 0) {
            disp = this.dispose & 7;
        }
        OutputStream outputStream4 = this.out;
        Intrinsics.checkNotNull((Object)outputStream4);
        outputStream4.write(0 | (disp <<= 2) | 0 | transp);
        this.writeShort(this.delay);
        OutputStream outputStream5 = this.out;
        Intrinsics.checkNotNull((Object)outputStream5);
        outputStream5.write(this.transIndex);
        OutputStream outputStream6 = this.out;
        Intrinsics.checkNotNull((Object)outputStream6);
        outputStream6.write(0);
    }

    private final void writeImageDesc() throws IOException {
        OutputStream outputStream = this.out;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.firstFrame) {
            OutputStream outputStream2 = this.out;
            Intrinsics.checkNotNull((Object)outputStream2);
            outputStream2.write(0);
        } else {
            OutputStream outputStream3 = this.out;
            Intrinsics.checkNotNull((Object)outputStream3);
            outputStream3.write(0x80 | this.palSize);
        }
    }

    private final void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        OutputStream outputStream = this.out;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(0xF0 | this.palSize);
        OutputStream outputStream2 = this.out;
        Intrinsics.checkNotNull((Object)outputStream2);
        outputStream2.write(0);
        OutputStream outputStream3 = this.out;
        Intrinsics.checkNotNull((Object)outputStream3);
        outputStream3.write(0);
    }

    private final void writeNetscapeExt() throws IOException {
        OutputStream outputStream = this.out;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(33);
        OutputStream outputStream2 = this.out;
        Intrinsics.checkNotNull((Object)outputStream2);
        outputStream2.write(255);
        OutputStream outputStream3 = this.out;
        Intrinsics.checkNotNull((Object)outputStream3);
        outputStream3.write(11);
        this.writeString("NETSCAPE2.0");
        OutputStream outputStream4 = this.out;
        Intrinsics.checkNotNull((Object)outputStream4);
        outputStream4.write(3);
        OutputStream outputStream5 = this.out;
        Intrinsics.checkNotNull((Object)outputStream5);
        outputStream5.write(1);
        this.writeShort(this.repeat);
        OutputStream outputStream6 = this.out;
        Intrinsics.checkNotNull((Object)outputStream6);
        outputStream6.write(0);
    }

    private final void writePalette() throws IOException {
        OutputStream outputStream = this.out;
        Intrinsics.checkNotNull((Object)outputStream);
        Intrinsics.checkNotNull((Object)this.colorTab);
        outputStream.write(this.colorTab, 0, this.colorTab.length);
        Intrinsics.checkNotNull((Object)this.colorTab);
        int n = 768 - this.colorTab.length;
        for (int i = 0; i < n; ++i) {
            OutputStream outputStream2 = this.out;
            Intrinsics.checkNotNull((Object)outputStream2);
            outputStream2.write(0);
        }
    }

    private final void writePixels() throws IOException {
        LZWEncoder encoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        encoder.encode(this.out);
    }

    private final void writeShort(int value) throws IOException {
        OutputStream outputStream = this.out;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(value & 0xFF);
        OutputStream outputStream2 = this.out;
        Intrinsics.checkNotNull((Object)outputStream2);
        outputStream2.write(value >> 8 & 0xFF);
    }

    private final void writeString(String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            OutputStream outputStream = this.out;
            Intrinsics.checkNotNull((Object)outputStream);
            outputStream.write((byte)s.charAt(i));
        }
    }
}

