/*
 * Decompiled with CFR 0.152.
 */
package io.github.sudharsan_selvaraj;

import io.github.sudharsan_selvaraj.DriverEventDispatcher;
import io.github.sudharsan_selvaraj.SpyDriverListener;
import io.github.sudharsan_selvaraj.SpyDriverOptions;
import io.github.sudharsan_selvaraj.interceptor.DriverInterceptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.openqa.selenium.WebDriver;

public class SpyDriver<T extends WebDriver> {
    private DriverEventDispatcher eventDispatcher;
    private T originalDriver;
    private T mockDriver;

    public SpyDriver(T driver) {
        this(driver, SpyDriverOptions.builder().build());
    }

    public SpyDriver(T driver, SpyDriverOptions options) {
        this.originalDriver = driver;
        this.eventDispatcher = this.getEventDispatcher(options);
        this.mockDriver = (WebDriver)Mockito.mock(SpyDriver.getSpyInstanceClass(driver), (Answer)new DriverInterceptor(driver, this.eventDispatcher));
    }

    private DriverEventDispatcher getEventDispatcher(SpyDriverOptions options) {
        DriverEventDispatcher eventDispatcher = new DriverEventDispatcher();
        if (options.getListener() != null) {
            eventDispatcher.addListener(options.getListener());
        }
        return eventDispatcher;
    }

    public void addListener(SpyDriverListener listener) {
        this.eventDispatcher.addListener(listener);
    }

    public T getWrappedDriver() {
        return this.originalDriver;
    }

    public T getSpyDriver() {
        return this.mockDriver;
    }

    private static <T extends WebDriver> Class<?> getSpyInstanceClass(T driver) {
        return driver.getClass();
    }
}

