/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift.pushdown;

import io.github.spark_redshift_community.spark.redshift.RedshiftRelation;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftPlan;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftSQLStatement;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftScanExec;
import io.github.spark_redshift_community.spark.redshift.pushdown.querygeneration.QueryBuilder$;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkStrategy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4Aa\u0002\u0005\u0001+!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00035\u0001\u0011\u0005Q\u0007C\u0004:\u0001\t\u0007I\u0011\u0002\u001e\t\r\r\u0003\u0001\u0015!\u0003<\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0005A\u0011V\rZ:iS\u001a$8\u000b\u001e:bi\u0016<\u0017P\u0003\u0002\n\u0015\u0005A\u0001/^:iI><hN\u0003\u0002\f\u0019\u0005A!/\u001a3tQ&4GO\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0019gB\f'o[0sK\u0012\u001c\b.\u001b4u?\u000e|W.\\;oSRL(BA\t\u0013\u0003\u00199\u0017\u000e\u001e5vE*\t1#\u0001\u0002j_\u000e\u00011C\u0001\u0001\u0017!\t9BF\u0004\u0002\u0019S9\u0011\u0011D\n\b\u00035\u0011r!aG\u0011\u000f\u0005qyR\"A\u000f\u000b\u0005y!\u0012A\u0002\u001fs_>$h(C\u0001!\u0003\ry'oZ\u0005\u0003E\r\na!\u00199bG\",'\"\u0001\u0011\n\u00055)#B\u0001\u0012$\u0013\t9\u0003&A\u0002tc2T!!D\u0013\n\u0005)Z\u0013a\u00029bG.\fw-\u001a\u0006\u0003O!J!!\f\u0018\u0003\u0011M#(/\u0019;fOfT!AK\u0016\u0002\u000fM,7o]5p]B\u0011\u0011GM\u0007\u0002W%\u00111g\u000b\u0002\r'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005YB\u0004CA\u001c\u0001\u001b\u0005A\u0001\"B\u0018\u0003\u0001\u0004\u0001\u0014!\u0004'B5f{6i\u0014(G?.+\u0015,F\u0001<!\ta\u0014)D\u0001>\u0015\tqt(\u0001\u0003mC:<'\"\u0001!\u0002\t)\fg/Y\u0005\u0003\u0005v\u0012aa\u0015;sS:<\u0017A\u0004'B5f{6i\u0014(G?.+\u0015\fI\u0001\u0006CB\u0004H.\u001f\u000b\u0003\rZ\u00032aR'Q\u001d\tA5J\u0004\u0002\u001d\u0013&\t!*A\u0003tG\u0006d\u0017-\u0003\u0002+\u0019*\t!*\u0003\u0002O\u001f\n\u00191+Z9\u000b\u0005)b\u0005CA)U\u001b\u0005\u0011&BA*,\u0003%)\u00070Z2vi&|g.\u0003\u0002V%\nI1\u000b]1sWBc\u0017M\u001c\u0005\u0006/\u0016\u0001\r\u0001W\u0001\u0005a2\fg\u000e\u0005\u0002ZA6\t!L\u0003\u0002\\9\u00069An\\4jG\u0006d'BA/_\u0003\u0015\u0001H.\u00198t\u0015\ty6&\u0001\u0005dCR\fG._:u\u0013\t\t'LA\u0006M_\u001eL7-\u00197QY\u0006t\u0017!\u00042vS2$\u0017+^3ssJ#E\t\u0006\u0002eQB\u0019QM\u001a$\u000e\u00031K!a\u001a'\u0003\r=\u0003H/[8o\u0011\u00159f\u00011\u0001Y\u0001")
public class RedshiftStrategy
extends SparkStrategy {
    private final SparkSession session;
    private final String LAZY_CONF_KEY;

    private String LAZY_CONF_KEY() {
        return this.LAZY_CONF_KEY;
    }

    public Seq<SparkPlan> apply(LogicalPlan plan) {
        Seq seq;
        try {
            seq = (Seq)this.buildQueryRDD((LogicalPlan)plan.transform((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Project) {
                        Project project = (Project)A1;
                        Seq seq = project.projectList();
                        LogicalPlan child = project.child();
                        if (Nil$.MODULE$.equals(seq)) {
                            object = child;
                            return (B1)object;
                        }
                    }
                    if (A1 instanceof SubqueryAlias) {
                        SubqueryAlias subqueryAlias = (SubqueryAlias)A1;
                        LogicalPlan child = subqueryAlias.child();
                        object = child;
                        return (B1)object;
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    Project project;
                    Seq seq;
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof Project && Nil$.MODULE$.equals(seq = (project = (Project)logicalPlan).projectList()) ? true : logicalPlan instanceof SubqueryAlias;
                    return bl;
                }
            })).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        }
        catch (UnsupportedOperationException t) {
            this.log().warn(new StringBuilder(22).append("Unsupported Operation:").append(t.getMessage()).toString());
            seq = Nil$.MODULE$;
        }
        catch (Exception e) {
            this.log().warn(new StringBuilder(16).append("Pushdown failed:").append(e.getMessage()).toString(), (Throwable)e);
            seq = Nil$.MODULE$;
        }
        return seq;
    }

    private Option<Seq<SparkPlan>> buildQueryRDD(LogicalPlan plan) {
        Option option;
        boolean useLazyMode = new StringOps(Predef$.MODULE$.augmentString(this.session.conf().get(this.LAZY_CONF_KEY(), "true"))).toBoolean();
        if (useLazyMode) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "Using lazy mode for redshift query push down");
            option = QueryBuilder$.MODULE$.getQueryFromPlan(plan).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple3 tuple3 = x0$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Seq output = (Seq)tuple3._1();
                RedshiftSQLStatement query = (RedshiftSQLStatement)tuple3._2();
                RedshiftRelation relation = (RedshiftRelation)((Object)((Object)tuple3._3()));
                Seq seq = (Seq)new .colon.colon((Object)new RedshiftScanExec((Seq<Attribute>)output, query, relation), (List)Nil$.MODULE$);
                return seq;
            });
        } else {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Using eager mode for redshift query push down. To improve performance please run ").append("`SET ").append(this.LAZY_CONF_KEY()).append("=true`").toString());
            option = QueryBuilder$.MODULE$.getRDDFromPlan(plan).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq output = (Seq)tuple2._1();
                RDD rdd = (RDD)tuple2._2();
                Seq seq = (Seq)new .colon.colon((Object)new RedshiftPlan((Seq<Attribute>)output, (RDD<InternalRow>)rdd), (List)Nil$.MODULE$);
                return seq;
            });
        }
        return option;
    }

    public RedshiftStrategy(SparkSession session) {
        this.session = session;
        this.LAZY_CONF_KEY = "spark.datasource.redshift.community.autopushdown.lazyMode";
    }
}

