/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import io.github.spark_redshift_community.spark.redshift.BuildInfo$;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.Utils;
import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Utils$ {
    public static Utils$ MODULE$;
    private final Logger log;
    private String lastBuildStmt;
    private String lastTempPathGenerated;
    private final String DEFAULT_APP_NAME;
    private final String CONNECTOR_SERVICE_NAME_ENV_VAR;

    static {
        new Utils$();
    }

    private Logger log() {
        return this.log;
    }

    public String lastBuildStmt() {
        return this.lastBuildStmt;
    }

    public void lastBuildStmt_$eq(String x$1) {
        this.lastBuildStmt = x$1;
    }

    public Class<?> classForName(String className) {
        ClassLoader classLoader = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader());
        return Class.forName(className, true, classLoader);
    }

    public String joinUrls(String a, String b) {
        return new StringBuilder(2).append(new StringOps(Predef$.MODULE$.augmentString(a)).stripSuffix("/")).append("/").append(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(b)).stripPrefix("/"))).stripSuffix("/")).append("/").toString();
    }

    public String fixS3Url(String url) {
        return url.replaceAll("s3[an]://", "s3://");
    }

    public AmazonS3URI createS3URI(String url) {
        AmazonS3URI amazonS3URI;
        try {
            amazonS3URI = new AmazonS3URI(url);
        }
        catch (Throwable throwable) {
            IllegalArgumentException illegalArgumentException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof IllegalArgumentException) || !(illegalArgumentException = (IllegalArgumentException)throwable2).getMessage().startsWith("Invalid S3 URI: hostname does not appear to be a valid S3 endpoint")) {
                throw throwable;
            }
            AmazonS3URI amazonS3URI2 = new AmazonS3URI(this.addEndpointToUrl(url, this.addEndpointToUrl$default$2()));
            amazonS3URI = amazonS3URI2;
        }
        return amazonS3URI;
    }

    public String addEndpointToUrl(String url, String domain) {
        URI uri = new URI(url);
        String hostWithEndpoint = new StringBuilder(1).append(uri.getHost()).append(".").append(domain).toString();
        return new URI(uri.getScheme(), uri.getUserInfo(), hostWithEndpoint, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
    }

    public String addEndpointToUrl$default$2() {
        return "s3.amazonaws.com";
    }

    public URI removeCredentialsFromURI(URI uri) {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public String lastTempPathGenerated() {
        return this.lastTempPathGenerated;
    }

    public void lastTempPathGenerated_$eq(String x$1) {
        this.lastTempPathGenerated = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public String makeTempPath(String tempRoot) {
        void var2_2;
        String _lastTempPathGenerated = this.joinUrls(tempRoot, UUID.randomUUID().toString());
        this.lastTempPathGenerated_$eq(_lastTempPathGenerated);
        return var2_2;
    }

    public boolean checkThatBucketHasObjectLifecycleConfiguration(String tempDir, AmazonS3 s3Client) {
        boolean bl;
        try {
            AmazonS3URI s3URI = this.createS3URI(this.fixS3Url(tempDir));
            String bucket = s3URI.getBucket();
            Predef$.MODULE$.assert(bucket != null, (Function0 & Serializable & scala.Serializable)() -> "Could not get bucket from S3 URI");
            String key = (String)Option$.MODULE$.apply((Object)s3URI.getKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            Seq rules = (Seq)Option$.MODULE$.apply((Object)s3Client.getBucketLifecycleConfiguration(bucket)).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getRules()).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
            boolean hasMatchingBucketLifecycleRule = rules.exists((Function1 & Serializable & scala.Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkThatBucketHasObjectLifecycleConfiguration$5(key, rule)));
            if (!hasMatchingBucketLifecycleRule) {
                this.log().warn(new StringBuilder(346).append("The S3 bucket ").append(bucket).append(" does not have an object lifecycle configuration to ").append("ensure cleanup of temporary files. Consider configuring `tempdir` to point to a ").append("bucket with an object lifecycle policy that automatically deletes files after an ").append("expiration period. For more information, see ").append("https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html").toString());
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            this.log().warn("An error occurred while trying to read the S3 bucket lifecycle configuration");
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public void assertThatFileSystemIsNotS3BlockFileSystem(URI uri, Configuration hadoopConfig) {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConfig);
        String string = fs.getClass().getCanonicalName();
        String string2 = "org.apache.hadoop.fs.s3.S3FileSystem";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("spark-redshift does not support the S3 Block FileSystem. Please reconfigure `tempdir` touse a s3n:// or s3a:// scheme.");
        }
    }

    public Option<String> getRegionForS3Bucket(String tempDir, AmazonS3 s3Client) {
        None$ none$;
        try {
            AmazonS3URI s3URI = this.createS3URI(this.fixS3Url(tempDir));
            String bucket = s3URI.getBucket();
            Predef$.MODULE$.assert(bucket != null, (Function0 & Serializable & scala.Serializable)() -> "Could not get bucket from S3 URI");
            String string = s3Client.headBucket(new HeadBucketRequest(bucket)).getBucketRegion();
            boolean bl = string == null ? true : "US".equals(string);
            String string2 = bl ? "us-east-1" : string;
            String region = string2;
            none$ = new Some((Object)region);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn("An error occurred while trying to determine the S3 bucket's region", e);
            None$ none$2 = None$.MODULE$;
            none$ = none$2;
        }
        return none$;
    }

    public Option<String> getRegionForRedshiftCluster(String url) {
        None$ none$;
        String string;
        Regex regionRegex = new StringOps(Predef$.MODULE$.augmentString(".*\\.([^.]+)\\.redshift\\.amazonaws\\.com.*")).r();
        Option option = regionRegex.unapplySeq((CharSequence)(string = url));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String region = (String)((LinearSeqOptimized)option.get()).apply(0);
            none$ = new Some((Object)region);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void checkRedshiftAndS3OnSameRegion(Parameters.MergedParameters params, AmazonS3 s3Client) {
        this.getRegionForRedshiftCluster(params.jdbcUrl()).foreach((Function1 & Serializable & scala.Serializable)redshiftRegion -> {
            Utils$.$anonfun$checkRedshiftAndS3OnSameRegion$1(params, s3Client, redshiftRegion);
            return BoxedUnit.UNIT;
        });
    }

    public void checkRedshiftAndS3OnSameRegionParquetWrite(Parameters.MergedParameters params, AmazonS3 s3Client) {
        Option<String> redshiftRegion = this.getRegionForRedshiftCluster(params.jdbcUrl());
        if (redshiftRegion.isEmpty()) {
            this.log().warn("Unable to determine region for redshift cluster, copy may fail if S3 bucket region does not match redshift cluster region.");
            return;
        }
        Option<String> s3Region = this.getRegionForS3Bucket(params.rootTempDir(), s3Client);
        if (s3Region.isEmpty()) {
            this.log().warn("Unable to determine region for S3 bucket, copy may fail if redshift cluster region does not match S3 bucket region.");
            return;
        }
        if (!BoxesRunTime.equals((Object)redshiftRegion.get(), (Object)s3Region.get())) {
            this.log().error(new StringBuilder(161).append("The Redshift cluster and S3 bucket are in different regions ").append("(").append(redshiftRegion).append(" and ").append(s3Region).append(", respectively). Cross-region copy operation is not ").append("available when tempformat is set to parquet").toString());
            throw new IllegalArgumentException("Redshift cluster and S3 bucket are in different regions when tempformat is set to parquet");
        }
    }

    public Regions getDefaultTempDirRegion(Option<String> tempDirRegion) {
        if (tempDirRegion.isDefined()) {
            return Regions.fromName((String)((String)tempDirRegion.get()));
        }
        Region currRegion = Regions.getCurrentRegion();
        if (currRegion == null) {
            this.log().warn(new StringBuilder(259).append("The connector cannot automatically determine a region for 'tempdir'. It ").append("is highly recommended that the 'tempdir_region' parameter is set to ").append("avoid a performance penalty while trying to automatically determine ").append("a region, especially when operating outside of AWS.").toString());
        }
        return currRegion != null ? Regions.fromName((String)currRegion.getName()) : Regions.US_EAST_1;
    }

    public Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientBuilder() {
        return (Function2 & Serializable & scala.Serializable)(awsCredentials, mergedParameters) -> (AmazonS3)((AwsSyncClientBuilder)((AmazonS3Builder)AmazonS3Client.builder().withRegion(MODULE$.getDefaultTempDirRegion(mergedParameters.tempDirRegion()))).withForceGlobalBucketAccessEnabled(Predef$.MODULE$.boolean2Boolean(true)).withCredentials(awsCredentials)).build();
    }

    public void collectMetrics(Parameters.MergedParameters params, Option<Logger> logger) {
        block2: {
            Logger metricLogger = (Logger)logger.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.log());
            metricLogger.info(BuildInfo$.MODULE$.toString());
            if (BuildInfo$.MODULE$.version().contains("-amzn-")) {
                metricLogger.info("amazon-spark-redshift-connector");
            }
            if (params.legacyJdbcRealTypeMapping()) {
                metricLogger.info(new StringBuilder(11).append(Parameters$.MODULE$.PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING()).append(" is enabled").toString());
            }
            if (!params.overrideNullable()) break block2;
            metricLogger.info(new StringBuilder(11).append(Parameters$.MODULE$.PARAM_OVERRIDE_NULLABLE()).append(" is enabled").toString());
        }
    }

    public Option<Logger> collectMetrics$default$2() {
        return None$.MODULE$;
    }

    public String DEFAULT_APP_NAME() {
        return this.DEFAULT_APP_NAME;
    }

    private String CONNECTOR_SERVICE_NAME_ENV_VAR() {
        return this.CONNECTOR_SERVICE_NAME_ENV_VAR;
    }

    public Option<String> connectorServiceName() {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(System.getenv()).asScala()).get((Object)this.CONNECTOR_SERVICE_NAME_ENV_VAR()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$connectorServiceName$1(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.trim());
    }

    public String queryGroupInfo(Utils.MetricOperation operation, String label) {
        int MAX_SVC_LENGTH = 30;
        int MAX_LBL_LENGTH = 100;
        String svcName = (String)this.connectorServiceName().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String trimmedSvcName = svcName.substring(0, package$.MODULE$.min(svcName.length(), MAX_SVC_LENGTH));
        String trimmedLabel = label.substring(0, package$.MODULE$.min(label.length(), MAX_LBL_LENGTH));
        return new StringBuilder(41).append("{\"").append(this.DEFAULT_APP_NAME()).append("\":{\"svc\":\"").append(trimmedSvcName).append("\",").append("\"ver\":\"").append(BuildInfo$.MODULE$.version()).append("\",\"op\":\"").append(operation).append("\",\"lbl\":\"").append(trimmedLabel).append("\"}}").toString();
    }

    public <T> T retry(int count, long delay, Function0<T> retryBlock) {
        Object object;
        while (true) {
            try {
                object = retryBlock.apply();
            }
            catch (Throwable e) {
                if (count <= 0) {
                    throw e;
                }
                this.log().warn(new StringBuilder(85).append("Sleeping ").append(delay).append(" milliseconds before proceeding to retry redshift operation;").append(" ").append(count).append(" retries remain").toString());
                Thread.sleep(delay);
                --count;
                continue;
            }
            break;
        }
        return (T)object;
    }

    public void copyProperty(String name, Map<String, String> sourceProps, Properties destProps) {
        this.copyProperty(name, name, sourceProps, destProps);
    }

    public void copyProperty(String searchName, String replaceName, Map<String, String> sourceProps, Properties destProps) {
        sourceProps.get((Object)searchName).foreach((Function1 & Serializable & scala.Serializable)x$4 -> destProps.setProperty(replaceName, (String)x$4));
    }

    public void copyProperties(String matchRegex, String searchRegex, String replaceName, Map<String, String> sourceProps, Properties destProps) {
        sourceProps.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            BoxedUnit boxedUnit = key.matches(matchRegex) ? destProps.setProperty(key.replaceFirst(searchRegex, replaceName), value) : BoxedUnit.UNIT;
            return boxedUnit;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkThatBucketHasObjectLifecycleConfiguration$5(String key$1, BucketLifecycleConfiguration.Rule rule) {
        String string = rule.getStatus();
        String string2 = "Enabled";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (rule.getPrefix() == null) return true;
        if (!key$1.startsWith(rule.getPrefix())) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$checkRedshiftAndS3OnSameRegion$2(String redshiftRegion$1, Parameters.MergedParameters params$1, String s3Region) {
        block0: {
            String string = redshiftRegion$1;
            String string2 = s3Region;
            if (!(string == null ? string2 != null : !string.equals(string2)) || !params$1.tempDirRegion().isEmpty()) break block0;
            MODULE$.log().error(new StringBuilder(238).append("The Redshift cluster and S3 bucket are in different regions ").append("(").append(redshiftRegion$1).append(" and ").append(s3Region).append(", respectively). In order to perform this cross-region ").append("operation, you should set the tempdir_region parameter to '").append(s3Region).append("'. ").append("For more details on cross-region usage, see the README.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$checkRedshiftAndS3OnSameRegion$1(Parameters.MergedParameters params$1, AmazonS3 s3Client$1, String redshiftRegion) {
        MODULE$.getRegionForS3Bucket(params$1.rootTempDir(), s3Client$1).foreach((Function1 & Serializable & scala.Serializable)s3Region -> {
            Utils$.$anonfun$checkRedshiftAndS3OnSameRegion$2(redshiftRegion, params$1, s3Region);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$connectorServiceName$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    private Utils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.lastTempPathGenerated = null;
        this.DEFAULT_APP_NAME = "spark-redshift-connector";
        this.CONNECTOR_SERVICE_NAME_ENV_VAR = "AWS_SPARK_REDSHIFT_CONNECTOR_SERVICE_NAME";
    }
}

