/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import io.github.spark_redshift_community.spark.redshift.AWSCredentialsUtils$;
import io.github.spark_redshift_community.spark.redshift.Conversions$;
import io.github.spark_redshift_community.spark.redshift.DefaultJDBCWrapper$;
import io.github.spark_redshift_community.spark.redshift.FilterPushdown$;
import io.github.spark_redshift_community.spark.redshift.JDBCWrapper;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.RedshiftFileFormat;
import io.github.spark_redshift_community.spark.redshift.RedshiftRelation$;
import io.github.spark_redshift_community.spark.redshift.RedshiftWriter;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.Utils$Read$;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftSQLStatement;
import io.github.spark_redshift_community.spark.redshift.pushdown.SqlToS3TempCache$;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rEf!\u0002\u001b6\u0001Vz\u0004\u0002\u00032\u0001\u0005+\u0007I\u0011\u00013\t\u0011%\u0004!\u0011#Q\u0001\n\u0015D\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\n\u0003W\u0001!\u0011#Q\u0001\n1D!\"!\f\u0001\u0005+\u0007I\u0011AA\u0018\u0011%\t\t\u0004\u0001B\tB\u0003%\u0011\u0010\u0003\u0006\u00024\u0001\u0011)\u001a!C\u0001\u0003kA!\"!\u0013\u0001\u0005#\u0005\u000b\u0011BA\u001c\u0011)\tY\u0005\u0001BC\u0002\u0013\u0005\u0011Q\n\u0005\u000b\u0003/\u0002!\u0011!Q\u0001\n\u0005=\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\n\u0003g\u0002!\u0019!C\u0005\u0003kB\u0001\"a\"\u0001A\u0003%\u0011q\u000f\u0005\u000b\u0003\u0013\u0003\u0001R1A\u0005B\u0005-\u0005bBAG\u0001\u0011\u0005\u0013q\u0012\u0005\b\u0003#\u0003A\u0011IAJ\u0011\u001d\t9\r\u0001C!\u0003\u0013Dq!a7\u0001\t\u0013\ti\u000eC\u0004\u0002f\u0002!\t%a:\t\u000f\t\r\u0001\u0001\"\u0011\u0003\u0006!9!q\u0001\u0001\u0005\n\t%\u0001b\u0002B\u0004\u0001\u0011%!Q\u0004\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007BqA!\u0019\u0001\t\u0013\u0011\u0019\u0007C\u0004\u0003h\u0001!IA!\u001b\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\"9!Q\u0012\u0001\u0005\n\t=\u0005b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u0011\u001d\u0011\u0019\u000e\u0001C\u0005\u0005+DqAa=\u0001\t\u0013\u0011)\u0010C\u0005\u0003~\u0002\t\t\u0011\"\u0001\u0003\u0000\"I1Q\u0002\u0001\u0012\u0002\u0013\u00051q\u0002\u0005\n\u0007K\u0001\u0011\u0013!C\u0001\u0007OA\u0011ba\u000b\u0001#\u0003%\ta!\f\t\u0013\rE\u0002!%A\u0005\u0002\rM\u0002\"CB\u001c\u0001\u0005\u0005I\u0011IB\u001d\u0011%\u0019Y\u0004AA\u0001\n\u0003\u0019i\u0004C\u0005\u0004F\u0001\t\t\u0011\"\u0001\u0004H!I1Q\n\u0001\u0002\u0002\u0013\u00053q\n\u0005\n\u0007/\u0002\u0011\u0011!C\u0001\u00073B\u0011b!\u0018\u0001\u0003\u0003%\tea\u0018\t\u0013\r\u0005\u0004!!A\u0005B\r\rt\u0001CB4k!\u0005Qg!\u001b\u0007\u000fQ*\u0004\u0012A\u001b\u0004l!9\u0011\u0011\r\u0018\u0005\u0002\rM\u0004bBB;]\u0011\u00051q\u000f\u0005\n\u0007\u000fs\u0013\u0011!CA\u0007\u0013C\u0011ba&/\u0003\u0003%\ti!'\t\u0013\r\u001df&!A\u0005\n\r%&\u0001\u0005*fIND\u0017N\u001a;SK2\fG/[8o\u0015\t1t'\u0001\u0005sK\u0012\u001c\b.\u001b4u\u0015\tA\u0014(A\u0003ta\u0006\u00148N\u0003\u0002;w\u0005A2\u000f]1sW~\u0013X\rZ:iS\u001a$xlY8n[Vt\u0017\u000e^=\u000b\u0005qj\u0014AB4ji\",(MC\u0001?\u0003\tIwnE\u0004\u0001\u00016\u00036+W0\u0011\u0005\u0005[U\"\u0001\"\u000b\u0005\r#\u0015aB:pkJ\u001cWm\u001d\u0006\u0003\u000b\u001a\u000b1a]9m\u0015\tAtI\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<\u0017B\u0001'C\u00051\u0011\u0015m]3SK2\fG/[8o!\t\te*\u0003\u0002P\u0005\n\u0011\u0002K];oK\u00124\u0015\u000e\u001c;fe\u0016$7kY1o!\t\t\u0015+\u0003\u0002S\u0005\n\u0011\u0012J\\:feR\f'\r\\3SK2\fG/[8o!\t!v+D\u0001V\u0015\t1f)\u0001\u0005j]R,'O\\1m\u0013\tAVKA\u0004M_\u001e<\u0017N\\4\u0011\u0005ikV\"A.\u000b\u0003q\u000bQa]2bY\u0006L!AX.\u0003\u000fA\u0013x\u000eZ;diB\u0011!\fY\u0005\u0003Cn\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f1B\u001b3cG^\u0013\u0018\r\u001d9fe\u000e\u0001Q#A3\u0011\u0005\u0019<W\"A\u001b\n\u0005!,$a\u0003&E\u0005\u000e;&/\u00199qKJ\fAB\u001b3cG^\u0013\u0018\r\u001d9fe\u0002\nqb]\u001aDY&,g\u000e\u001e$bGR|'/_\u000b\u0002YB1!,\\8z\u00037I!A\\.\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u00019x\u001b\u0005\t(B\u0001:t\u0003\u0011\tW\u000f\u001e5\u000b\u0005Q,\u0018!C1nCj|g.Y<t\u0015\u00051\u0018aA2p[&\u0011\u00010\u001d\u0002\u0017\u0003^\u001b6I]3eK:$\u0018.\u00197t!J|g/\u001b3feB\u0019!0!\u0006\u000f\u0007m\f\tBD\u0002}\u0003\u001fq1!`A\u0007\u001d\rq\u00181\u0002\b\u0004\u007f\u0006%a\u0002BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u00151-\u0001\u0004=e>|GOP\u0005\u0002}%\u0011A(P\u0005\u0003umJ!\u0001O\u001d\n\u0005Y:\u0014bAA\nk\u0005Q\u0001+\u0019:b[\u0016$XM]:\n\t\u0005]\u0011\u0011\u0004\u0002\u0011\u001b\u0016\u0014x-\u001a3QCJ\fW.\u001a;feNT1!a\u00056!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t!a]\u001a\u000b\u0007\u0005\u00152/\u0001\u0005tKJ4\u0018nY3t\u0013\u0011\tI#a\b\u0003\u0011\u0005k\u0017M_8o'N\n\u0001c]\u001aDY&,g\u000e\u001e$bGR|'/\u001f\u0011\u0002\rA\f'/Y7t+\u0005I\u0018a\u00029be\u0006l7\u000fI\u0001\u000bkN,'oU2iK6\fWCAA\u001c!\u0015Q\u0016\u0011HA\u001f\u0013\r\tYd\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011E\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t9%!\u0011\u0003\u0015M#(/^2u)f\u0004X-A\u0006vg\u0016\u00148k\u00195f[\u0006\u0004\u0013AC:rY\u000e{g\u000e^3yiV\u0011\u0011q\n\t\u0005\u0003#\n\u0019&D\u0001E\u0013\r\t)\u0006\u0012\u0002\u000b'Fc5i\u001c8uKb$\u0018aC:rY\u000e{g\u000e^3yi\u0002B3ACA.!\rQ\u0016QL\u0005\u0004\u0003?Z&!\u0003;sC:\u001c\u0018.\u001a8u\u0003\u0019a\u0014N\\5u}QQ\u0011QMA6\u0003[\ny'!\u001d\u0015\t\u0005\u001d\u0014\u0011\u000e\t\u0003M\u0002Aq!a\u0013\f\u0001\u0004\ty\u0005C\u0003c\u0017\u0001\u0007Q\rC\u0003k\u0017\u0001\u0007A\u000e\u0003\u0004\u0002.-\u0001\r!\u001f\u0005\b\u0003gY\u0001\u0019AA\u001c\u0003M!\u0018M\u00197f\u001d\u0006lWm\u0014:Tk\n\fX/\u001a:z+\t\t9\b\u0005\u0003\u0002z\u0005\u0005e\u0002BA>\u0003{\u00022!!\u0001\\\u0013\r\tyhW\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0015Q\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}4,\u0001\u000buC\ndWMT1nK>\u00138+\u001e2rk\u0016\u0014\u0018\u0010I\u0001\u0007g\u000eDW-\\1\u0016\u0005\u0005u\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0014AB5og\u0016\u0014H\u000f\u0006\u0004\u0002\u0016\u0006m\u0015Q\u0018\t\u00045\u0006]\u0015bAAM7\n!QK\\5u\u0011\u001d\ti\n\u0005a\u0001\u0003?\u000bA\u0001Z1uCB!\u0011\u0011UA\\\u001d\u0011\t\u0019+a-\u000f\t\u0005\u0015\u0016\u0011\u0017\b\u0005\u0003O\u000byK\u0004\u0003\u0002*\u00065f\u0002BA\u0001\u0003WK\u0011AS\u0005\u0003\u0011&K!\u0001O$\n\u0005\u00153\u0015bAA[\t\u00069\u0001/Y2lC\u001e,\u0017\u0002BA]\u0003w\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005UF\tC\u0004\u0002@B\u0001\r!!1\u0002\u0013=4XM]<sSR,\u0007c\u0001.\u0002D&\u0019\u0011QY.\u0003\u000f\t{w\u000e\\3b]\u0006\u0001RO\u001c5b]\u0012dW\r\u001a$jYR,'o\u001d\u000b\u0005\u0003\u0017\f9\u000eE\u0003[\u0003\u001b\f\t.C\u0002\u0002Pn\u0013Q!\u0011:sCf\u00042!QAj\u0013\r\t)N\u0011\u0002\u0007\r&dG/\u001a:\t\u000f\u0005e\u0017\u00031\u0001\u0002L\u00069a-\u001b7uKJ\u001c\u0018AE2iK\u000e\\7k\r\"vG.,G/V:bO\u0016$b!!&\u0002`\u0006\u0005\bBBA\u0017%\u0001\u0007\u0011\u0010C\u0004\u0002dJ\u0001\r!a\u0007\u0002\u0011M\u001c4\t\\5f]R\f\u0011BY;jY\u0012\u001c6-\u00198\u0015\r\u0005%\u00181 B\u0001!\u0019\tY/!=\u0002v6\u0011\u0011Q\u001e\u0006\u0004\u0003_4\u0015a\u0001:eI&!\u00111_Aw\u0005\r\u0011F\t\u0012\t\u0005\u0003#\n90C\u0002\u0002z\u0012\u00131AU8x\u0011\u001d\tip\u0005a\u0001\u0003\u007f\fqB]3rk&\u0014X\rZ\"pYVlgn\u001d\t\u00065\u00065\u0017q\u000f\u0005\b\u00033\u001c\u0002\u0019AAf\u00039qW-\u001a3D_:4XM]:j_:,\"!!1\u0002\u001f\t,\u0018\u000e\u001c3V]2|\u0017\rZ*u[R$B\"a\u001e\u0003\f\t5!q\u0002B\n\u0005/Aq!!@\u0016\u0001\u0004\ty\u0010C\u0004\u0002ZV\u0001\r!a3\t\u000f\tEQ\u00031\u0001\u0002x\u00059A/Z7q\t&\u0014\bB\u0002B\u000b+\u0001\u0007q.A\u0003de\u0016$7\u000fC\u0004\u0003\u001aU\u0001\rAa\u0007\u0002\u0013M\u001cXmS7t\u0017\u0016L\b#\u0002.\u0002:\u0005]D\u0003DA<\u0005?\u0011yC!\r\u00034\tU\u0002b\u0002B\u0011-\u0001\u0007!1E\u0001\ngR\fG/Z7f]R\u0004BA!\n\u0003,5\u0011!q\u0005\u0006\u0004\u0005S)\u0014\u0001\u00039vg\"$wn\u001e8\n\t\t5\"q\u0005\u0002\u0015%\u0016$7\u000f[5giN\u000bFj\u0015;bi\u0016lWM\u001c;\t\u000f\u0005%e\u00031\u0001\u0002>!9!\u0011\u0003\fA\u0002\u0005]\u0004B\u0002B\u000b-\u0001\u0007q\u000eC\u0004\u0003\u001aY\u0001\rAa\u0007\u0002\u0017A\u0014XO\\3TG\",W.\u0019\u000b\u0007\u0003{\u0011YD!\u0010\t\u000f\u0005%u\u00031\u0001\u0002>!9!qH\fA\u0002\u0005}\u0018aB2pYVlgn]\u0001\u0011EVLG\u000eZ*dC:4%o\\7T#2+BA!\u0012\u0003NQ1!q\tB/\u0005?\u0002b!a;\u0002r\n%\u0003\u0003\u0002B&\u0005\u001bb\u0001\u0001B\u0004\u0002zb\u0011\rAa\u0014\u0012\t\tE#q\u000b\t\u00045\nM\u0013b\u0001B+7\n9aj\u001c;iS:<\u0007c\u0001.\u0003Z%\u0019!1L.\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\"a\u0001\rAa\t\t\u000f\u0005%\u0005\u00041\u0001\u00028\u0005!r)\u001a;DC\u000eDW\rZ*4#V,'/\u001f)bi\"$BAa\u0007\u0003f!9!\u0011E\rA\u0002\t\r\u0012AD+oY>\fG\rR1uCR{7k\r\u000b\u000b\u00057\u0011YG!\u001c\u0003\u0000\t\r\u0005b\u0002B\u00115\u0001\u0007!1\u0005\u0005\b\u0005_R\u0002\u0019\u0001B9\u0003\u0011\u0019wN\u001c8\u0011\t\tM$1P\u0007\u0003\u0005kR1!\u0012B<\u0015\t\u0011I(\u0001\u0003kCZ\f\u0017\u0002\u0002B?\u0005k\u0012!bQ8o]\u0016\u001cG/[8o\u0011\u001d\u0011\tI\u0007a\u0001\u0003{\tAB]3tk2$8k\u00195f[\u0006DaA!\u0006\u001b\u0001\u0004y\u0017aG2p]Z,'\u000f^\"p[BdW\r\u001f+za\u0016\u001cHk\\*ue&tw\r\u0006\u0003\u0002>\t%\u0005b\u0002BF7\u0001\u0007\u0011QH\u0001\fS:\u0004X\u000f^*dQ\u0016l\u0017-A\u000bnCB\u001cu.\u001c9mKb$\u0016\u0010]3t)>T5o\u001c8\u0015\t\tE%Q\u0014\t\t\u0003s\u0012\u0019*a\u001e\u0003\u0018&!!QSAC\u0005\ri\u0015\r\u001d\t\u0005\u0003#\u0012I*C\u0002\u0003\u001c\u0012\u0013aaQ8mk6t\u0007b\u0002BF9\u0001\u0007\u0011QH\u0001\be\u0016\fGM\u0015#E+\u0011\u0011\u0019K!+\u0015\r\t\u0015&Q\u0016BX!\u0019\tY/!=\u0003(B!!1\nBU\t\u001d\u0011Y+\bb\u0001\u0005\u001f\u0012\u0011\u0001\u0016\u0005\b\u0005\u0003k\u0002\u0019AA\u001f\u0011\u001d\u0011\t,\ba\u0001\u0005g\u000b1BZ5mKN$vNU3bIB1!Q\u0017B_\u0003orAAa.\u0003<:!\u0011\u0011\u0001B]\u0013\u0005a\u0016bAA[7&!!q\u0018Ba\u0005\r\u0019V-\u001d\u0006\u0004\u0003k[\u0016A\u0005:fC\u0012\u0014F\t\u0012$s_6\u0004\u0016M]9vKR,BAa2\u0003NR1!\u0011\u001aBh\u0005#\u0004b!a;\u0002r\n-\u0007\u0003\u0002B&\u0005\u001b$qAa+\u001f\u0005\u0004\u0011y\u0005C\u0004\u0003\u0002z\u0001\r!!\u0010\t\u000f\tEf\u00041\u0001\u00034\u0006qq-\u001a;GS2,7\u000fV8SK\u0006$W\u0003\u0002Bl\u0005c$bA!7\u0003n\n=\bC\u0002Bn\u0005C\u0014\u0019/\u0004\u0002\u0003^*\u0019!q\\.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003@\nu\u0007\u0003\u0002Bs\u0005Wl!Aa:\u000b\t\t%(qO\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0004\n\u001d\bB\u0002B\u000b?\u0001\u0007q\u000eC\u0004\u0003\u0012}\u0001\r!a\u001e\u0005\u000f\u0005exD1\u0001\u0003P\u0005yq-\u001a;SKN,H\u000e^*dQ\u0016l\u0017\r\u0006\u0005\u0002>\t](\u0011 B~\u0011\u001d\u0011\t\u0003\ta\u0001\u0005GAq!!#!\u0001\u0004\t9\u0004C\u0004\u0003p\u0001\u0002\rA!\u001d\u0002\t\r|\u0007/\u001f\u000b\u000b\u0007\u0003\u0019)aa\u0002\u0004\n\r-A\u0003BA4\u0007\u0007Aq!a\u0013\"\u0001\u0004\ty\u0005C\u0004cCA\u0005\t\u0019A3\t\u000f)\f\u0003\u0013!a\u0001Y\"A\u0011QF\u0011\u0011\u0002\u0003\u0007\u0011\u0010C\u0005\u00024\u0005\u0002\n\u00111\u0001\u00028\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB\tU\r)71C\u0016\u0003\u0007+\u0001Baa\u0006\u0004\"5\u00111\u0011\u0004\u0006\u0005\u00077\u0019i\"A\u0005v]\u000eDWmY6fI*\u00191qD.\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004$\re!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAB\u0015U\ra71C\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019yCK\u0002z\u0007'\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u00046)\"\u0011qGB\n\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1]\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0007\u007f\u00012AWB!\u0013\r\u0019\u0019e\u0017\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005/\u001aI\u0005C\u0005\u0004L!\n\t\u00111\u0001\u0004@\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0015\u0011\r\tm71\u000bB,\u0013\u0011\u0019)F!8\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0003\u001cY\u0006C\u0005\u0004L)\n\t\u00111\u0001\u0003X\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0004@\u00051Q-];bYN$B!!1\u0004f!I11\n\u0017\u0002\u0002\u0003\u0007!qK\u0001\u0011%\u0016$7\u000f[5giJ+G.\u0019;j_:\u0004\"A\u001a\u0018\u0014\t9\u001aig\u0018\t\u00045\u000e=\u0014bAB97\n1\u0011I\\=SK\u001a$\"a!\u001b\u0002!M\u001c\u0007.Z7b)f\u0004Xm]'bi\u000eDGCBAa\u0007s\u001a\u0019\tC\u0004\u0004|A\u0002\ra! \u0002\u000fM\u001c\u0007.Z7bcA!\u0011qHB@\u0013\u0011\u0019\t)!\u0011\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dqa!\"1\u0001\u0004\u0019i(A\u0004tG\",W.\u0019\u001a\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\r-5qRBI\u0007'\u001b)\n\u0006\u0003\u0002h\r5\u0005bBA&c\u0001\u0007\u0011q\n\u0005\u0006EF\u0002\r!\u001a\u0005\u0006UF\u0002\r\u0001\u001c\u0005\u0007\u0003[\t\u0004\u0019A=\t\u000f\u0005M\u0012\u00071\u0001\u00028\u00059QO\\1qa2LH\u0003BBN\u0007G\u0003RAWA\u001d\u0007;\u0003\u0002BWBPK2L\u0018qG\u0005\u0004\u0007C[&A\u0002+va2,G\u0007C\u0005\u0004&J\n\t\u00111\u0001\u0002h\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007W\u0003BA!:\u0004.&!1q\u0016Bt\u0005\u0019y%M[3di\u0002")
public class RedshiftRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
Logging,
Product,
scala.Serializable {
    private StructType schema;
    private final JDBCWrapper jdbcWrapper;
    private final Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory;
    private final Parameters.MergedParameters params;
    private final Option<StructType> userSchema;
    private final transient SQLContext sqlContext;
    private final String tableNameOrSubquery;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<JDBCWrapper, Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3>, Parameters.MergedParameters, Option<StructType>>> unapply(RedshiftRelation redshiftRelation) {
        return RedshiftRelation$.MODULE$.unapply(redshiftRelation);
    }

    public static RedshiftRelation apply(JDBCWrapper jDBCWrapper, Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> function2, Parameters.MergedParameters mergedParameters, Option<StructType> option, SQLContext sQLContext) {
        return RedshiftRelation$.MODULE$.apply(jDBCWrapper, function2, mergedParameters, option, sQLContext);
    }

    public static boolean schemaTypesMatch(DataType dataType, DataType dataType2) {
        return RedshiftRelation$.MODULE$.schemaTypesMatch(dataType, dataType2);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public JDBCWrapper jdbcWrapper() {
        return this.jdbcWrapper;
    }

    public Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory() {
        return this.s3ClientFactory;
    }

    public Parameters.MergedParameters params() {
        return this.params;
    }

    public Option<StructType> userSchema() {
        return this.userSchema;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private String tableNameOrSubquery() {
        return this.tableNameOrSubquery;
    }

    private StructType schema$lzycompute() {
        RedshiftRelation redshiftRelation = this;
        synchronized (redshiftRelation) {
            if (!this.bitmap$0) {
                this.schema = (StructType)this.userSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    StructType structType;
                    String tableNameOrSubquery = (String)this.params().query().map((Function1 & Serializable & scala.Serializable)q -> new StringBuilder(2).append("(").append((String)q).append(")").toString()).orElse((Function0 & Serializable & scala.Serializable)() -> this.params().table().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString())).get();
                    try (Connection conn = this.jdbcWrapper().getConnector(this.params().jdbcDriver(), this.params().jdbcUrl(), (Option<Parameters.MergedParameters>)new Some((Object)this.params()));){
                        structType = this.jdbcWrapper().resolveTable(conn, tableNameOrSubquery, (Option<Parameters.MergedParameters>)new Some((Object)this.params()));
                    }
                    return structType;
                });
                this.bitmap$0 = true;
            }
        }
        return this.schema;
    }

    public StructType schema() {
        return !this.bitmap$0 ? this.schema$lzycompute() : this.schema;
    }

    public String toString() {
        return new StringBuilder(18).append("RedshiftRelation(").append(this.tableNameOrSubquery()).append(")").toString();
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        SaveMode saveMode = overwrite ? SaveMode.Overwrite : SaveMode.Append;
        RedshiftWriter writer = new RedshiftWriter(this.jdbcWrapper(), this.s3ClientFactory());
        writer.saveToRedshift(this.sqlContext(), data, saveMode, this.params());
    }

    public Filter[] unhandledFilters(Filter[] filters) {
        return (Filter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).filterNot((Function1 & Serializable & scala.Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)RedshiftRelation.$anonfun$unhandledFilters$1(this, filter)));
    }

    private void checkS3BucketUsage(Parameters.MergedParameters params, AmazonS3 s3Client) {
        Utils$.MODULE$.checkRedshiftAndS3OnSameRegion(params, s3Client);
        Utils$.MODULE$.checkThatBucketHasObjectLifecycleConfiguration(params.rootTempDir(), s3Client);
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        Object object;
        block8: {
            AWSCredentialsProvider creds = AWSCredentialsUtils$.MODULE$.load(this.params(), this.sqlContext().sparkContext().hadoopConfiguration());
            this.checkS3BucketUsage(this.params(), (AmazonS3)this.s3ClientFactory().apply((Object)creds, (Object)this.params()));
            Utils$.MODULE$.collectMetrics(this.params(), Utils$.MODULE$.collectMetrics$default$2());
            String queryGroup = Utils$.MODULE$.queryGroupInfo(Utils$Read$.MODULE$, this.params().user_query_group_label());
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).isEmpty()) {
                String whereClause = FilterPushdown$.MODULE$.buildWhereClause(this.schema(), (Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])filters), FilterPushdown$.MODULE$.buildWhereClause$default$3());
                String countQuery = new StringBuilder(22).append("SELECT count(*) FROM ").append(this.tableNameOrSubquery()).append(" ").append(whereClause).toString();
                try (Connection conn = this.jdbcWrapper().getConnectorWithQueryGroup(this.params().jdbcDriver(), this.params().jdbcUrl(), (Option<Parameters.MergedParameters>)new Some((Object)this.params()), queryGroup);){
                    this.log().info("Getting number of rows from Redshift");
                    ResultSet results = this.jdbcWrapper().executeQueryInterruptibly(conn.prepareStatement(countQuery));
                    if (results.next()) {
                        long numRows = results.getLong(1);
                        this.log().info("Number of rows is {}", (Object)BoxesRunTime.boxToLong((long)numRows));
                        int parallelism = new StringOps(Predef$.MODULE$.augmentString(this.sqlContext().getConf("spark.sql.shuffle.partitions", "200"))).toInt();
                        InternalRow emptyRow = RowEncoder$.MODULE$.apply(StructType$.MODULE$.apply((Seq)Nil$.MODULE$)).createSerializer().apply((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Nil$.MODULE$})));
                        object = this.sqlContext().sparkContext().parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)numRows)), parallelism, ClassTag$.MODULE$.Long()).map((Function1 & Serializable & scala.Serializable)x$3 -> emptyRow, ClassTag$.MODULE$.apply(InternalRow.class));
                        break block8;
                    }
                    throw new IllegalStateException("Could not read count from Redshift");
                }
            }
            String tempDir = this.params().createPerQueryTempDir();
            String unloadSql = this.buildUnloadStmt(requiredColumns, filters, tempDir, creds, this.params().sseKmsKey());
            try (Connection conn = this.jdbcWrapper().getConnectorWithQueryGroup(this.params().jdbcDriver(), this.params().jdbcUrl(), (Option<Parameters.MergedParameters>)new Some((Object)this.params()), queryGroup);){
                this.log().info("Unloading data from Redshift");
                this.jdbcWrapper().executeInterruptibly(conn.prepareStatement(unloadSql));
            }
            Seq<String> filesToRead = this.getFilesToRead(creds, tempDir);
            StructType prunedSchema = this.pruneSchema(this.schema(), requiredColumns);
            String string = this.params().unloadS3Format();
            String string2 = "PARQUET";
            object = !(string != null ? !string.equals(string2) : string2 != null) ? this.readRDDFromParquet(prunedSchema, filesToRead) : this.readRDD(prunedSchema, filesToRead);
        }
        return object;
    }

    public boolean needConversion() {
        return false;
    }

    private String buildUnloadStmt(String[] requiredColumns, Filter[] filters, String tempDir, AWSCredentialsProvider creds, Option<String> sseKmsKey) {
        Predef$.MODULE$.assert(!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).isEmpty());
        String columnList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(2).append("\"").append((String)col).append("\"").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        String whereClause = FilterPushdown$.MODULE$.buildWhereClause(this.schema(), (Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])filters), true);
        String credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(this.params(), creds.getCredentials());
        String escapedTableNameOrSubqury = this.tableNameOrSubquery().replace("\\", "\\\\").replace("'", "\\'");
        String query = new StringBuilder(14).append("SELECT ").append(columnList).append(" FROM ").append(escapedTableNameOrSubqury).append(" ").append(whereClause).toString();
        Utils$.MODULE$.lastBuildStmt_$eq(query);
        String fixedUrl = Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(new URI(tempDir)).toString());
        String unloadClause = new StringBuilder(17).append("UNLOAD ('").append(query).append("') TO '").append(fixedUrl).append("'").toString();
        String credClause = new StringBuilder(19).append("WITH CREDENTIALS '").append(credsString).append("'").toString();
        String string = this.params().unloadS3Format();
        String string2 = "PARQUET";
        String manifestClause = !(string != null ? !string.equals(string2) : string2 != null) ? "FORMAT AS PARQUET  MANIFEST" : new StringBuilder(26).append("ESCAPE MANIFEST NULL AS '").append(this.params().nullString()).append("'").toString();
        String sseKmsClause = (String)sseKmsKey.map((Function1 & Serializable & scala.Serializable)key -> new StringBuilder(23).append("KMS_KEY_ID '").append((String)key).append("' ENCRYPTED").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String regionClause = (String)this.params().tempDirRegion().map((Function1 & Serializable & scala.Serializable)region -> new StringBuilder(12).append("REGION AS '").append((String)region).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String extraClause = String.valueOf(this.params().extraUnloadOptions());
        String string3 = unloadClause;
        String string4 = credClause;
        String string5 = manifestClause;
        String string6 = sseKmsClause;
        String string7 = regionClause;
        String string8 = extraClause;
        List unloadStmtList = Nil$.MODULE$.$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3);
        return unloadStmtList.mkString(" ");
    }

    private String buildUnloadStmt(RedshiftSQLStatement statement, StructType schema, String tempDir, AWSCredentialsProvider creds, Option<String> sseKmsKey) {
        Predef$.MODULE$.assert(schema.nonEmpty());
        String credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(this.params(), creds.getCredentials());
        String query = statement.statementString().replace("\\", "\\\\").replace("'", "\\'");
        Utils$.MODULE$.lastBuildStmt_$eq(query);
        String fixedUrl = Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(new URI(tempDir)).toString());
        String unloadClause = new StringBuilder(33).append("UNLOAD ('SELECT * FROM (").append(query).append(")') TO '").append(fixedUrl).append("'").toString();
        String credClause = new StringBuilder(19).append("WITH CREDENTIALS '").append(credsString).append("'").toString();
        String string = this.params().unloadS3Format();
        String string2 = "PARQUET";
        String manifestClause = !(string != null ? !string.equals(string2) : string2 != null) ? "FORMAT AS PARQUET  MANIFEST" : new StringBuilder(26).append("ESCAPE MANIFEST NULL AS '").append(this.params().nullString()).append("'").toString();
        String sseKmsClause = (String)sseKmsKey.map((Function1 & Serializable & scala.Serializable)key -> new StringBuilder(23).append("KMS_KEY_ID '").append((String)key).append("' ENCRYPTED").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String regionClause = (String)this.params().tempDirRegion().map((Function1 & Serializable & scala.Serializable)region -> new StringBuilder(12).append("REGION AS '").append((String)region).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String extraClause = String.valueOf(this.params().extraUnloadOptions());
        String string3 = unloadClause;
        String string4 = credClause;
        String string5 = manifestClause;
        String string6 = sseKmsClause;
        String string7 = regionClause;
        String string8 = extraClause;
        List unloadStmtList = Nil$.MODULE$.$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3);
        return unloadStmtList.mkString(" ");
    }

    private StructType pruneSchema(StructType schema, String[] columns) {
        Map fieldMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.name()), x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).map((Function1 & Serializable & scala.Serializable)name -> (StructField)fieldMap.apply(name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public <Row> RDD<Row> buildScanFromSQL(RedshiftSQLStatement statement, Option<StructType> schema) {
        Tuple2 tuple2;
        String queryGroup = Utils$.MODULE$.queryGroupInfo(Utils$Read$.MODULE$, this.params().user_query_group_label());
        Connection conn = this.jdbcWrapper().getConnectorWithQueryGroup(this.params().jdbcDriver(), this.params().jdbcUrl(), (Option<Parameters.MergedParameters>)new Some((Object)this.params()), queryGroup);
        AWSCredentialsProvider creds = AWSCredentialsUtils$.MODULE$.load(this.params(), this.sqlContext().sparkContext().hadoopConfiguration());
        try {
            StructType resultSchema = this.getResultSchema(statement, schema, conn);
            this.checkS3BucketUsage(this.params(), (AmazonS3)this.s3ClientFactory().apply((Object)creds, (Object)this.params()));
            Utils$.MODULE$.collectMetrics(this.params(), Utils$.MODULE$.collectMetrics$default$2());
            Option tempDir = this.GetCachedS3QueryPath(statement).orElse((Function0 & Serializable & scala.Serializable)() -> this.UnloadDataToS3(statement, conn, resultSchema, creds));
            tuple2 = new Tuple2((Object)resultSchema, (Object)tempDir);
        }
        finally {
            conn.close();
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        StructType resultSchema = (StructType)tuple22._1();
        Option tempDir = (Option)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)resultSchema, (Object)tempDir);
        Tuple2 tuple24 = tuple23;
        StructType resultSchema2 = (StructType)tuple24._1();
        Option tempDir2 = (Option)tuple24._2();
        Seq<String> filesToRead = this.getFilesToRead(creds, (String)tempDir2.get());
        String string = this.params().unloadS3Format();
        String string2 = "PARQUET";
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.readRDDFromParquet(resultSchema2, filesToRead) : this.readRDD(resultSchema2, filesToRead);
    }

    /*
     * WARNING - void declaration
     */
    private Option<String> GetCachedS3QueryPath(RedshiftSQLStatement statement) {
        void var2_2;
        block1: {
            if (!this.params().pushdownS3ResultCache()) {
                return None$.MODULE$;
            }
            Option<String> cachedPath = SqlToS3TempCache$.MODULE$.getS3Path(statement.statementString());
            if (!cachedPath.isDefined()) break block1;
            Utils$.MODULE$.lastBuildStmt_$eq(statement.statementString().replace("\\", "\\\\").replace("'", "\\'"));
        }
        return var2_2;
    }

    private Option<String> UnloadDataToS3(RedshiftSQLStatement statement, Connection conn, StructType resultSchema, AWSCredentialsProvider creds) {
        String newTempDir = this.params().createPerQueryTempDir();
        String unloadSql = this.buildUnloadStmt(statement, resultSchema, newTempDir, creds, this.params().sseKmsKey());
        this.log().info("Unloading data from Redshift");
        this.jdbcWrapper().executeInterruptibly(conn.prepareStatement(unloadSql));
        SqlToS3TempCache$.MODULE$.setS3Path(statement.statementString(), newTempDir);
        return new Some((Object)newTempDir);
    }

    private StructType convertComplexTypesToString(StructType inputSchema) {
        return StructType$.MODULE$.apply((Seq)inputSchema.map((Function1 & Serializable & scala.Serializable)field -> {
            DataType dataType = field.dataType();
            boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
            StructField structField = bl ? new StructField(field.name(), (DataType)StringType$.MODULE$, field.nullable(), field.metadata()) : field;
            return structField;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private Map<String, Column> mapComplexTypesToJson(StructType inputSchema) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputSchema.fields())).filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)RedshiftRelation.$anonfun$mapComplexTypesToJson$1(field))))).map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)functions$.MODULE$.from_json(functions$.MODULE$.col(field.name()), field.dataType())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    private <T> RDD<T> readRDD(StructType resultSchema, Seq<String> filesToRead) {
        this.log().info("Reading S3 Text files");
        StructType noRepeatSchema = StructType$.MODULE$.apply((Seq)((TraversableLike)resultSchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField f = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            StructField structField = new StructField(new StringBuilder(5).append("field").append(index).toString(), f.dataType(), f.nullable(), f.metadata());
            return structField;
        }, Seq$.MODULE$.canBuildFrom()));
        StructType modifiedSchema = this.convertComplexTypesToString(noRepeatSchema);
        Dataset dataFrame = this.sqlContext().read().format(RedshiftFileFormat.class.getName()).schema(modifiedSchema).option("nullString", this.params().nullString()).option(Parameters$.MODULE$.PARAM_OVERRIDE_NULLABLE(), this.params().overrideNullable()).load(filesToRead);
        Map<String, Column> mapping = this.mapComplexTypesToJson(noRepeatSchema);
        return mapping.nonEmpty() ? dataFrame.withColumns(mapping).queryExecution().executedPlan().execute() : dataFrame.queryExecution().executedPlan().execute();
    }

    private <T> RDD<T> readRDDFromParquet(StructType resultSchema, Seq<String> filesToRead) {
        RDD rDD;
        boolean conversionNeeded;
        this.log().info("Reading S3 Parquet files");
        DataFrameReader reader = this.sqlContext().read().format("parquet");
        StructType modifiedSchema = this.convertComplexTypesToString(resultSchema);
        Object object = filesToRead.isEmpty() ? reader.schema(modifiedSchema) : BoxedUnit.UNIT;
        boolean overrideNullable = this.params().overrideNullable();
        Dataset data = reader.load(filesToRead);
        Map<String, Column> mapping = this.mapComplexTypesToJson(new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fields())).zip((GenIterable)resultSchema, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField actualField = (StructField)tuple2._1();
            StructField expectedField = (StructField)tuple2._2();
            StructField structField = new StructField(actualField.name(), expectedField.dataType(), expectedField.nullable(), expectedField.metadata());
            return structField;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))));
        Dataset jsonLoaded = mapping.nonEmpty() ? data.withColumns(mapping) : data;
        StructType jsonLoadedSchema = jsonLoaded.schema();
        boolean schemasDoNotMatch = !RedshiftRelation$.MODULE$.schemaTypesMatch((DataType)resultSchema, (DataType)jsonLoadedSchema);
        boolean bl = conversionNeeded = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resultSchema.fields())).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)RedshiftRelation.$anonfun$readRDDFromParquet$2(field))) || overrideNullable || schemasDoNotMatch;
        if (schemasDoNotMatch) {
            this.log().warn("Expected schema does not match schema of loaded parquet");
        }
        if (conversionNeeded) {
            RDD qual$1 = jsonLoaded.queryExecution().executedPlan().execute().map((Function1 & Serializable & scala.Serializable)row -> {
                Seq typeConvertedRow = (Seq)((TraversableLike)row.toSeq(jsonLoadedSchema).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object f = tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Object object = Conversions$.MODULE$.parquetDataTypeConvert(f, resultSchema.fields()[i].dataType(), resultSchema.fields()[i].metadata().contains("redshift_type") ? resultSchema.fields()[i].metadata().getString("redshift_type") : null, overrideNullable);
                    return object;
                }, Seq$.MODULE$.canBuildFrom());
                return InternalRow$.MODULE$.apply(typeConvertedRow);
            }, ClassTag$.MODULE$.apply(InternalRow.class));
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iter -> {
                UnsafeProjection projection = UnsafeProjection$.MODULE$.create(resultSchema);
                return iter.map((Function1)projection);
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            rDD = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
        } else {
            rDD = jsonLoaded.queryExecution().executedPlan().execute();
        }
        return rDD;
    }

    private <Row> Seq<String> getFilesToRead(AWSCredentialsProvider creds, String tempDir) {
        Seq seq;
        String cleanedTempDirUri = Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(URI.create(tempDir)).toString());
        AmazonS3URI s3URI = Utils$.MODULE$.createS3URI(cleanedTempDirUri);
        AmazonS3 s3Client = (AmazonS3)this.s3ClientFactory().apply((Object)creds, (Object)this.params());
        if (s3Client.doesObjectExist(s3URI.getBucket(), new StringBuilder(8).append(s3URI.getKey()).append("manifest").toString())) {
            Seq seq2;
            S3ObjectInputStream is = s3Client.getObject(s3URI.getBucket(), new StringBuilder(8).append(s3URI.getKey()).append("manifest").toString()).getObjectContent();
            try {
                this.log().info("Begin finding S3 files to read");
                ObjectMapper mapper = new ObjectMapper();
                mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
                JsonNode entries = mapper.readTree((Reader)new InputStreamReader((InputStream)is)).get("entries");
                Seq results = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(entries.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.get("url").asText()).toSeq();
                this.log().info("Found {} S3 file(s)", (Object)BoxesRunTime.boxToInteger((int)results.length()));
                seq2 = results;
            }
            finally {
                is.close();
                this.log().info("End finding S3 files to read");
            }
            Seq s3Files = seq2;
            seq = (Seq)s3Files.map((Function1 & Serializable & scala.Serializable)file -> new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(tempDir)).stripSuffix("/")).append('/').append(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(file)).stripPrefix(cleanedTempDirUri))).stripPrefix("/")).toString(), Seq$.MODULE$.canBuildFrom());
        } else {
            this.log().debug(new StringBuilder(19).append(s3URI).append("/manifest not found").toString());
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    private StructType getResultSchema(RedshiftSQLStatement statement, Option<StructType> schema, Connection conn) {
        StructType resultSchema = (StructType)schema.getOrElse((Function0 & Serializable & scala.Serializable)() -> DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).tableSchema(statement, this.params()));
        if (resultSchema.isEmpty()) {
            throw new Exception(new StringBuilder(25).append("resultSchema isEmpty for ").append(statement.statementString()).toString());
        }
        return resultSchema;
    }

    public RedshiftRelation copy(JDBCWrapper jdbcWrapper, Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory, Parameters.MergedParameters params, Option<StructType> userSchema, SQLContext sqlContext) {
        return new RedshiftRelation(jdbcWrapper, s3ClientFactory, params, userSchema, sqlContext);
    }

    public JDBCWrapper copy$default$1() {
        return this.jdbcWrapper();
    }

    public Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> copy$default$2() {
        return this.s3ClientFactory();
    }

    public Parameters.MergedParameters copy$default$3() {
        return this.params();
    }

    public Option<StructType> copy$default$4() {
        return this.userSchema();
    }

    public String productPrefix() {
        return "RedshiftRelation";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.jdbcWrapper();
                break;
            }
            case 1: {
                object = this.s3ClientFactory();
                break;
            }
            case 2: {
                object = this.params();
                break;
            }
            case 3: {
                object = this.userSchema();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RedshiftRelation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RedshiftRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        RedshiftRelation redshiftRelation = (RedshiftRelation)((Object)x$1);
        JDBCWrapper jDBCWrapper = this.jdbcWrapper();
        JDBCWrapper jDBCWrapper2 = redshiftRelation.jdbcWrapper();
        if (jDBCWrapper == null) {
            if (jDBCWrapper2 != null) {
                return false;
            }
        } else if (!jDBCWrapper.equals(jDBCWrapper2)) return false;
        Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> function2 = this.s3ClientFactory();
        Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> function22 = redshiftRelation.s3ClientFactory();
        if (function2 == null) {
            if (function22 != null) {
                return false;
            }
        } else if (!function2.equals(function22)) return false;
        Parameters.MergedParameters mergedParameters = this.params();
        Parameters.MergedParameters mergedParameters2 = redshiftRelation.params();
        if (mergedParameters == null) {
            if (mergedParameters2 != null) {
                return false;
            }
        } else if (!((Object)mergedParameters).equals(mergedParameters2)) return false;
        Option<StructType> option = this.userSchema();
        Option<StructType> option2 = redshiftRelation.userSchema();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!redshiftRelation.canEqual((Object)this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$unhandledFilters$1(RedshiftRelation $this, Filter filter) {
        return FilterPushdown$.MODULE$.buildFilterExpression($this.schema(), filter, FilterPushdown$.MODULE$.buildFilterExpression$default$3()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$mapComplexTypesToJson$1(StructField field) {
        DataType dataType = field.dataType();
        boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$readRDDFromParquet$2(StructField field) {
        boolean bl;
        DataType dataType = field.dataType();
        boolean bl2 = StringType$.MODULE$.equals(dataType) ? field.metadata().contains("redshift_type") && ((SeqLike)new .colon.colon((Object)"super", (List)new .colon.colon((Object)"bpchar", (List)Nil$.MODULE$))).contains((Object)field.metadata().getString("redshift_type")) : (bl = TimestampType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)));
        return bl2;
    }

    public RedshiftRelation(JDBCWrapper jdbcWrapper, Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory, Parameters.MergedParameters params, Option<StructType> userSchema, SQLContext sqlContext) {
        this.jdbcWrapper = jdbcWrapper;
        this.s3ClientFactory = s3ClientFactory;
        this.params = params;
        this.userSchema = userSchema;
        this.sqlContext = sqlContext;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        if (sqlContext != null) {
            Utils$.MODULE$.assertThatFileSystemIsNotS3BlockFileSystem(new URI(params.rootTempDir()), sqlContext.sparkContext().hadoopConfiguration());
        }
        this.tableNameOrSubquery = (String)params.query().map((Function1 & Serializable & scala.Serializable)q -> new StringBuilder(2).append("(").append((String)q).append(")").toString()).orElse((Function0 & Serializable & scala.Serializable)() -> this.params().table().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString())).get();
    }
}

