/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class Parameters$ {
    public static Parameters$ MODULE$;
    private final String PARAM_AUTO_PUSHDOWN;
    private final String PARAM_PUSHDOWN_S3_RESULT_CACHE;
    private final String PARAM_UNLOAD_S3_FORMAT;
    private final String PARAM_COPY_RETRY_COUNT;
    private final String PARAM_COPY_DELAY;
    private final String PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING;
    private final String PARAM_OVERRIDE_NULLABLE;
    private final String PARAM_TEMPDIR_REGION;
    private final String PARAM_SECRET_ID;
    private final String PARAM_SECRET_REGION;
    private final String PARAM_USER_QUERY_GROUP_LABEL;
    private final Map<String, String> DEFAULT_PARAMETERS;
    private final Set<String> VALID_TEMP_FORMATS;
    private final long DEFAULT_RETRY_DELAY;

    static {
        new Parameters$();
    }

    public String PARAM_AUTO_PUSHDOWN() {
        return this.PARAM_AUTO_PUSHDOWN;
    }

    public String PARAM_PUSHDOWN_S3_RESULT_CACHE() {
        return this.PARAM_PUSHDOWN_S3_RESULT_CACHE;
    }

    public String PARAM_UNLOAD_S3_FORMAT() {
        return this.PARAM_UNLOAD_S3_FORMAT;
    }

    public String PARAM_COPY_RETRY_COUNT() {
        return this.PARAM_COPY_RETRY_COUNT;
    }

    public String PARAM_COPY_DELAY() {
        return this.PARAM_COPY_DELAY;
    }

    public String PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING() {
        return this.PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING;
    }

    public String PARAM_OVERRIDE_NULLABLE() {
        return this.PARAM_OVERRIDE_NULLABLE;
    }

    public String PARAM_TEMPDIR_REGION() {
        return this.PARAM_TEMPDIR_REGION;
    }

    public String PARAM_SECRET_ID() {
        return this.PARAM_SECRET_ID;
    }

    public String PARAM_SECRET_REGION() {
        return this.PARAM_SECRET_REGION;
    }

    public String PARAM_USER_QUERY_GROUP_LABEL() {
        return this.PARAM_USER_QUERY_GROUP_LABEL;
    }

    public Map<String, String> DEFAULT_PARAMETERS() {
        return this.DEFAULT_PARAMETERS;
    }

    public Set<String> VALID_TEMP_FORMATS() {
        return this.VALID_TEMP_FORMATS;
    }

    public long DEFAULT_RETRY_DELAY() {
        return this.DEFAULT_RETRY_DELAY;
    }

    public Parameters.MergedParameters mergeParameters(Map<String, String> userParameters) {
        if (!userParameters.contains((Object)"tempdir")) {
            throw new IllegalArgumentException("'tempdir' is required for all Redshift loads and saves");
        }
        if (userParameters.contains((Object)"tempformat") && !this.VALID_TEMP_FORMATS().contains((Object)((String)userParameters.apply((Object)"tempformat")).toUpperCase())) {
            throw new IllegalArgumentException(new StringBuilder(42).append("Invalid temp format: ").append(userParameters.apply((Object)"tempformat")).append("; ").append("valid formats are: ").append(this.VALID_TEMP_FORMATS().mkString(", ")).toString());
        }
        if (!userParameters.contains((Object)"url")) {
            throw new IllegalArgumentException("A JDBC URL must be provided with 'url' parameter");
        }
        if (!userParameters.contains((Object)"dbtable") && !userParameters.contains((Object)"query")) {
            throw new IllegalArgumentException("You must specify a Redshift table name with the 'dbtable' parameter or a query with the 'query' parameter.");
        }
        if (userParameters.contains((Object)"dbtable") && userParameters.contains((Object)"query")) {
            throw new IllegalArgumentException("You cannot specify both the 'dbtable' and 'query' parameters at the same time.");
        }
        Option credsInURL = userParameters.get((Object)"url").filter((Function1 & java.io.Serializable & Serializable)url -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$mergeParameters$1(url)));
        if ((userParameters.contains((Object)"user") || userParameters.contains((Object)"password")) && credsInURL.isDefined()) {
            throw new IllegalArgumentException("You cannot specify credentials in both the URL and as user/password options");
        }
        if (credsInURL.isDefined() && userParameters.contains((Object)this.PARAM_SECRET_ID())) {
            throw new IllegalArgumentException("You cannot give a secret and specify credentials in URL");
        }
        if ((userParameters.contains((Object)"user") || userParameters.contains((Object)"password")) && userParameters.contains((Object)this.PARAM_SECRET_ID())) {
            throw new IllegalArgumentException("You cannot give a secret and specify user/password options");
        }
        if (userParameters.get((Object)this.PARAM_USER_QUERY_GROUP_LABEL()).exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$mergeParameters$2(x$1)))) {
            char invalid = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)userParameters.apply((Object)this.PARAM_USER_QUERY_GROUP_LABEL()))).find((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$mergeParameters$4(BoxesRunTime.unboxToChar((Object)x$3)))).get());
            throw new IllegalArgumentException(new StringBuilder(134).append("All characters in label option must be valid unicode identifier parts ").append("(char.isUnicodeIdentifierPart == true), '").append(invalid).append("' character not allowed").toString());
        }
        return new Parameters.MergedParameters((Map<String, String>)this.DEFAULT_PARAMETERS().$plus$plus(userParameters));
    }

    public static final /* synthetic */ boolean $anonfun$mergeParameters$1(String url) {
        return url.contains("user=") || url.contains("password=") || url.contains("DbUser=");
    }

    public static final /* synthetic */ boolean $anonfun$mergeParameters$3(char x$2) {
        return !RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(x$2));
    }

    public static final /* synthetic */ boolean $anonfun$mergeParameters$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).exists((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Parameters$.$anonfun$mergeParameters$3(BoxesRunTime.unboxToChar((Object)x$2))));
    }

    public static final /* synthetic */ boolean $anonfun$mergeParameters$4(char x$3) {
        return !RichChar$.MODULE$.isUnicodeIdentifierPart$extension(Predef$.MODULE$.charWrapper(x$3));
    }

    private Parameters$() {
        MODULE$ = this;
        this.PARAM_AUTO_PUSHDOWN = "autopushdown";
        this.PARAM_PUSHDOWN_S3_RESULT_CACHE = "autopushdown.s3_result_cache";
        this.PARAM_UNLOAD_S3_FORMAT = "unload_s3_format";
        this.PARAM_COPY_RETRY_COUNT = "copyretrycount";
        this.PARAM_COPY_DELAY = "copydelay";
        this.PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING = "legacy_jdbc_real_type_mapping";
        this.PARAM_OVERRIDE_NULLABLE = "overridenullable";
        this.PARAM_TEMPDIR_REGION = "tempdir_region";
        this.PARAM_SECRET_ID = "secret.id";
        this.PARAM_SECRET_REGION = "secret.region";
        this.PARAM_USER_QUERY_GROUP_LABEL = "label";
        this.DEFAULT_PARAMETERS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"forward_spark_s3_credentials"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempformat"), (Object)"AVRO"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"csvnullstring"), (Object)"@NULL@"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"overwrite"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"diststyle"), (Object)"EVEN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"usestagingtable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preactions"), (Object)";"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"postactions"), (Object)";"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"include_column_list"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_AUTO_PUSHDOWN()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_PUSHDOWN_S3_RESULT_CACHE()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_UNLOAD_S3_FORMAT()), (Object)"PARQUET"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_OVERRIDE_NULLABLE()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_COPY_RETRY_COUNT()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_COPY_DELAY()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_LEGACY_JDBC_REAL_TYPE_MAPPING()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_TEMPDIR_REGION()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_USER_QUERY_GROUP_LABEL()), (Object)"")}));
        this.VALID_TEMP_FORMATS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AVRO", "CSV", "CSV GZIP", "PARQUET"}));
        this.DEFAULT_RETRY_DELAY = 30000L;
    }
}

