/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005}g!\u0002\u000b\u0016\u0001Uy\u0002\"B\u0015\u0001\t\u0003Y\u0003b\u0002\u0018\u0001\u0005\u0004%\tb\f\u0005\u0007q\u0001\u0001\u000b\u0011\u0002\u0019\t\u0011e\u0002\u0001R1A\u0005\fiB\u0001\u0002\u0013\u0001\t\u0006\u0004%Y!\u0013\u0005\u0006#\u0002!IA\u0015\u0005\u0006K\u0002!\tA\u001a\u0005\u0006i\u0002!\t!\u001e\u0005\u0006K\u0002!IA\u001f\u0005\b\u00037\u0001A\u0011AA\u000f\u0011%\tI\u0007AI\u0001\n\u0003\tY\u0007C\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0005bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!!1\u0001\t\u0013\t\u0019\rC\u0005\u0002^\u0002\t\n\u0011\"\u0003\u0002l\tY!\n\u0012\"D/J\f\u0007\u000f]3s\u0015\t1r#\u0001\u0005sK\u0012\u001c\b.\u001b4u\u0015\tA\u0012$A\u0003ta\u0006\u00148N\u0003\u0002\u001b7\u0005A2\u000f]1sW~\u0013X\rZ:iS\u001a$xlY8n[Vt\u0017\u000e^=\u000b\u0005qi\u0012AB4ji\",(MC\u0001\u001f\u0003\tIwnE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0011(\u0013\tA#E\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005a\u0003CA\u0017\u0001\u001b\u0005)\u0012a\u00017pOV\t\u0001\u0007\u0005\u00022m5\t!G\u0003\u00024i\u0005)1\u000f\u001c45U*\tQ'A\u0002pe\u001eL!a\u000e\u001a\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002/)#%iQ\"bY2tU/\u001c2fe\u001e+g.\u001a:bi>\u0014X#A\u001e\u0011\u0007qz\u0014)D\u0001>\u0015\tq$%\u0001\u0006d_2dWm\u0019;j_:L!\u0001Q\u001f\u0003\u0011%#XM]1u_J\u0004\"!\t\"\n\u0005\r\u0013#aA%oi\"\u0012A!\u0012\t\u0003C\u0019K!a\u0012\u0012\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018AA3d+\u0005Q\u0005CA&O\u001b\u0005a%BA'#\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u001f2\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;)\u0005\u0015)\u0015AD4fi\u0012\u0013\u0018N^3s\u00072\f7o\u001d\u000b\u0004'z\u0003\u0007C\u0001+\\\u001d\t)\u0016\f\u0005\u0002WE5\tqK\u0003\u0002YU\u00051AH]8pizJ!A\u0017\u0012\u0002\rA\u0013X\rZ3g\u0013\taVL\u0001\u0004TiJLgn\u001a\u0006\u00035\nBQa\u0018\u0004A\u0002M\u000bqB\u001b3cGN+(\r\u001d:pi>\u001cw\u000e\u001c\u0005\u0006C\u001a\u0001\rAY\u0001\u0018kN,'\u000f\u0015:pm&$W\r\u001a#sSZ,'o\u00117bgN\u00042!I2T\u0013\t!'E\u0001\u0004PaRLwN\\\u0001\u0015Kb,7-\u001e;f\u0013:$XM\u001d:vaRL'\r\\=\u0015\u0005\u001dT\u0007CA\u0011i\u0013\tI'EA\u0004C_>dW-\u00198\t\u000b-<\u0001\u0019\u00017\u0002\u0013M$\u0018\r^3nK:$\bCA7s\u001b\u0005q'BA8q\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002c\u0006!!.\u0019<b\u0013\t\u0019hNA\tQe\u0016\u0004\u0018M]3e'R\fG/Z7f]R\f\u0011$\u001a=fGV$X-U;fefLe\u000e^3seV\u0004H/\u001b2msR\u0011a/\u001f\t\u0003[^L!\u0001\u001f8\u0003\u0013I+7/\u001e7u'\u0016$\b\"B6\t\u0001\u0004aWCA>\u007f)\u0015a\u0018qBA\t!\tih\u0010\u0004\u0001\u0005\r}L!\u0019AA\u0001\u0005\u0005!\u0016\u0003BA\u0002\u0003\u0013\u00012!IA\u0003\u0013\r\t9A\t\u0002\b\u001d>$\b.\u001b8h!\r\t\u00131B\u0005\u0004\u0003\u001b\u0011#aA!os\")1.\u0003a\u0001Y\"9\u00111C\u0005A\u0002\u0005U\u0011AA8q!\u0015\t\u0013q\u00037}\u0013\r\tIB\t\u0002\n\rVt7\r^5p]F\nAB]3t_24X\rV1cY\u0016$\u0002\"a\b\u00024\u0005u\u0012\u0011\t\t\u0005\u0003C\ty#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u0015!\u0018\u0010]3t\u0015\ry\u0017\u0011\u0006\u0006\u00041\u0005-\"bAA\u0017i\u00051\u0011\r]1dQ\u0016LA!!\r\u0002$\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005U\"\u00021\u0001\u00028\u0005!1m\u001c8o!\ri\u0017\u0011H\u0005\u0004\u0003wq'AC\"p]:,7\r^5p]\"1\u0011q\b\u0006A\u0002M\u000bQ\u0001^1cY\u0016D\u0011\"a\u0011\u000b!\u0003\u0005\r!!\u0012\u0002\rA\f'/Y7t!\u0011\t3-a\u0012\u0011\t\u0005%\u00131\r\b\u0005\u0003\u0017\nyF\u0004\u0003\u0002N\u0005uc\u0002BA(\u00037rA!!\u0015\u0002Z9!\u00111KA,\u001d\r1\u0016QK\u0005\u0002=%\u0011A$H\u0005\u00035mI!\u0001G\r\n\u0005Y9\u0012bAA1+\u0005Q\u0001+\u0019:b[\u0016$XM]:\n\t\u0005\u0015\u0014q\r\u0002\u0011\u001b\u0016\u0014x-\u001a3QCJ\fW.\u001a;feNT1!!\u0019\u0016\u0003Y\u0011Xm]8mm\u0016$\u0016M\u00197fI\u0011,g-Y;mi\u0012\u001aTCAA7U\u0011\t)%a\u001c,\u0005\u0005E\u0004\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001f#\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\n)HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAC]3t_24X\rV1cY\u00164%o\\7NKR\fG\u0003CA\u0010\u0003\u000b\u000b9)!%\t\u000f\u0005UB\u00021\u0001\u00028!9\u0011\u0011\u0012\u0007A\u0002\u0005-\u0015\u0001\u0002:t[\u0012\u00042!\\AG\u0013\r\tyI\u001c\u0002\u0012%\u0016\u001cX\u000f\u001c;TKRlU\r^1ECR\f\u0007bBA\"\u0019\u0001\u0007\u0011qI\u0001\u000fI\u00164\u0017-\u001e7u\u0003B\u0004h*Y7f+\u0005\u0019\u0016AG4fi\u000e{gN\\3di>\u0014x+\u001b;i#V,'/_$s_V\u0004HCCA\u001c\u00037\u000bi*!)\u0002$\")\u0011M\u0004a\u0001E\"1\u0011q\u0014\bA\u0002M\u000b1!\u001e:m\u0011\u001d\t\u0019E\u0004a\u0001\u0003\u000bBa!!*\u000f\u0001\u0004\u0019\u0016AC9vKJLxI]8va\u0006aq-\u001a;D_:tWm\u0019;peRA\u0011qGAV\u0003[\u000by\u000bC\u0003b\u001f\u0001\u0007!\r\u0003\u0004\u0002 >\u0001\ra\u0015\u0005\b\u0003\u0007z\u0001\u0019AA#\u00031\u00198\r[3nCN#(/\u001b8h)\r\u0019\u0016Q\u0017\u0005\b\u0003o\u0003\u0002\u0019AA\u0010\u0003\u0019\u00198\r[3nC\u0006YA/\u00192mK\u0016C\u0018n\u001d;t)\u00159\u0017QXA`\u0011\u001d\t)$\u0005a\u0001\u0003oAa!a\u0010\u0012\u0001\u0004\u0019\u0016aD4fi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0015\u0019\u0005\u0015\u00171ZAh\u0003'\f9.a7\u0011\t\u0005\u0005\u0012qY\u0005\u0005\u0003\u0013\f\u0019C\u0001\u0005ECR\fG+\u001f9f\u0011\u0019\tiM\u0005a\u0001\u0003\u000691/\u001d7UsB,\u0007BBAi%\u0001\u0007\u0011)A\u0005qe\u0016\u001c\u0017n]5p]\"1\u0011Q\u001b\nA\u0002\u0005\u000bQa]2bY\u0016Da!!7\u0013\u0001\u00049\u0017AB:jO:,G\rC\u0005\u0002DI\u0001\n\u00111\u0001\u0002F\u0005Ir-\u001a;DCR\fG._:u)f\u0004X\r\n3fM\u0006,H\u000e\u001e\u00136\u0001")
public class JDBCWrapper
implements scala.Serializable {
    private transient Iterator<Object> JDBCCallNumberGenerator;
    private transient ExecutionContext ec;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile transient byte bitmap$trans$0;

    public Logger log() {
        return this.log;
    }

    private Iterator<Object> JDBCCallNumberGenerator$lzycompute() {
        JDBCWrapper jDBCWrapper = this;
        synchronized (jDBCWrapper) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.JDBCCallNumberGenerator = package$.MODULE$.Iterator().from(1);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.JDBCCallNumberGenerator;
    }

    private Iterator<Object> JDBCCallNumberGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.JDBCCallNumberGenerator$lzycompute() : this.JDBCCallNumberGenerator;
    }

    private ExecutionContext ec$lzycompute() {
        JDBCWrapper jDBCWrapper = this;
        synchronized (jDBCWrapper) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ThreadFactory threadFactory = new ThreadFactory(null){
                    private final AtomicInteger count;

                    /*
                     * WARNING - void declaration
                     */
                    public Thread newThread(Runnable r) {
                        void var2_2;
                        Thread thread = new Thread(r);
                        thread.setName(new java.lang.StringBuilder(27).append("spark-redshift-JDBCWrapper-").append(this.count.incrementAndGet()).toString());
                        thread.setDaemon(true);
                        return var2_2;
                    }
                    {
                        this.count = new AtomicInteger();
                    }
                };
                this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.ec;
    }

    private ExecutionContext ec() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.ec$lzycompute() : this.ec;
    }

    private String getDriverClass(String jdbcSubprotocol, Option<String> userProvidedDriverClass) {
        return (String)userProvidedDriverClass.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            String string2 = jdbcSubprotocol;
            if ("redshift".equals(string2)) {
                String string3;
                try {
                    string3 = Utils$.MODULE$.classForName("com.amazon.redshift.jdbc42.Driver").getName();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        string3 = Utils$.MODULE$.classForName("com.amazon.redshift.jdbc41.Driver").getName();
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        try {
                            string3 = Utils$.MODULE$.classForName("com.amazon.redshift.jdbc4.Driver").getName();
                        }
                        catch (ClassNotFoundException e) {
                            throw new ClassNotFoundException("Could not load an Amazon Redshift JDBC driver; see the README for instructions on downloading and configuring the official Amazon driver.", e);
                        }
                    }
                }
                string = string3;
            } else if ("postgresql".equals(string2)) {
                string = "org.postgresql.Driver";
            } else if ("jdbc-secretsmanager".equals(string2)) {
                string = "com.amazonaws.secretsmanager.sql.AWSSecretsManagerRedshiftDriver";
            } else {
                throw new IllegalArgumentException(new java.lang.StringBuilder(29).append("Unsupported JDBC protocol: '").append(string2).append("'").toString());
            }
            return string;
        });
    }

    public boolean executeInterruptibly(PreparedStatement statement) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.execute())));
    }

    public ResultSet executeQueryInterruptibly(PreparedStatement statement) {
        return (ResultSet)this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$2 -> x$2.executeQuery());
    }

    private <T> T executeInterruptibly(PreparedStatement statement, Function1<PreparedStatement, T> op) {
        Object object;
        int JDBCCallNumber = BoxesRunTime.unboxToInt((Object)this.JDBCCallNumberGenerator().next());
        try {
            try {
                this.log().info("Begin JDBC call {}", (Object)BoxesRunTime.boxToInteger((int)JDBCCallNumber));
                Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> op.apply((Object)statement), this.ec());
                try {
                    object = Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SQLException) {
                        SQLException sQLException = (SQLException)throwable2;
                        throw new SQLException("Exception thrown in awaitResult: ", sQLException);
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        throw new Exception("Exception thrown in awaitResult: ", t);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                try {
                    statement.cancel();
                    throw e;
                }
                catch (SQLException s) {
                    this.log().error("Exception occurred while cancelling query", (Throwable)s);
                    throw e;
                }
            }
        }
        finally {
            this.log().info("End JDBC call {}", (Object)BoxesRunTime.boxToInteger((int)JDBCCallNumber));
        }
        return (T)object;
    }

    public StructType resolveTable(Connection conn, String table, Option<Parameters.MergedParameters> params) {
        StructType structType;
        try (PreparedStatement ps = conn.prepareStatement(new java.lang.StringBuilder(22).append("SELECT * FROM ").append(table).append(" LIMIT 1").toString());){
            this.log().info("Getting schema from Redshift for table: {}", new Object[]{table});
            ResultSetMetaData rsmd = (ResultSetMetaData)this.executeInterruptibly(ps, (Function1 & Serializable & scala.Serializable)x$3 -> x$3.getMetaData());
            int ncols = rsmd.getColumnCount();
            StructField[] fields = new StructField[ncols];
            for (int i = 0; i < ncols; ++i) {
                String columnName = rsmd.getColumnLabel(i + 1);
                String rsType = rsmd.getColumnTypeName(i + 1);
                int dataType = rsmd.getColumnType(i + 1);
                int fieldSize = rsmd.getPrecision(i + 1);
                int fieldScale = rsmd.getScale(i + 1);
                boolean isSigned = rsmd.isSigned(i + 1);
                boolean nullable = params.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.overrideNullable())) ? true : rsmd.isNullable(i + 1) != 0;
                DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned, params);
                Metadata meta = new MetadataBuilder().putString("redshift_type", rsType).build();
                fields[i] = new StructField(columnName, columnType, nullable, meta);
            }
            structType = new StructType(fields);
        }
        return structType;
    }

    public Option<Parameters.MergedParameters> resolveTable$default$3() {
        return None$.MODULE$;
    }

    public StructType resolveTableFromMeta(Connection conn, ResultSetMetaData rsmd, Parameters.MergedParameters params) {
        int ncols = rsmd.getColumnCount();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            String rsType = rsmd.getColumnTypeName(i + 1);
            int dataType = rsmd.getColumnType(i + 1);
            int fieldSize = rsmd.getPrecision(i + 1);
            int fieldScale = rsmd.getScale(i + 1);
            boolean isSigned = rsmd.isSigned(i + 1);
            boolean nullable = rsmd.isNullable(i + 1) != 0;
            DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned, (Option<Parameters.MergedParameters>)new Some((Object)params));
            Metadata meta = new MetadataBuilder().putString("redshift_type", rsType).build();
            fields[i] = new StructField(columnName.matches("[_A-Z]([_0-9A-Z])*") ? columnName : new java.lang.StringBuilder(2).append("\"").append(columnName).append("\"").toString(), columnType, nullable, meta);
        }
        return new StructType(fields);
    }

    public String defaultAppName() {
        return (String)Utils$.MODULE$.connectorServiceName().map((Function1 & Serializable & scala.Serializable)name -> new java.lang.StringBuilder(1).append(Utils$.MODULE$.DEFAULT_APP_NAME()).append("_").append((String)name).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.DEFAULT_APP_NAME());
    }

    public Connection getConnectorWithQueryGroup(Option<String> userProvidedDriverClass, String url, Option<Parameters.MergedParameters> params, String queryGroup) {
        Connection connection;
        Connection conn = this.getConnector(userProvidedDriverClass, url, params);
        try {
            this.executeInterruptibly(conn.prepareStatement(new java.lang.StringBuilder(21).append("set query_group to '").append(queryGroup).append("'").toString()));
            connection = conn;
        }
        catch (Throwable e) {
            this.log().debug(new java.lang.StringBuilder(27).append("Unable to set query group: ").append(e).toString());
            conn.close();
            connection = this.getConnector(userProvidedDriverClass, url, params);
        }
        return connection;
    }

    public Connection getConnector(Option<String> userProvidedDriverClass, String url, Option<Parameters.MergedParameters> params) {
        String updatedURL = params.isDefined() && ((Parameters.MergedParameters)params.get()).secretId().isDefined() ? url.replaceFirst("jdbc", "jdbc-secretsmanager") : url;
        Properties driverProperties = new Properties();
        params.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCWrapper.$anonfun$getConnector$1(driverProperties, x0$1);
            return BoxedUnit.UNIT;
        });
        Object object = !updatedURL.toLowerCase().contains("applicationname=") && !driverProperties.containsKey("applicationname") ? driverProperties.setProperty("applicationname", this.defaultAppName()) : BoxedUnit.UNIT;
        String subprotocol = new StringOps(Predef$.MODULE$.augmentString(updatedURL)).stripPrefix("jdbc:").split(":")[0];
        String driverClass = this.getDriverClass(subprotocol, userProvidedDriverClass);
        DriverRegistry$.MODULE$.register(driverClass);
        Class<?> driverWrapperClass = org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("1.4") ? Utils$.MODULE$.classForName("org.apache.spark.sql.jdbc.package$DriverWrapper") : Utils$.MODULE$.classForName("org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper");
        Driver driver = (Driver)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).collectFirst((PartialFunction)new scala.Serializable(this, driverWrapperClass, driverClass){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCWrapper $outer;
            private final Class driverWrapperClass$1;
            private final String driverClass$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Driver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_8;
                A1 A1 = x1;
                if (this.driverWrapperClass$1.isAssignableFrom(A1.getClass())) {
                    String string = JDBCWrapper.io$github$spark_redshift_community$spark$redshift$JDBCWrapper$$getWrapped$1(A1, this.driverWrapperClass$1).getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        A1 A12 = A1;
                        return var3_8;
                    }
                }
                String string = A1.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    A1 A13 = A1;
                    return var3_8;
                }
                Object object = function1.apply(x1);
                return var3_8;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Driver x1) {
                Driver driver = x1;
                if (this.driverWrapperClass$1.isAssignableFrom(driver.getClass())) {
                    String string = JDBCWrapper.io$github$spark_redshift_community$spark$redshift$JDBCWrapper$$getWrapped$1(driver, this.driverWrapperClass$1).getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) {
                        return true;
                    }
                }
                String string = driver.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (string != null) {
                    if (!string.equals(string3)) return false;
                    return true;
                }
                if (string3 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driverWrapperClass$1 = driverWrapperClass$1;
                this.driverClass$1 = driverClass$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new java.lang.StringBuilder(42).append("Did not find registered driver with class ").append(driverClass).toString());
        });
        return driver.connect(updatedURL, driverProperties);
    }

    public String schemaString(StructType schema) {
        StringBuilder sb = new StringBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
            String string;
            String name = field.name();
            if (field.metadata().contains("redshift_type")) {
                string = field.metadata().getString("redshift_type");
            } else {
                String string2;
                DataType dataType = field.dataType();
                if (IntegerType$.MODULE$.equals(dataType)) {
                    string2 = "INTEGER";
                } else if (LongType$.MODULE$.equals(dataType)) {
                    string2 = "BIGINT";
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    string2 = "DOUBLE PRECISION";
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    string2 = "REAL";
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    string2 = "INTEGER";
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    string2 = "SMALLINT";
                } else if (BooleanType$.MODULE$.equals(dataType)) {
                    string2 = "BOOLEAN";
                } else if (StringType$.MODULE$.equals(dataType)) {
                    string2 = field.metadata().contains("maxlength") ? new java.lang.StringBuilder(9).append("VARCHAR(").append(field.metadata().getLong("maxlength")).append(")").toString() : "VARCHAR(MAX)";
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    string2 = "TIMESTAMP";
                } else if (DateType$.MODULE$.equals(dataType)) {
                    string2 = "DATE";
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    string2 = new java.lang.StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString();
                } else {
                    boolean bl = dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType);
                    if (bl) {
                        string2 = "SUPER";
                    } else {
                        throw new IllegalArgumentException(new java.lang.StringBuilder(31).append("Don't know how to save ").append(field).append(" to JDBC").toString());
                    }
                }
                string = string2;
            }
            String typ = string;
            String nullable = field.nullable() ? "" : "NOT NULL";
            String encoding = field.metadata().contains("encoding") ? new java.lang.StringBuilder(7).append("ENCODE ").append(field.metadata().getString("encoding")).toString() : "";
            return sb.append(new java.lang.StringBuilder(7).append(", \"").append(name.replace("\"", "\\\"")).append("\" ").append(typ).append(" ").append(nullable).append(" ").append(encoding).toString().trim());
        });
        return sb.length() < 2 ? "" : sb.substring(2);
    }

    public boolean tableExists(Connection conn, String table) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            PreparedStatement stmt = conn.prepareStatement(new java.lang.StringBuilder(22).append("SELECT 1 FROM ").append(table).append(" LIMIT 1").toString());
            this.log().info("Checking if table exists: {}", new Object[]{table});
            return ((ResultSetMetaData)this.executeInterruptibly(stmt, (Function1 & Serializable & scala.Serializable)x$5 -> x$5.getMetaData())).getColumnCount();
        }).isSuccess();
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed, Option<Parameters.MergedParameters> params) {
        StringType$ stringType$;
        int n = sqlType;
        switch (n) {
            case 0: {
                stringType$ = null;
                break;
            }
            case 1: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case -9: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case 12: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case 91: {
                stringType$ = DateType$.MODULE$;
                break;
            }
            case 92: {
                stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 93: {
                stringType$ = TimestampType$.MODULE$;
                break;
            }
            case -7: {
                stringType$ = BooleanType$.MODULE$;
                break;
            }
            case 16: {
                stringType$ = BooleanType$.MODULE$;
                break;
            }
            case -5: {
                if (signed) {
                    stringType$ = LongType$.MODULE$;
                    break;
                }
                stringType$ = new DecimalType(20, 0);
                break;
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    stringType$ = new DecimalType(precision, scale);
                    break;
                }
                stringType$ = new DecimalType(38, 18);
                break;
            }
            case 8: {
                stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                stringType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    stringType$ = IntegerType$.MODULE$;
                    break;
                }
                stringType$ = LongType$.MODULE$;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    stringType$ = new DecimalType(precision, scale);
                    break;
                }
                stringType$ = new DecimalType(38, 18);
                break;
            }
            case 7: {
                if (params.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.legacyJdbcRealTypeMapping()))) {
                    stringType$ = DoubleType$.MODULE$;
                    break;
                }
                stringType$ = FloatType$.MODULE$;
                break;
            }
            case 5: {
                stringType$ = IntegerType$.MODULE$;
                break;
            }
            case -6: {
                stringType$ = IntegerType$.MODULE$;
                break;
            }
            default: {
                stringType$ = null;
                break;
            }
        }
        StringType$ answer = stringType$;
        if (answer == null) {
            throw new SQLException(new java.lang.StringBuilder(17).append("Unsupported type ").append(sqlType).toString());
        }
        return answer;
    }

    private Option<Parameters.MergedParameters> getCatalystType$default$5() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$getConnector$1(Properties driverProperties$1, Parameters.MergedParameters x0$1) {
        Parameters.MergedParameters mergedParameters = x0$1;
        if (mergedParameters == null) {
            throw new MatchError((Object)mergedParameters);
        }
        Map<String, String> sourceParams = mergedParameters.parameters();
        Utils$.MODULE$.copyProperty("user", sourceParams, driverProperties$1);
        Utils$.MODULE$.copyProperty("password", sourceParams, driverProperties$1);
        Utils$.MODULE$.copyProperty("secret.id", "user", sourceParams, driverProperties$1);
        Utils$.MODULE$.copyProperties("^jdbc\\..+", "^jdbc\\.", "", sourceParams, driverProperties$1);
        Utils$.MODULE$.copyProperties("^secret\\..+", "^secret\\.", "drivers\\.", (Map<String, String>)((Map)sourceParams.$minus((Object)"secret.id")), System.getProperties());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final Driver io$github$spark_redshift_community$spark$redshift$JDBCWrapper$$getWrapped$1(Driver d, Class driverWrapperClass$1) {
        Predef$.MODULE$.require(driverWrapperClass$1.isAssignableFrom(d.getClass()));
        return (Driver)driverWrapperClass$1.getDeclaredMethod("wrapped", new Class[0]).invoke((Object)d, new Object[0]);
    }
}

