/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import io.github.spark_redshift_community.spark.redshift.DefaultJDBCWrapper$;
import io.github.spark_redshift_community.spark.redshift.JDBCWrapper;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.RedshiftRelation;
import io.github.spark_redshift_community.spark.redshift.RedshiftWriter;
import io.github.spark_redshift_community.spark.redshift.TableName;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftStrategy;
import java.io.Serializable;
import java.sql.Connection;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ExperimentalMethods;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0006\r\u0001]A\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!)\u0001\r\u0001C\u0001C\"9Q\r\u0001b\u0001\n\u00131\u0007BB7\u0001A\u0003%q\rC\u0003a\u0001\u0011\u0005a\u000eC\u0003p\u0001\u0011\u0005\u0003\u000f\u0003\u0004p\u0001\u0011\u0005\u0013q\u0002\u0005\u0007_\u0002!\t%!\n\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z\tiA)\u001a4bk2$8k\\;sG\u0016T!!\u0004\b\u0002\u0011I,Gm\u001d5jMRT!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012\u0001G:qCJ\\wL]3eg\"Lg\r^0d_6lWO\\5us*\u00111\u0003F\u0001\u0007O&$\b.\u001e2\u000b\u0003U\t!![8\u0004\u0001M)\u0001\u0001\u0007\u0010,]A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"aH\u0015\u000e\u0003\u0001R!!\t\u0012\u0002\u000fM|WO]2fg*\u00111\u0005J\u0001\u0004gFd'BA\b&\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\n\u0005)\u0002#\u0001\u0005*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\tyB&\u0003\u0002.A\t12k\u00195f[\u0006\u0014V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002 _%\u0011\u0001\u0007\t\u0002\u001a\u0007J,\u0017\r^1cY\u0016\u0014V\r\\1uS>t\u0007K]8wS\u0012,'/A\u0006kI\n\u001cwK]1qa\u0016\u0014\bCA\u001a5\u001b\u0005a\u0011BA\u001b\r\u0005-QEIQ\"Xe\u0006\u0004\b/\u001a:\u0002\u001fM\u001c4\t\\5f]R4\u0015m\u0019;pef\u0004R!\u0007\u001d;\tbK!!\u000f\u000e\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004CA\u001eC\u001b\u0005a$BA\u001f?\u0003\u0011\tW\u000f\u001e5\u000b\u0005}\u0002\u0015!C1nCj|g.Y<t\u0015\u0005\t\u0015aA2p[&\u00111\t\u0010\u0002\u0017\u0003^\u001b6I]3eK:$\u0018.\u00197t!J|g/\u001b3feB\u0011Q)\u0016\b\u0003\rNs!a\u0012*\u000f\u0005!\u000bfBA%Q\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N-\u00051AH]8pizJ\u0011!F\u0005\u0003'QI!!\u0005\n\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\t!F\"\u0001\u0006QCJ\fW.\u001a;feNL!AV,\u0003!5+'oZ3e!\u0006\u0014\u0018-\\3uKJ\u001c(B\u0001+\r!\tIf,D\u0001[\u0015\tYF,\u0001\u0002tg)\u0011QLP\u0001\tg\u0016\u0014h/[2fg&\u0011qL\u0017\u0002\t\u00036\f'p\u001c8Tg\u00051A(\u001b8jiz\"2AY2e!\t\u0019\u0004\u0001C\u00032\u0007\u0001\u0007!\u0007C\u00037\u0007\u0001\u0007q'A\u0002m_\u001e,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u001e\nQa\u001d7gi)L!\u0001\\5\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0015\u0003\t\fab\u0019:fCR,'+\u001a7bi&|g\u000eF\u0002rij\u0004\"a\b:\n\u0005M\u0004#\u0001\u0004\"bg\u0016\u0014V\r\\1uS>t\u0007\"B;\b\u0001\u00041\u0018AC:rY\u000e{g\u000e^3yiB\u0011q\u000f_\u0007\u0002E%\u0011\u0011P\t\u0002\u000b'Fc5i\u001c8uKb$\b\"B>\b\u0001\u0004a\u0018A\u00039be\u0006lW\r^3sgB9Q0a\u0001\u0002\n\u0005%aB\u0001@\u0000!\tY%$C\u0002\u0002\u0002i\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u00111!T1q\u0015\r\t\tA\u0007\t\u0004{\u0006-\u0011\u0002BA\u0007\u0003\u000f\u0011aa\u0015;sS:<GcB9\u0002\u0012\u0005M\u0011Q\u0003\u0005\u0006k\"\u0001\rA\u001e\u0005\u0006w\"\u0001\r\u0001 \u0005\b\u0003/A\u0001\u0019AA\r\u0003\u0019\u00198\r[3nCB!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 \t\nQ\u0001^=qKNLA!a\t\u0002\u001e\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0015\u0013E\f9#!\u000b\u00024\u0005U\u0002\"B;\n\u0001\u00041\bbBA\u0016\u0013\u0001\u0007\u0011QF\u0001\tg\u00064X-T8eKB\u0019q/a\f\n\u0007\u0005E\"E\u0001\u0005TCZ,Wj\u001c3f\u0011\u0015Y\u0018\u00021\u0001}\u0011\u001d\t9$\u0003a\u0001\u0003s\tA\u0001Z1uCB!\u00111HA)\u001d\u0011\ti$!\u0014\u000f\t\u0005}\u00121\n\b\u0005\u0003\u0003\nIE\u0004\u0003\u0002D\u0005\u001dcbA&\u0002F%\t\u0001&\u0003\u0002'O%\u0011q\"J\u0005\u0003G\u0011J1!a\u0014#\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0015\u0002V\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003\u001f\u0012\u0013!F3oC\ndW\rU;tQ\u0012|wO\\*fgNLwN\u001c\u000b\u0005\u00037\n\t\u0007E\u0002\u001a\u0003;J1!a\u0018\u001b\u0005\u0011)f.\u001b;\t\u000f\u0005\r$\u00021\u0001\u0002f\u000591/Z:tS>t\u0007cA<\u0002h%\u0019\u0011\u0011\u000e\u0012\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider {
    private final JDBCWrapper jdbcWrapper;
    private final Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelation(sqlContext, parameters, null);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        Parameters.MergedParameters params = Parameters$.MODULE$.mergeParameters(parameters);
        if (params.autoPushdown()) {
            this.enablePushdownSession(sqlContext.sparkSession());
        }
        return new RedshiftRelation(this.jdbcWrapper, this.s3ClientFactory, params, (Option<StructType>)Option$.MODULE$.apply((Object)schema), sqlContext);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode saveMode, Map<String, String> parameters, Dataset<Row> data) {
        block12: {
            Tuple2.mcZZ.sp sp2;
            Parameters.MergedParameters params = Parameters$.MODULE$.mergeParameters(parameters);
            TableName table = (TableName)params.table().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("For save operations you must specify a Redshift table name with the 'dbtable' parameter");
            });
            SaveMode saveMode2 = saveMode;
            if (SaveMode.Append.equals(saveMode2)) {
                sp2 = new Tuple2.mcZZ.sp(true, false);
            } else if (SaveMode.Overwrite.equals(saveMode2)) {
                sp2 = new Tuple2.mcZZ.sp(true, true);
            } else if (SaveMode.ErrorIfExists.equals(saveMode2)) {
                if (this.tableExists$1(params, table)) {
                    throw package$.MODULE$.error(new StringBuilder(57).append("Table ").append(table).append(" already exists! (SaveMode is set to ErrorIfExists)").toString());
                }
                sp2 = new Tuple2.mcZZ.sp(true, false);
            } else if (SaveMode.Ignore.equals(saveMode2)) {
                Tuple2.mcZZ.sp sp3;
                if (this.tableExists$1(params, table)) {
                    this.log().info(new StringBuilder(47).append("Table ").append(table).append(" already exists -- ignoring save request.").toString());
                    sp3 = new Tuple2.mcZZ.sp(false, false);
                } else {
                    sp3 = new Tuple2.mcZZ.sp(true, false);
                }
                sp2 = sp3;
            } else {
                throw new MatchError((Object)saveMode2);
            }
            Tuple2.mcZZ.sp sp4 = sp2;
            if (sp4 == null) {
                throw new MatchError((Object)sp4);
            }
            boolean doSave = sp4._1$mcZ$sp();
            boolean dropExisting = sp4._2$mcZ$sp();
            Tuple2.mcZZ.sp sp5 = new Tuple2.mcZZ.sp(doSave, dropExisting);
            Tuple2.mcZZ.sp sp6 = sp5;
            boolean doSave2 = sp6._1$mcZ$sp();
            boolean dropExisting2 = sp6._2$mcZ$sp();
            if (!doSave2) break block12;
            Map updatedParams = parameters.updated((Object)"overwrite", (Object)Boolean.toString(dropExisting2));
            new RedshiftWriter(this.jdbcWrapper, this.s3ClientFactory).saveToRedshift(sqlContext, data, saveMode, Parameters$.MODULE$.mergeParameters((Map<String, String>)updatedParams));
        }
        return this.createRelation(sqlContext, parameters);
    }

    public void enablePushdownSession(SparkSession session) {
        block0: {
            if (session.experimental().extraStrategies().exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$enablePushdownSession$1(s)))) break block0;
            this.log().info("Enable auto pushdown.");
            ExperimentalMethods experimentalMethods = session.experimental();
            experimentalMethods.extraStrategies_$eq((Seq)experimentalMethods.extraStrategies().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new RedshiftStrategy(session), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
        }
    }

    private final boolean tableExists$1(Parameters.MergedParameters params$1, TableName table$1) {
        boolean bl;
        try (Connection conn = this.jdbcWrapper.getConnector(params$1.jdbcDriver(), params$1.jdbcUrl(), (Option<Parameters.MergedParameters>)new Some((Object)params$1));){
            bl = this.jdbcWrapper.tableExists(conn, table$1.toString());
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$enablePushdownSession$1(SparkStrategy s) {
        return s instanceof RedshiftStrategy;
    }

    public DefaultSource(JDBCWrapper jdbcWrapper, Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory) {
        this.jdbcWrapper = jdbcWrapper;
        this.s3ClientFactory = s3ClientFactory;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public DefaultSource() {
        this(DefaultJDBCWrapper$.MODULE$, Utils$.MODULE$.s3ClientBuilder());
    }
}

