/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import scala.Function0;
import scala.Serializable;

public final class AWSCredentialsUtils$ {
    public static AWSCredentialsUtils$ MODULE$;

    static {
        new AWSCredentialsUtils$();
    }

    public String getRedshiftCredentialsString(Parameters.MergedParameters params, AWSCredentials sparkAwsCredentials) {
        String string;
        if (params.iamRole().isDefined()) {
            string = new StringBuilder(13).append("aws_iam_role=").append(params.iamRole().get()).toString();
        } else if (params.temporaryAWSCredentials().isDefined()) {
            string = AWSCredentialsUtils$.awsCredsToString$1(((AWSCredentialsProvider)params.temporaryAWSCredentials().get()).getCredentials());
        } else if (params.forwardSparkS3Credentials()) {
            string = AWSCredentialsUtils$.awsCredsToString$1(sparkAwsCredentials);
        } else {
            throw new IllegalStateException("No Redshift S3 authentication mechanism was specified");
        }
        return string;
    }

    public AWSCredentialsProvider staticCredentialsProvider(AWSCredentials credentials) {
        return new AWSCredentialsProvider(credentials){
            private final AWSCredentials credentials$1;

            public AWSCredentials getCredentials() {
                return this.credentials$1;
            }

            public void refresh() {
            }
            {
                this.credentials$1 = credentials$1;
            }
        };
    }

    public AWSCredentialsProvider load(Parameters.MergedParameters params, Configuration hadoopConfiguration) {
        return (AWSCredentialsProvider)params.temporaryAWSCredentials().getOrElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.loadFromURI(params.rootTempDir(), hadoopConfiguration));
    }

    private AWSCredentialsProvider loadFromURI(String tempPath, Configuration hadoopConfiguration) {
        URI uri = new URI(tempPath);
        String uriScheme = uri.getScheme();
        String string = uriScheme;
        boolean bl = "s3".equals(string) ? true : ("s3n".equals(string) ? true : "s3a".equals(string));
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Unrecognized scheme ").append(string).append("; expected s3, s3n, or s3a").toString());
        }
        DefaultAWSCredentialsProviderChain defaultAWSCredentialsProviderChain = new DefaultAWSCredentialsProviderChain();
        return defaultAWSCredentialsProviderChain;
    }

    private static final String awsCredsToString$1(AWSCredentials credentials) {
        String string;
        AWSCredentials aWSCredentials = credentials;
        if (aWSCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
            string = new StringBuilder(48).append("aws_access_key_id=").append(aWSSessionCredentials.getAWSAccessKeyId()).append(";").append("aws_secret_access_key=").append(aWSSessionCredentials.getAWSSecretKey()).append(";token=").append(aWSSessionCredentials.getSessionToken()).toString();
        } else {
            string = new StringBuilder(41).append("aws_access_key_id=").append(aWSCredentials.getAWSAccessKeyId()).append(";").append("aws_secret_access_key=").append(aWSCredentials.getAWSSecretKey()).toString();
        }
        return string;
    }

    private AWSCredentialsUtils$() {
        MODULE$ = this;
    }
}

