/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger.test;

import io.github.robwin.swagger.test.SwaggerAssertionType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SwaggerAssertionConfig {
    private static final String PREFIX = "assertj.swagger.";
    private static final String IGNORE_MISSING_PATHS = "pathsToIgnoreInExpected";
    private static final String IGNORE_MISSING_DEFINITIONS = "definitionsToIgnoreInExpected";
    private static final String IGNORE_MISSING_PROPERTIES = "propertiesToIgnoreInExpected";
    private static final String PATHS_PREPEND_EXPECTED = "pathsPrependExpected";
    private Map<SwaggerAssertionType, Boolean> swaggerAssertionFlags = new HashMap<SwaggerAssertionType, Boolean>();
    private Set<String> pathsToIgnoreInExpected = Collections.emptySet();
    private Set<String> propertiesToIgnoreInExpected = Collections.emptySet();
    private Set<String> definitionsToIgnoreInExpected = Collections.emptySet();
    private String pathsPrependExpected;

    public SwaggerAssertionConfig() {
        SwaggerAssertionType[] assertionTypes;
        for (SwaggerAssertionType assertionType : assertionTypes = SwaggerAssertionType.values()) {
            this.swaggerAssertionFlags.put(assertionType, assertionType.isEnabledByDefault());
        }
    }

    public SwaggerAssertionConfig(Properties props) {
        this();
        String ignoreMissingPropertiesStr;
        String ignoreMissingDefinitionsStr;
        SwaggerAssertionType[] assertionTypes;
        for (SwaggerAssertionType assertionType : assertionTypes = SwaggerAssertionType.values()) {
            String value = props.getProperty(PREFIX + assertionType.getBarePropertyName());
            if (value != null) {
                this.swaggerAssertionFlags.put(assertionType, Boolean.TRUE.toString().equals(value));
                continue;
            }
            this.swaggerAssertionFlags.put(assertionType, assertionType.isEnabledByDefault());
        }
        String ignoreMissingPathsStr = props.getProperty("assertj.swagger.pathsToIgnoreInExpected");
        if (!StringUtils.isBlank((CharSequence)ignoreMissingPathsStr)) {
            this.pathsToIgnoreInExpected = this.splitCommaDelimStrIntoSet(ignoreMissingPathsStr);
        }
        if (!StringUtils.isBlank((CharSequence)(ignoreMissingDefinitionsStr = props.getProperty("assertj.swagger.definitionsToIgnoreInExpected")))) {
            this.definitionsToIgnoreInExpected = this.splitCommaDelimStrIntoSet(ignoreMissingDefinitionsStr);
        }
        if (!StringUtils.isBlank((CharSequence)(ignoreMissingPropertiesStr = props.getProperty("assertj.swagger.propertiesToIgnoreInExpected")))) {
            this.propertiesToIgnoreInExpected = this.splitCommaDelimStrIntoSet(ignoreMissingPropertiesStr);
        }
        this.pathsPrependExpected = props.getProperty("assertj.swagger.pathsPrependExpected");
    }

    public boolean swaggerAssertionEnabled(SwaggerAssertionType assertionType) {
        Boolean flag = this.swaggerAssertionFlags.get((Object)assertionType);
        return flag != null ? flag.booleanValue() : assertionType.isEnabledByDefault();
    }

    public Set<String> getPathsToIgnoreInExpected() {
        return this.pathsToIgnoreInExpected;
    }

    public Set<String> getDefinitionsToIgnoreInExpected() {
        return this.definitionsToIgnoreInExpected;
    }

    public Set<String> getPropertiesToIgnoreInExpected() {
        return this.propertiesToIgnoreInExpected;
    }

    public String getPathsPrependExpected() {
        return this.pathsPrependExpected;
    }

    private Set<String> splitCommaDelimStrIntoSet(String str) {
        String[] strs = str.split("\\s*,\\s*");
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(strs)));
    }
}

