/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger.test;

import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SchemaObjectResolver {
    private Swagger expected;
    private Swagger actual;

    SchemaObjectResolver(Swagger expected, Swagger actual) {
        this.expected = expected;
        this.actual = actual;
    }

    List<String> getExpectedConsumes(Operation op) {
        return this.getListWithFallback(op.getConsumes(), this.expected.getConsumes());
    }

    List<String> getActualConsumes(Operation op) {
        return this.getListWithFallback(op.getConsumes(), this.actual.getConsumes());
    }

    List<String> getExpectedProduces(Operation op) {
        return this.getListWithFallback(op.getProduces(), this.expected.getProduces());
    }

    List<String> getActualProduces(Operation op) {
        return this.getListWithFallback(op.getProduces(), this.actual.getProduces());
    }

    Map<String, Property> resolvePropertiesFromExpected(Model definition) {
        return this.resolveProperties(definition, this.expected, new HashSet<String>());
    }

    Map<String, Property> resolvePropertiesFromActual(Model definition) {
        return this.resolveProperties(definition, this.actual, new HashSet<String>());
    }

    private Map<String, Property> resolveProperties(Model definition, Swagger owningSchema, Set<String> seenRefs) {
        Map<Object, Object> result;
        HashMap definitionProperties;
        HashMap hashMap = definitionProperties = definition.getProperties() != null ? definition.getProperties() : Collections.emptyMap();
        if (definition instanceof RefModel) {
            RefModel refDef = (RefModel)definition;
            if (seenRefs.contains(refDef.getSimpleRef())) {
                return Collections.emptyMap();
            }
            seenRefs.add(refDef.getSimpleRef());
            result = this.resolveProperties(this.findDefinition(owningSchema.getDefinitions(), refDef), owningSchema, seenRefs);
        } else if (definition instanceof ComposedModel) {
            HashMap allProperties = new HashMap();
            if (definitionProperties != null) {
                allProperties.putAll(definitionProperties);
            }
            for (Model childDefinition : ((ComposedModel)definition).getAllOf()) {
                allProperties.putAll(this.resolveProperties(childDefinition, owningSchema, seenRefs));
            }
            result = allProperties;
        } else {
            result = definitionProperties;
        }
        return result;
    }

    private Model findDefinition(Map<String, Model> defs, RefModel refModel) {
        return defs.get(refModel.getSimpleRef());
    }

    private <A> List<A> getListWithFallback(List<A> localDefn, List<A> globalDefn) {
        List<Object> result = localDefn != null && !localDefn.isEmpty() ? localDefn : (globalDefn != null ? globalDefn : Collections.emptyList());
        return result;
    }
}

