/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.util;

import com.robothy.s3.core.asserionts.VersionedObjectAssertions;
import com.robothy.s3.core.model.internal.ObjectMetadata;
import com.robothy.s3.core.model.internal.VersionedObjectMetadata;
import java.util.Objects;

public class VersionedObjectUtils {
    public static VersionedObjectMetadata getVersionedObjectMetadata(ObjectMetadata objectMetadata, String inputVersionId) {
        if (Objects.isNull(inputVersionId)) {
            return objectMetadata.getLatest();
        }
        if ("null".equals(inputVersionId)) {
            return VersionedObjectAssertions.assertVirtualVersionExist(objectMetadata);
        }
        return VersionedObjectAssertions.assertVersionedObjectExist(objectMetadata, inputVersionId);
    }

    public static String resolveReturnedVersion(ObjectMetadata objectMetadata, String inputVersionId) {
        if (Objects.isNull(inputVersionId)) {
            if (objectMetadata.getVirtualVersion().map(virtualVersion -> virtualVersion.equals(objectMetadata.getLatestVersion())).orElse(false).booleanValue()) {
                return "null";
            }
            return objectMetadata.getLatestVersion();
        }
        return inputVersionId;
    }
}

