/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class JsonUtils {
    private static final JsonMapper jsonMapper = new JsonMapper();
    private static final ObjectReader jsonReader;
    private static final ObjectWriter jsonWriter;
    private static final ObjectWriter prettyJsonWriter;

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)jsonReader.readValue(json, clazz);
    }

    public static <T> T fromJson(URL url, Class<T> clazz) {
        return (T)jsonReader.readValue(url, clazz);
    }

    public static <T> T fromJson(File jsonFile, Class<T> clazz) {
        return (T)jsonReader.readValue(jsonFile, clazz);
    }

    public static <T> T fromJson(InputStream jsonInputStream, Class<T> clazz) {
        return (T)jsonReader.readValue(jsonInputStream, clazz);
    }

    public static String toJson(Object object) {
        return jsonWriter.writeValueAsString(object);
    }

    public static void toJson(File destFile, Object object) {
        jsonWriter.writeValue(destFile, object);
    }

    public static void toJson(OutputStream out, Object object) {
        jsonWriter.writeValue(out, object);
    }

    public static String toPrettyJson(Object object) {
        return prettyJsonWriter.writeValueAsString(object);
    }

    public static void toPrettyJson(File destFile, Object object) {
        prettyJsonWriter.writeValue(destFile, object);
    }

    public static void toPrettyJson(OutputStream out, Object object) {
        prettyJsonWriter.writeValue(out, object);
    }

    static {
        jsonMapper.registerModule((Module)new Jdk8Module());
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonReader = jsonMapper.reader();
        jsonWriter = jsonMapper.writer();
        prettyJsonWriter = jsonMapper.writer().withDefaultPrettyPrinter();
    }
}

