/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.util;

import java.util.UUID;

public class IdUtils {
    private static final long S4_EPOCH = 1645837713L;
    private static final long SEQUENCE_ID_BITS = 12L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATACENTER_BITS = 5L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATACENTER_ID = 31L;
    private static final long SEQUENCE_SHIFT = 12L;
    private static final long DATACENTER_ID_SHIFT = 17L;
    private static final long TIMESTMP_SHIFT = 22L;
    private long datacenterId;
    private long machineId;
    private long sequence = 0L;
    private long lastStmp = -1L;
    private static final IdUtils GENERATOR = new IdUtils(0L, 0L);

    public static IdUtils defaultGenerator() {
        return GENERATOR;
    }

    public static String nextUuid() {
        return UUID.randomUUID().toString();
    }

    public IdUtils(long datacenterId, long workerId) {
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenterId can't be greater than %d or less than 0", 31L));
        }
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.datacenterId = datacenterId;
        this.machineId = workerId;
    }

    public String nextStrId() {
        return String.valueOf(this.nextId());
    }

    public synchronized long nextId() {
        long currStmp = this.getNewTimestamp();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        return currStmp - 1645837713L << 22 | this.datacenterId << 17 | this.machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewTimestamp();
        while (mill <= this.lastStmp) {
            mill = this.getNewTimestamp();
        }
        return mill;
    }

    private long getNewTimestamp() {
        return System.currentTimeMillis();
    }
}

