/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.storage;

import com.robothy.s3.core.storage.CopyOnAccessStorage;
import com.robothy.s3.core.storage.InMemoryStorage;
import com.robothy.s3.core.storage.LayeredStorage;
import com.robothy.s3.core.storage.LocalFileSystemStorage;
import com.robothy.s3.core.util.IdUtils;
import java.io.InputStream;
import java.nio.file.Path;

public interface Storage {
    public static Storage createInMemory() {
        return new InMemoryStorage();
    }

    public static Storage createInMemory(int maxTotalSize) {
        return new InMemoryStorage(maxTotalSize);
    }

    public static Storage createPersistent(Path path) {
        return new LocalFileSystemStorage(path);
    }

    public static Storage createLayered(Storage frontend, Storage backend) {
        return new LayeredStorage(frontend, backend);
    }

    public static Storage createCopyOnAccess(Storage base) {
        return new CopyOnAccessStorage(base);
    }

    default public Long put(byte[] data) {
        return this.put((Long)IdUtils.defaultGenerator().nextId(), data);
    }

    public Long put(Long var1, byte[] var2);

    default public Long put(InputStream data) {
        return this.put((Long)IdUtils.defaultGenerator().nextId(), data);
    }

    public Long put(Long var1, InputStream var2);

    public byte[] getBytes(Long var1);

    public InputStream getInputStream(Long var1);

    public Long delete(Long var1);

    public boolean isExist(Long var1);
}

