/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.storage;

import com.robothy.s3.core.storage.Storage;
import com.robothy.s3.core.util.PathUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

class LocalFileSystemStorage
implements Storage {
    private final Path directory;

    public LocalFileSystemStorage(Path dataPath) {
        Objects.requireNonNull(dataPath);
        this.directory = dataPath;
        PathUtils.createDirectoryIfNotExit(this.directory);
    }

    @Override
    public Long put(Long id, byte[] data) {
        Files.write(Paths.get(this.directory.toString(), String.valueOf(id)), data, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        return id;
    }

    @Override
    public Long put(Long id, InputStream data) {
        Path objectPath = Paths.get(this.directory.toString(), String.valueOf(id));
        try (InputStream _data = data;
             OutputStream out = Files.newOutputStream(objectPath, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            IOUtils.copy((InputStream)_data, (OutputStream)out);
        }
        return id;
    }

    @Override
    public byte[] getBytes(Long id) {
        this.ensureExists(id);
        return Files.readAllBytes(Paths.get(this.directory.toString(), String.valueOf(id)));
    }

    @Override
    public InputStream getInputStream(Long id) {
        this.ensureExists(id);
        return Files.newInputStream(Paths.get(this.directory.toString(), String.valueOf(id)), new OpenOption[0]);
    }

    @Override
    public Long delete(Long id) {
        this.ensureExists(id);
        Files.delete(Paths.get(this.directory.toString(), String.valueOf(id)));
        return id;
    }

    @Override
    public boolean isExist(Long id) {
        return Files.exists(Paths.get(this.directory.toString(), String.valueOf(id)), new LinkOption[0]);
    }

    private void ensureExists(Long id) {
        if (!this.isExist(id)) {
            throw new IllegalArgumentException("Object id='" + id + "' not exist.");
        }
    }
}

