/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.storage;

import com.robothy.s3.core.storage.Storage;
import java.io.InputStream;
import java.util.Objects;

class LayeredStorage
implements Storage {
    private final Storage back;
    private final Storage front;

    public LayeredStorage(Storage frontend, Storage backend) {
        Objects.requireNonNull(frontend);
        Objects.requireNonNull(backend);
        this.front = frontend;
        this.back = backend;
    }

    @Override
    public Long put(Long id, byte[] data) {
        return this.front.put(id, data);
    }

    @Override
    public Long put(Long id, InputStream data) {
        return this.front.put(id, data);
    }

    @Override
    public byte[] getBytes(Long id) {
        return this.front.isExist(id) ? this.front.getBytes(id) : this.back.getBytes(id);
    }

    @Override
    public InputStream getInputStream(Long id) {
        return this.front.isExist(id) ? this.front.getInputStream(id) : this.back.getInputStream(id);
    }

    @Override
    public Long delete(Long id) {
        if (this.front.isExist(id)) {
            return this.front.delete(id);
        }
        if (!this.back.isExist(id)) {
            this.back.delete(id);
        }
        return id;
    }

    @Override
    public boolean isExist(Long id) {
        return this.front.isExist(id) || this.back.isExist(id);
    }
}

