/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.storage;

import com.robothy.s3.core.exception.TotalSizeExceedException;
import com.robothy.s3.core.storage.Storage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

class InMemoryStorage
implements Storage {
    private final Map<Long, byte[]> store = new ConcurrentHashMap<Long, byte[]>();
    private final AtomicLong totalSize = new AtomicLong(0L);
    private final AtomicLong maxTotalSize = new AtomicLong(Long.MAX_VALUE);

    InMemoryStorage(long maxTotalSize) {
        this.maxTotalSize.set(maxTotalSize);
    }

    InMemoryStorage() {
    }

    @Override
    public Long put(Long id, byte[] data) {
        this.ensureNotExceedTotalSize(data.length);
        byte[] copy = Arrays.copyOf(data, data.length);
        this.store.put(id, copy);
        this.totalSize.addAndGet(data.length);
        return id;
    }

    @Override
    public Long put(Long id, InputStream data) {
        return this.put(id, data.readAllBytes());
    }

    @Override
    public byte[] getBytes(Long id) {
        this.ensureObjectExist(id);
        byte[] data = this.store.get(id);
        return Arrays.copyOf(data, data.length);
    }

    @Override
    public InputStream getInputStream(Long id) {
        byte[] data = this.getBytes(id);
        return new ByteArrayInputStream(data);
    }

    @Override
    public Long delete(Long id) {
        this.ensureObjectExist(id);
        int size = this.store.get(id).length;
        this.store.remove(id);
        this.totalSize.addAndGet(-size);
        return id;
    }

    @Override
    public boolean isExist(Long id) {
        return this.store.containsKey(id);
    }

    private void ensureObjectExist(Long id) {
        if (!this.isExist(id)) {
            throw new IllegalArgumentException("Object id='" + id + "' not exists.");
        }
    }

    private void ensureNotExceedTotalSize(int incrementalSize) {
        if (this.totalSize.get() + (long)incrementalSize > this.maxTotalSize.get()) {
            throw new TotalSizeExceedException(this.maxTotalSize.get(), this.totalSize.get() + (long)incrementalSize);
        }
    }
}

