/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.storage;

import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.storage.MetadataStore;
import com.robothy.s3.core.util.JsonUtils;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemBucketMetadataStore
implements MetadataStore<BucketMetadata> {
    private static final Logger log = LoggerFactory.getLogger(FileSystemBucketMetadataStore.class);
    private static final String BUCKET_METADATA_FILE_SUFFIX = ".bucket.meta";
    private final Path dataPath;

    public static MetadataStore<BucketMetadata> create(Path dataPath) {
        Objects.requireNonNull(dataPath);
        File file = dataPath.toFile();
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            throw new IllegalStateException("Failed to create directory " + dataPath.toAbsolutePath());
        }
        return new FileSystemBucketMetadataStore(dataPath);
    }

    private FileSystemBucketMetadataStore(Path path) {
        this.dataPath = path;
    }

    @Override
    public BucketMetadata fetch(String bucketName) {
        log.debug("Fetching metadata of bucket {}.", (Object)bucketName);
        return JsonUtils.fromJson(new File(this.dataPath.toFile(), bucketName + BUCKET_METADATA_FILE_SUFFIX), BucketMetadata.class);
    }

    @Override
    public String store(String bucketName, BucketMetadata bucketMetadata) {
        if (StringUtils.isBlank((CharSequence)bucketMetadata.getBucketName())) {
            throw new IllegalArgumentException("Invalid bucket name '" + bucketMetadata.getBucketName() + "'.");
        }
        JsonUtils.toJson(new File(this.dataPath.toFile(), bucketMetadata.getBucketName() + BUCKET_METADATA_FILE_SUFFIX), (Object)bucketMetadata);
        return bucketMetadata.getBucketName();
    }

    @Override
    public void delete(String bucketName) {
        if (!new File(this.dataPath.toFile(), bucketName + BUCKET_METADATA_FILE_SUFFIX).delete()) {
            throw new IllegalStateException("Failed to delete metadata of bucket " + bucketName);
        }
    }

    @Override
    public List<BucketMetadata> fetchAll() {
        List<BucketMetadata> list;
        block8: {
            Stream<Path> pathStream = Files.walk(this.dataPath, 1, new FileVisitOption[0]);
            try {
                list = pathStream.filter(path -> path.toString().endsWith(BUCKET_METADATA_FILE_SUFFIX)).map(path -> path.getFileName().toString()).map(fileName -> fileName.substring(0, fileName.lastIndexOf(BUCKET_METADATA_FILE_SUFFIX))).map(this::fetch).collect(Collectors.toList());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                if (pathStream != null) {
                    try {
                        pathStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            pathStream.close();
        }
        return list;
    }
}

