/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.storage;

import com.robothy.s3.core.storage.Storage;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;

class CopyOnAccessStorage
implements Storage {
    private final Storage base;
    private final Storage real;

    CopyOnAccessStorage(Storage base) {
        Objects.requireNonNull(base);
        this.base = base;
        this.real = Storage.createInMemory();
    }

    @Override
    public Long put(Long id, byte[] data) {
        return this.real.put(id, data);
    }

    @Override
    public Long put(Long id, InputStream data) {
        return this.real.put(id, data);
    }

    @Override
    public byte[] getBytes(Long id) {
        if (this.real.isExist(id)) {
            return this.real.getBytes(id);
        }
        byte[] data = this.base.getBytes(id);
        this.real.put(id, Arrays.copyOf(data, data.length));
        return this.real.getBytes(id);
    }

    @Override
    public InputStream getInputStream(Long id) {
        if (this.real.isExist(id)) {
            return this.real.getInputStream(id);
        }
        InputStream data = this.base.getInputStream(id);
        this.real.put(id, data);
        return this.real.getInputStream(id);
    }

    @Override
    public Long delete(Long id) {
        if (this.real.isExist(id)) {
            return this.real.delete(id);
        }
        if (!this.base.isExist(id)) {
            this.base.delete(id);
        }
        return id;
    }

    @Override
    public boolean isExist(Long id) {
        return this.real.isExist(id) || this.base.isExist(id);
    }
}

