/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service.manager;

import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.core.service.ObjectService;
import com.robothy.s3.core.service.manager.FileSystemLocalS3Manager;
import com.robothy.s3.core.service.manager.InMemoryLocalS3Manager;
import java.nio.file.Path;

public interface LocalS3Manager {
    public static final String STORAGE_DIRECTORY = ".storage";

    public static LocalS3Manager createInMemoryS3Manager() {
        return new InMemoryLocalS3Manager(null, false);
    }

    public static LocalS3Manager createInMemoryS3Manager(Path dataDirectory, boolean enabledInitialDataCache) {
        return new InMemoryLocalS3Manager(dataDirectory, enabledInitialDataCache);
    }

    public static LocalS3Manager createFileSystemS3Manager(Path dataDirectory) {
        return new FileSystemLocalS3Manager(dataDirectory);
    }

    public BucketService bucketService();

    public ObjectService objectService();
}

