/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service.manager;

import com.robothy.s3.core.model.internal.LocalS3Metadata;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.core.service.InMemoryBucketService;
import com.robothy.s3.core.service.InMemoryObjectService;
import com.robothy.s3.core.service.ObjectService;
import com.robothy.s3.core.service.loader.FileSystemS3MetadataLoader;
import com.robothy.s3.core.service.manager.LocalS3Manager;
import com.robothy.s3.core.service.manager.LocalS3ServicesInvocationHandler;
import com.robothy.s3.core.storage.Storage;
import com.robothy.s3.core.util.JsonUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class InMemoryLocalS3Manager
implements LocalS3Manager {
    private final LocalS3Metadata s3Metadata;
    private final Storage storage;
    private static final InitialDataCache cache = new InitialDataCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InMemoryLocalS3Manager(Path initialDataPath, boolean enableInitialDataCache) {
        if (Objects.isNull(initialDataPath) || !Files.exists(initialDataPath, new LinkOption[0])) {
            this.storage = Storage.createInMemory();
            this.s3Metadata = new LocalS3Metadata();
        } else {
            String absPath = initialDataPath.toAbsolutePath().toString();
            Path storagePath = Paths.get(initialDataPath.toAbsolutePath().toString(), ".storage");
            if (enableInitialDataCache) {
                if (cache.get(absPath).isEmpty()) {
                    InitialDataCache initialDataCache = cache;
                    synchronized (initialDataCache) {
                        if (cache.get(absPath).isEmpty()) {
                            LocalS3Metadata metadata = this.loadS3Metadata(initialDataPath);
                            Storage persistent = Storage.createPersistent(storagePath);
                            Storage copyOnAccess = Storage.createCopyOnAccess(persistent);
                            InitialDataCache.CacheValue cacheValue = new InitialDataCache.CacheValue(metadata, copyOnAccess);
                            cache.put(absPath, cacheValue);
                        }
                    }
                }
                InitialDataCache.CacheValue cacheValue = cache.get(absPath).get();
                this.storage = cacheValue.storage();
                this.s3Metadata = cacheValue.metadata();
            } else {
                this.storage = Storage.createLayered(Storage.createInMemory(), Storage.createPersistent(storagePath));
                this.s3Metadata = this.loadS3Metadata(initialDataPath);
            }
        }
    }

    InMemoryLocalS3Manager(LocalS3Metadata initialMetadata, Storage initialStorage) {
        this.s3Metadata = Optional.ofNullable(initialMetadata).orElseGet(LocalS3Metadata::new);
        this.storage = Optional.ofNullable(initialStorage).orElseGet(Storage::createInMemory);
    }

    @Override
    public BucketService bucketService() {
        BucketService bucketService = InMemoryBucketService.create(this.s3Metadata);
        LocalS3ServicesInvocationHandler invocationHandler = new LocalS3ServicesInvocationHandler(bucketService, this.s3Metadata, null);
        return (BucketService)Proxy.newProxyInstance(BucketService.class.getClassLoader(), new Class[]{BucketService.class}, (InvocationHandler)invocationHandler);
    }

    @Override
    public ObjectService objectService() {
        ObjectService objectService = InMemoryObjectService.create(this.s3Metadata, this.storage);
        LocalS3ServicesInvocationHandler invocationHandler = new LocalS3ServicesInvocationHandler(objectService, this.s3Metadata, null);
        return (ObjectService)Proxy.newProxyInstance(ObjectService.class.getClassLoader(), new Class[]{ObjectService.class}, (InvocationHandler)invocationHandler);
    }

    private LocalS3Metadata loadS3Metadata(Path initialDataDirectory) {
        if (Objects.isNull(initialDataDirectory)) {
            return new LocalS3Metadata();
        }
        if (!Files.exists(initialDataDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException(initialDataDirectory.toAbsolutePath() + " not found.");
        }
        return FileSystemS3MetadataLoader.create().load(initialDataDirectory);
    }

    static class InitialDataCache {
        private final Map<String, CacheValue> cache = new HashMap<String, CacheValue>();

        InitialDataCache() {
        }

        public Optional<CacheValue> get(String key) {
            return Optional.ofNullable(this.cache.get(key));
        }

        public void put(String key, CacheValue value) {
            this.cache.put(key, value);
        }

        static class CacheValue {
            private final LocalS3Metadata metadata;
            private final Storage storage;

            CacheValue(LocalS3Metadata metadata, Storage storage) {
                this.metadata = metadata;
                this.storage = storage;
            }

            public Storage storage() {
                return Storage.createLayered(Storage.createInMemory(), this.storage);
            }

            public LocalS3Metadata metadata() {
                return JsonUtils.fromJson(JsonUtils.toJson(this.metadata), LocalS3Metadata.class);
            }
        }
    }
}

