/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service.locks;

import com.robothy.s3.core.service.locks.BucketLock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class DefaultBucketLock
implements BucketLock {
    static final BucketLock singleton = new DefaultBucketLock();
    private final Map<String, ReadWriteLock> locks = new ConcurrentHashMap<String, ReadWriteLock>();

    DefaultBucketLock() {
    }

    @Override
    public Lock readLock(String bucketName) {
        return this.getLock(bucketName).readLock();
    }

    @Override
    public Lock writeLock(String bucketName) {
        return this.getLock(bucketName).writeLock();
    }

    private ReadWriteLock getLock(String bucketName) {
        return this.locks.computeIfAbsent(bucketName, k -> new ReentrantReadWriteLock());
    }
}

