/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketChanged;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.asserionts.UploadAssertions;
import com.robothy.s3.core.model.answers.UploadPartAns;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.UploadMetadata;
import com.robothy.s3.core.model.internal.UploadPartMetadata;
import com.robothy.s3.core.model.request.UploadPartOptions;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import com.robothy.s3.core.service.StorageApplicable;
import com.robothy.s3.core.util.S3ObjectUtils;
import java.util.NavigableMap;

public interface UploadPartService
extends LocalS3MetadataApplicable,
StorageApplicable {
    @BucketChanged
    @BucketWriteLock
    default public UploadPartAns uploadPart(String bucket, String key, String uploadId, Integer partNumber, UploadPartOptions options) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucket);
        UploadMetadata uploadMetadata = UploadAssertions.assertUploadExists(bucketMetadata, key, uploadId);
        NavigableMap<Integer, UploadPartMetadata> parts = uploadMetadata.getParts();
        if (parts.containsKey(partNumber)) {
            UploadPartMetadata uploadPartMetadata = (UploadPartMetadata)parts.get(partNumber);
            this.storage().delete(uploadPartMetadata.getFileId());
        }
        Long fileId = this.storage().put(options.getData());
        UploadPartMetadata uploadPartMetadata = UploadPartMetadata.builder().fileId(fileId).lastModified(System.currentTimeMillis()).size(options.getContentLength()).etag(options.getETag().orElseGet(() -> S3ObjectUtils.etag(this.storage().getInputStream(fileId)))).build();
        parts.put(partNumber, uploadPartMetadata);
        return UploadPartAns.builder().etag(uploadPartMetadata.getEtag()).build();
    }
}

