/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketChanged;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.model.answers.PutObjectAns;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.ObjectMetadata;
import com.robothy.s3.core.model.internal.VersionedObjectMetadata;
import com.robothy.s3.core.model.request.PutObjectOptions;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import com.robothy.s3.core.service.StorageApplicable;
import com.robothy.s3.core.util.IdUtils;
import com.robothy.s3.core.util.S3ObjectUtils;
import java.util.Objects;
import java.util.Optional;

public interface PutObjectService
extends LocalS3MetadataApplicable,
StorageApplicable {
    @BucketChanged
    @BucketWriteLock
    default public PutObjectAns putObject(String bucketName, String key, PutObjectOptions options) {
        ObjectMetadata objectMetadata;
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        String versionId = IdUtils.defaultGenerator().nextStrId();
        VersionedObjectMetadata versionedObjectMetadata = new VersionedObjectMetadata();
        versionedObjectMetadata.setCreationDate(System.currentTimeMillis());
        versionedObjectMetadata.setContentType(options.getContentType());
        versionedObjectMetadata.setSize(options.getSize());
        if (Objects.nonNull(options.getUserMetadata())) {
            versionedObjectMetadata.setUserMetadata(options.getUserMetadata());
        }
        Long fileId = this.storage().put(options.getContent());
        versionedObjectMetadata.setFileId(fileId);
        versionedObjectMetadata.setEtag(S3ObjectUtils.etag(this.storage().getInputStream(fileId)));
        options.getTagging().ifPresent(versionedObjectMetadata::setTagging);
        if (bucketMetadata.getObjectMetadata(key).isPresent()) {
            objectMetadata = bucketMetadata.getObjectMetadata(key).get();
            objectMetadata.putVersionedObjectMetadata(versionId, versionedObjectMetadata);
        } else {
            objectMetadata = new ObjectMetadata(versionId, versionedObjectMetadata);
            bucketMetadata.putObjectMetadata(key, objectMetadata);
        }
        String returnedVersionId = versionId;
        if (!Boolean.TRUE.equals(bucketMetadata.getVersioningEnabled())) {
            returnedVersionId = Objects.isNull(bucketMetadata.getVersioningEnabled()) ? null : "null";
            Optional<String> virtualVersionOpt = objectMetadata.getVirtualVersion();
            if (virtualVersionOpt.isPresent()) {
                String lastVirtualVersion = virtualVersionOpt.get();
                VersionedObjectMetadata previousVersion = objectMetadata.getVersionedObjectMap().remove(lastVirtualVersion);
                if (Objects.nonNull(previousVersion.getFileId())) {
                    this.storage().delete(previousVersion.getFileId());
                }
                objectMetadata.setVirtualVersion(versionId);
            } else {
                objectMetadata.setVirtualVersion(versionId);
            }
        }
        return PutObjectAns.builder().key(key).versionId(returnedVersionId).creationDate(versionedObjectMetadata.getCreationDate()).etag(versionedObjectMetadata.getEtag()).build();
    }
}

