/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketReadLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.asserionts.UploadAssertions;
import com.robothy.s3.core.exception.ObjectNotExistException;
import com.robothy.s3.core.exception.UploadNotExistException;
import com.robothy.s3.core.model.answers.ListPartsAns;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.LocalS3Metadata;
import com.robothy.s3.core.model.internal.UploadMetadata;
import com.robothy.s3.core.model.internal.UploadPartMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.SortedMap;

public interface ListPartsService
extends LocalS3MetadataApplicable {
    @BucketReadLock
    default public ListPartsAns listParts(String bucket, String key, String uploadId, Integer maxParts, Integer partNumberMarker) {
        UploadMetadata uploadMetadata;
        LocalS3Metadata s3Metadata = this.localS3Metadata();
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(s3Metadata, bucket);
        try {
            uploadMetadata = UploadAssertions.assertUploadExists(bucketMetadata, key, uploadId);
        }
        catch (ObjectNotExistException e) {
            throw new UploadNotExistException(key, uploadId);
        }
        if (Objects.isNull(partNumberMarker)) {
            partNumberMarker = 0;
        }
        if (Objects.isNull(maxParts) || maxParts > 1000) {
            maxParts = 1000;
        }
        int fromKeyInclusive = partNumberMarker + 1;
        int toKeyExclusive = fromKeyInclusive + maxParts;
        SortedMap<Integer, UploadPartMetadata> fetchedUploadPartMap = uploadMetadata.getParts().subMap(fromKeyInclusive, toKeyExclusive);
        ArrayList<ListPartsAns.Part> parts = new ArrayList<ListPartsAns.Part>(fetchedUploadPartMap.size());
        fetchedUploadPartMap.forEach((partNumber, partMeta) -> parts.add(ListPartsAns.Part.builder().partNumber((Integer)partNumber).eTag(partMeta.getEtag()).lastModified(partMeta.getLastModified()).size(partMeta.getSize()).build()));
        return ListPartsAns.builder().bucket(bucket).key(key).uploadId(uploadId).partNumberMarker(partNumberMarker).nextPartNumberMarker(fetchedUploadPartMap.isEmpty() ? 0 : fetchedUploadPartMap.lastKey()).maxParts(maxParts).isTruncated(!fetchedUploadPartMap.isEmpty() && fetchedUploadPartMap.lastKey() < (Integer)uploadMetadata.getParts().lastKey()).parts(parts).build();
    }
}

