/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketReadLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.model.answers.ListObjectsAns;
import com.robothy.s3.core.model.answers.ListObjectsV2Ans;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.service.ListObjectsService;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public interface ListObjectsV2Service
extends ListObjectsService {
    @BucketReadLock
    default public ListObjectsV2Ans listObjectsV2(String bucket, String continuationToken, String delimiter, String encodingType, boolean fetchOwner, int maxKeys, String prefix, String startAfter) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucket);
        String marker = StringUtils.isNotBlank((CharSequence)continuationToken) ? continuationToken : startAfter;
        ListObjectsAns listObjectsAns = this.listObjects(bucket, delimiter, encodingType, marker, maxKeys, prefix);
        String nextContinuationToken = ListObjectsV2Service.calculateNextContinuationToken(listObjectsAns.getNextMarker().orElse(null), bucketMetadata);
        ListObjectsV2Ans listObjectsV2Ans = ListObjectsV2Ans.builder().continuationToken(continuationToken).delimiter(listObjectsAns.getDelimiter()).encodingType(listObjectsAns.getEncodingType()).isTruncated(listObjectsAns.isTruncated()).keyCount(listObjectsAns.getObjects().size() + listObjectsAns.getCommonPrefixes().size()).maxKeys(listObjectsAns.getMaxKeys()).prefix(StringUtils.isBlank((CharSequence)prefix) ? null : prefix).startAfter(StringUtils.isBlank((CharSequence)startAfter) || StringUtils.isNotBlank((CharSequence)continuationToken) ? null : startAfter).objects(listObjectsAns.getObjects()).commonPrefixes(listObjectsAns.getCommonPrefixes()).nextContinuationToken(nextContinuationToken).build();
        if (!fetchOwner) {
            ListObjectsV2Service.removeOwner(listObjectsV2Ans);
        }
        return listObjectsV2Ans;
    }

    public static String calculateNextContinuationToken(String nextMarker, BucketMetadata bucketMetadata) {
        if (Objects.isNull(nextMarker)) {
            return null;
        }
        return bucketMetadata.getObjectMap().floorKey(nextMarker + '\uffff');
    }

    public static void removeOwner(ListObjectsV2Ans listObjectsV2Ans) {
        listObjectsV2Ans.getObjects().forEach(s3Object -> s3Object.setOwner(null));
    }
}

