/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketReadLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.exception.LocalS3InvalidArgumentException;
import com.robothy.s3.core.model.answers.ListObjectsAns;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.ObjectMetadata;
import com.robothy.s3.core.model.internal.VersionedObjectMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import com.robothy.s3.core.util.S3ObjectUtils;
import com.robothy.s3.datatypes.Owner;
import com.robothy.s3.datatypes.enums.StorageClass;
import com.robothy.s3.datatypes.response.S3Object;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;

public interface ListObjectsService
extends LocalS3MetadataApplicable {
    public static final ConcurrentSkipListMap<String, ObjectMetadata> EMPTY_OBJECT_MAP = new ConcurrentSkipListMap();

    @BucketReadLock
    default public ListObjectsAns listObjects(String bucket, String delimiter, String encodingType, String marker, int maxKeys, String prefix) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucket);
        String originalDelimiter = delimiter;
        if (Objects.nonNull(prefix) && Objects.nonNull(delimiter) && prefix.contains(delimiter)) {
            delimiter = null;
        }
        NavigableMap<String, ObjectMetadata> objectsAfterMarker = ListObjectsService.filterByMarkerDelimiter(bucketMetadata, marker, delimiter);
        NavigableMap<String, ObjectMetadata> filteredByPrefix = ListObjectsService.filterByPrefix(objectsAfterMarker, prefix);
        ListObjectsAns listObjectsAns = ListObjectsService.listObjectsAndCommonPrefixes(filteredByPrefix, delimiter, maxKeys);
        listObjectsAns.setDelimiter(originalDelimiter);
        listObjectsAns.setMarker(Objects.isNull(marker) ? "" : marker);
        listObjectsAns.setPrefix(Objects.isNull(prefix) ? "" : prefix);
        ListObjectsService.encodeIfNeeded(listObjectsAns, encodingType);
        return listObjectsAns;
    }

    public static NavigableMap<String, ObjectMetadata> filterByMarkerDelimiter(BucketMetadata bucketMetadata, String marker, String delimiter) {
        String firstKeyCommonPrefix;
        if (Objects.isNull(marker)) {
            return bucketMetadata.getObjectMap();
        }
        NavigableMap filteredByMarker = bucketMetadata.getObjectMap().tailMap((Object)marker, false);
        if (Objects.isNull(delimiter) || filteredByMarker.isEmpty()) {
            return filteredByMarker;
        }
        String firstKey = (String)filteredByMarker.firstKey();
        if (!firstKey.contains(delimiter) || (firstKeyCommonPrefix = ListObjectsService.calculateCommonPrefix(firstKey, delimiter)).compareTo(marker) > 0) {
            return filteredByMarker;
        }
        String fromKey = filteredByMarker.ceilingKey(firstKeyCommonPrefix + '\uffff');
        if (Objects.isNull(fromKey)) {
            return EMPTY_OBJECT_MAP;
        }
        return filteredByMarker.tailMap(fromKey, true);
    }

    public static NavigableMap<String, ObjectMetadata> filterByPrefix(NavigableMap<String, ObjectMetadata> objectsAfterMarker, String prefix) {
        if (Objects.isNull(prefix) || objectsAfterMarker.isEmpty()) {
            return objectsAfterMarker;
        }
        String fromKey = objectsAfterMarker.floorKey(prefix);
        String toKey = objectsAfterMarker.floorKey(prefix + '\uffff');
        if (Objects.isNull(toKey)) {
            return EMPTY_OBJECT_MAP;
        }
        if (Objects.isNull(fromKey)) {
            return objectsAfterMarker.headMap(toKey, true);
        }
        boolean fromKeyInclusive = fromKey.startsWith(prefix);
        return objectsAfterMarker.subMap(fromKey, fromKeyInclusive, toKey, true);
    }

    public static ListObjectsAns listObjectsAndCommonPrefixes(NavigableMap<String, ObjectMetadata> filteredObjects, String delimiter, int maxKeys) {
        if (filteredObjects.isEmpty() || 0 == maxKeys) {
            return ListObjectsAns.builder().delimiter(delimiter).maxKeys(maxKeys).build();
        }
        LinkedList<S3Object> objects = new LinkedList<S3Object>();
        TreeSet<String> commonPrefixes = new TreeSet<String>();
        String nextMarker = null;
        Iterator<String> keyIterator = filteredObjects.keySet().iterator();
        while (keyIterator.hasNext()) {
            int keyCount;
            String key = (String)keyIterator.next();
            if (((ObjectMetadata)filteredObjects.get(key)).getLatest().isDeleted()) continue;
            if (Objects.nonNull(delimiter) && key.contains(delimiter)) {
                commonPrefixes.add(ListObjectsService.calculateCommonPrefix(key, delimiter));
            } else {
                objects.add(ListObjectsService.fetchLatestObject(key, (ObjectMetadata)filteredObjects.get(key)));
            }
            if ((keyCount = commonPrefixes.size() + objects.size()) != maxKeys) continue;
            nextMarker = ListObjectsService.calculateNextMarker(filteredObjects, key, keyIterator, delimiter);
            break;
        }
        return ListObjectsAns.builder().delimiter(delimiter).maxKeys(maxKeys).nextMarker(nextMarker).isTruncated(Objects.nonNull(nextMarker)).objects(objects).commonPrefixes(new ArrayList<String>(commonPrefixes)).build();
    }

    public static String calculateNextMarker(NavigableMap<String, ObjectMetadata> filteredObjects, String currentKey, Iterator<String> keyIterator, String delimiter) {
        if (Objects.isNull(delimiter) || !currentKey.contains(delimiter)) {
            return keyIterator.hasNext() ? currentKey : null;
        }
        String commonPrefix = ListObjectsService.calculateCommonPrefix(currentKey, delimiter);
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            if (key.startsWith(commonPrefix) || ((ObjectMetadata)filteredObjects.get(key)).getLatest().isDeleted()) continue;
            return commonPrefix;
        }
        return null;
    }

    public static String calculateCommonPrefix(String key, String delimiter) {
        return key.substring(0, key.indexOf(delimiter) + delimiter.length());
    }

    public static S3Object fetchLatestObject(String key, ObjectMetadata objectMetadata) {
        VersionedObjectMetadata latest = objectMetadata.getLatest();
        S3Object object = new S3Object();
        object.setKey(key);
        object.setSize(latest.getSize());
        object.setLastModified(Instant.ofEpochMilli(latest.getCreationDate()));
        object.setEtag(latest.getEtag());
        object.setOwner(Owner.DEFAULT_OWNER);
        object.setStorageClass(StorageClass.STANDARD);
        return object;
    }

    public static void encodeIfNeeded(ListObjectsAns listObjectsAns, String encodingType) {
        if (Objects.isNull(encodingType)) {
            return;
        }
        if (!"url".equalsIgnoreCase(encodingType)) {
            throw new LocalS3InvalidArgumentException("encoding-type", encodingType, "Invalid Encoding Method specified in Request");
        }
        listObjectsAns.setEncodingType(encodingType);
        listObjectsAns.getObjects().forEach(object -> object.setKey(S3ObjectUtils.urlEncodeEscapeSlash(object.getKey())));
        ArrayList<String> encodedPrefixes = new ArrayList<String>(listObjectsAns.getCommonPrefixes().size());
        listObjectsAns.getCommonPrefixes().forEach(commonPrefix -> encodedPrefixes.add(S3ObjectUtils.urlEncodeEscapeSlash(commonPrefix)));
        listObjectsAns.setCommonPrefixes(encodedPrefixes);
        listObjectsAns.setDelimiter(S3ObjectUtils.urlEncodeEscapeSlash(listObjectsAns.getDelimiter()));
        listObjectsAns.setPrefix(S3ObjectUtils.urlEncodeEscapeSlash(listObjectsAns.getPrefix()));
        listObjectsAns.setMarker(S3ObjectUtils.urlEncodeEscapeSlash(listObjectsAns.getMarker()));
        listObjectsAns.setNextMarker(S3ObjectUtils.urlEncodeEscapeSlash(listObjectsAns.getNextMarker().orElse(null)));
    }
}

