/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketReadLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.asserionts.ObjectAssertions;
import com.robothy.s3.core.asserionts.VersionedObjectAssertions;
import com.robothy.s3.core.model.answers.ListObjectVersionsAns;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.ObjectMetadata;
import com.robothy.s3.core.model.internal.VersionedObjectMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import com.robothy.s3.datatypes.Owner;
import com.robothy.s3.datatypes.enums.StorageClass;
import com.robothy.s3.datatypes.response.DeleteMarkerEntry;
import com.robothy.s3.datatypes.response.ObjectVersion;
import com.robothy.s3.datatypes.response.VersionItem;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;

public interface ListObjectVersionsService
extends LocalS3MetadataApplicable {
    @BucketReadLock
    default public ListObjectVersionsAns listObjectVersions(String bucket, String delimiter, String keyMarker, int maxKeys, String prefix, String versionIdMarker) {
        Set candidateKeys;
        String nextKeyMarker;
        String nextVersionIdMarker;
        int delimiterIndex;
        int prefixLen;
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucket);
        if (Objects.nonNull(versionIdMarker) && Objects.isNull(keyMarker)) {
            throw new IllegalArgumentException("A version-id marker cannot be specified without a key marker.");
        }
        LinkedList<VersionItem> versionItems = new LinkedList<VersionItem>();
        LinkedList<String> commonPrefixes = new LinkedList<String>();
        int n = prefixLen = Objects.isNull(prefix) ? 0 : prefix.length();
        if (Objects.nonNull(keyMarker)) {
            ObjectMetadata objectMetadata = ObjectAssertions.assertObjectExists(bucketMetadata, keyMarker);
            if (Objects.isNull(delimiter) || -1 == (delimiterIndex = keyMarker.indexOf(delimiter, prefixLen))) {
                NavigableMap<String, VersionedObjectMetadata> versions;
                if (Objects.nonNull(versionIdMarker)) {
                    String realVersionId;
                    if ("null".equals(versionIdMarker)) {
                        VersionedObjectAssertions.assertVirtualVersionExist(objectMetadata);
                        realVersionId = objectMetadata.getVirtualVersion().get();
                    } else {
                        VersionedObjectAssertions.assertVersionedObjectExist(objectMetadata, versionIdMarker);
                        realVersionId = versionIdMarker;
                    }
                    versions = objectMetadata.getVersionedObjectMap().tailMap((Object)realVersionId, false);
                } else {
                    versions = objectMetadata.getVersionedObjectMap();
                }
                nextVersionIdMarker = Objects.isNull(prefix) || keyMarker.startsWith(prefix) ? ListObjectVersionsService.fetchVersions(versionItems, commonPrefixes, keyMarker, versions, false, maxKeys, objectMetadata.getVirtualVersion().orElse(null)) : (String)versions.lastKey();
            } else {
                commonPrefixes.add(keyMarker.substring(0, delimiterIndex + 1));
                nextVersionIdMarker = objectMetadata.getVersionedObjectMap().lastKey();
            }
            nextKeyMarker = keyMarker;
            candidateKeys = bucketMetadata.getObjectMap().tailMap((Object)keyMarker, false).keySet();
        } else {
            nextKeyMarker = null;
            nextVersionIdMarker = null;
            candidateKeys = bucketMetadata.getObjectMap().keySet();
        }
        int keyCount = versionItems.size() + commonPrefixes.size();
        if (keyCount == maxKeys) {
            return ListObjectVersionsAns.builder().nextKeyMarker(nextKeyMarker).nextVersionIdMarker(nextVersionIdMarker).versions(versionItems).commonPrefixes(commonPrefixes).build();
        }
        for (String key : candidateKeys) {
            if (Objects.nonNull(prefix) && !key.startsWith(prefix)) continue;
            ObjectMetadata objectMetadata = bucketMetadata.getObjectMetadata(key).get();
            if (Objects.nonNull(delimiter) && -1 != (delimiterIndex = key.indexOf(delimiter, prefixLen))) {
                commonPrefixes.add(key.substring(0, delimiterIndex + 1));
                nextVersionIdMarker = null;
            } else {
                nextVersionIdMarker = ListObjectVersionsService.fetchVersions(versionItems, commonPrefixes, key, objectMetadata.getVersionedObjectMap(), true, maxKeys, objectMetadata.getVirtualVersion().orElse(null));
            }
            nextKeyMarker = key;
            keyCount = commonPrefixes.size() + versionItems.size();
            if (keyCount != maxKeys) continue;
            break;
        }
        return ListObjectVersionsAns.builder().nextKeyMarker(keyCount == maxKeys ? nextKeyMarker : null).nextVersionIdMarker(keyCount == maxKeys ? nextVersionIdMarker : null).versions(versionItems).commonPrefixes(commonPrefixes).build();
    }

    public static String fetchVersions(List<VersionItem> versionItems, List<String> commonPrefixes, String key, Map<String, VersionedObjectMetadata> versions, boolean firstItemIsLatest, int maxKeys, String virtualVersion) {
        String lastVisitedVersion = null;
        int keyCount = versionItems.size() + commonPrefixes.size();
        boolean isLatest = firstItemIsLatest;
        for (Map.Entry<String, VersionedObjectMetadata> entry : versions.entrySet()) {
            if (keyCount == maxKeys) break;
            VersionedObjectMetadata versionedObjectMetadata = entry.getValue();
            if (versionedObjectMetadata.isDeleted()) {
                versionItems.add((VersionItem)DeleteMarkerEntry.builder().latest(isLatest).versionId(entry.getKey().equals(virtualVersion) ? "null" : entry.getKey()).key(key).lastModified(Instant.ofEpochMilli(versionedObjectMetadata.getCreationDate())).build());
            } else {
                versionItems.add((VersionItem)ObjectVersion.builder().latest(isLatest).versionId(entry.getKey().equals(virtualVersion) ? "null" : entry.getKey()).key(key).lastModified(Instant.ofEpochMilli(versionedObjectMetadata.getCreationDate())).size(versionedObjectMetadata.getSize()).etag(versionedObjectMetadata.getEtag()).storageClass(StorageClass.STANDARD).owner(Owner.DEFAULT_OWNER).build());
            }
            lastVisitedVersion = entry.getKey();
            isLatest = false;
            ++keyCount;
        }
        return lastVisitedVersion;
    }
}

