/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.model.Bucket;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.LocalS3Metadata;
import com.robothy.s3.core.service.BucketService;
import java.util.Objects;

public class InMemoryBucketService
implements BucketService {
    private final LocalS3Metadata s3Metadata;

    public static BucketService create(LocalS3Metadata s3Metadata) {
        Objects.requireNonNull(s3Metadata);
        return new InMemoryBucketService(s3Metadata);
    }

    private InMemoryBucketService(LocalS3Metadata metadata) {
        this.s3Metadata = metadata;
    }

    @Override
    public LocalS3Metadata localS3Metadata() {
        return this.s3Metadata;
    }

    @Override
    public Bucket createBucket(String bucketName) {
        BucketAssertions.assertBucketNameIsValid(bucketName);
        BucketAssertions.assertBucketNotExists(this.s3Metadata, bucketName);
        BucketMetadata bucketMetadata = new BucketMetadata();
        bucketMetadata.setBucketName(bucketName);
        bucketMetadata.setCreationDate(System.currentTimeMillis());
        this.s3Metadata.addBucketMetadata(bucketMetadata);
        return Bucket.fromBucketMetadata(bucketMetadata);
    }

    @Override
    public Bucket deleteBucket(String bucketName) {
        BucketAssertions.assertBucketNameIsValid(bucketName);
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.s3Metadata, bucketName);
        BucketAssertions.assertBucketIsEmpty(bucketMetadata);
        this.s3Metadata.getBucketMetadataMap().remove(bucketName);
        return Bucket.fromBucketMetadata(bucketMetadata);
    }

    @Override
    public Bucket getBucket(String bucketName) {
        BucketAssertions.assertBucketNameIsValid(bucketName);
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.s3Metadata, bucketName);
        return Bucket.fromBucketMetadata(bucketMetadata);
    }

    @Override
    public Bucket setVersioningEnabled(String bucketName, boolean versioningEnabled) {
        BucketAssertions.assertBucketNameIsValid(bucketName);
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.s3Metadata, bucketName);
        bucketMetadata.setVersioningEnabled(versioningEnabled);
        return Bucket.fromBucketMetadata(bucketMetadata);
    }

    @Override
    public Boolean getVersioningEnabled(String bucketName) {
        BucketAssertions.assertBucketNameIsValid(bucketName);
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.s3Metadata, bucketName);
        return bucketMetadata.getVersioningEnabled();
    }
}

