/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketReadLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.asserionts.ObjectAssertions;
import com.robothy.s3.core.asserionts.VersionedObjectAssertions;
import com.robothy.s3.core.exception.LocalS3InvalidArgumentException;
import com.robothy.s3.core.exception.ObjectNotExistException;
import com.robothy.s3.core.exception.VersionedObjectNotExistException;
import com.robothy.s3.core.model.answers.GetObjectAns;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.ObjectMetadata;
import com.robothy.s3.core.model.internal.VersionedObjectMetadata;
import com.robothy.s3.core.model.request.GetObjectOptions;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import com.robothy.s3.core.service.StorageApplicable;
import com.robothy.s3.core.storage.Storage;
import java.util.Objects;
import java.util.Optional;

public interface GetObjectService
extends StorageApplicable,
LocalS3MetadataApplicable {
    @BucketReadLock
    default public GetObjectAns getObject(String bucketName, String key, GetObjectOptions options) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        if (Objects.isNull(bucketMetadata.getVersioningEnabled())) {
            return GetObjectService.getObjectFromUnVersionedBucket(bucketMetadata, this.storage(), bucketName, key, false, options);
        }
        return GetObjectService.getObject(bucketMetadata, this.storage(), bucketName, key, false, options);
    }

    public static GetObjectAns getObjectFromUnVersionedBucket(BucketMetadata bucketMetadata, Storage storage, String bucketName, String key, boolean metadataOnly, GetObjectOptions options) {
        ObjectMetadata objectMetadata = ObjectAssertions.assertObjectExists(bucketMetadata, key);
        if (options.getVersionId().isPresent() && !"null".equals(options.getVersionId().get())) {
            throw new LocalS3InvalidArgumentException("versionId", options.getVersionId().get());
        }
        VersionedObjectMetadata latestObject = objectMetadata.getLatest();
        return GetObjectAns.builder().bucketName(bucketName).key(key).contentType(latestObject.getContentType()).lastModified(latestObject.getCreationDate()).size(latestObject.getSize()).content(metadataOnly ? null : storage.getInputStream(latestObject.getFileId())).etag(latestObject.getEtag()).userMetadata(latestObject.getUserMetadata()).build();
    }

    public static GetObjectAns getObject(BucketMetadata bucketMetadata, Storage storage, String bucketName, String key, boolean metadataOnly, GetObjectOptions options) {
        String returnedVersionId;
        VersionedObjectMetadata versionedObjectMetadata;
        ObjectMetadata objectMetadata = ObjectAssertions.assertObjectExists(bucketMetadata, key);
        Optional<String> versionIdOpt = options.getVersionId();
        if (versionIdOpt.isPresent()) {
            if ("null".equals(versionIdOpt.get())) {
                versionedObjectMetadata = VersionedObjectAssertions.assertVirtualVersionExist(objectMetadata);
            } else {
                if (objectMetadata.getVirtualVersion().map(versionIdOpt.get()::equals).orElse(false).booleanValue()) {
                    throw new VersionedObjectNotExistException(key, versionIdOpt.get());
                }
                versionedObjectMetadata = VersionedObjectAssertions.assertVersionedObjectExist(objectMetadata, versionIdOpt.get());
            }
            returnedVersionId = versionIdOpt.get();
        } else {
            versionedObjectMetadata = objectMetadata.getLatest();
            returnedVersionId = objectMetadata.getVirtualVersion().map(virtualVersion -> objectMetadata.getLatestVersion().equals(virtualVersion)).orElse(false) != false ? "null" : objectMetadata.getLatestVersion();
        }
        if (versionedObjectMetadata.isDeleted()) {
            if (!versionIdOpt.isPresent()) {
                throw new ObjectNotExistException(key);
            }
            return GetObjectAns.builder().bucketName(bucketName).key(key).deleteMarker(true).versionId(returnedVersionId).lastModified(versionedObjectMetadata.getCreationDate()).build();
        }
        return GetObjectAns.builder().bucketName(bucketName).key(key).versionId(returnedVersionId).contentType(versionedObjectMetadata.getContentType()).lastModified(versionedObjectMetadata.getCreationDate()).size(versionedObjectMetadata.getSize()).content(metadataOnly ? null : storage.getInputStream(versionedObjectMetadata.getFileId())).etag(versionedObjectMetadata.getEtag()).userMetadata(versionedObjectMetadata.getUserMetadata()).build();
    }

    @BucketReadLock
    default public GetObjectAns headObject(String bucketName, String key, GetObjectOptions options) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        if (Objects.isNull(bucketMetadata.getVersioningEnabled())) {
            return GetObjectService.getObjectFromUnVersionedBucket(bucketMetadata, this.storage(), bucketName, key, true, options);
        }
        return GetObjectService.getObject(bucketMetadata, this.storage(), bucketName, key, true, options);
    }
}

