/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketChanged;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.asserionts.ObjectAssertions;
import com.robothy.s3.core.exception.LocalS3InvalidArgumentException;
import com.robothy.s3.core.model.answers.DeleteObjectAns;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.ObjectMetadata;
import com.robothy.s3.core.model.internal.VersionedObjectMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import com.robothy.s3.core.service.StorageApplicable;
import com.robothy.s3.core.storage.Storage;
import com.robothy.s3.core.util.IdUtils;
import java.util.Objects;
import java.util.Optional;

public interface DeleteObjectService
extends LocalS3MetadataApplicable,
StorageApplicable {
    @BucketChanged
    @BucketWriteLock
    default public DeleteObjectAns deleteObject(String bucketName, String key) {
        return this.deleteObject(bucketName, key, null);
    }

    @BucketChanged
    @BucketWriteLock
    default public DeleteObjectAns deleteObject(String bucketName, String key, String versionId) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        if (Objects.isNull(bucketMetadata.getVersioningEnabled())) {
            return DeleteObjectService.deleteObjectFromUnVersionedBucket(bucketMetadata, this.storage(), key, versionId);
        }
        return Objects.isNull(versionId) ? DeleteObjectService.deleteWithoutVersionId(this.storage(), bucketMetadata, key) : DeleteObjectService.deleteWithVersionId(this.storage(), bucketMetadata, key, versionId);
    }

    public static DeleteObjectAns deleteObjectFromUnVersionedBucket(BucketMetadata bucketMetadata, Storage storage, String key, String versionId) {
        if (Objects.nonNull(versionId) && !"null".equals(versionId)) {
            throw new LocalS3InvalidArgumentException("versionId", versionId);
        }
        ObjectMetadata removedObject = bucketMetadata.getObjectMap().remove(key);
        if (Objects.nonNull(removedObject)) {
            VersionedObjectMetadata removedVersion = removedObject.getVersionedObjectMap().firstEntry().getValue();
            storage.delete(removedVersion.getFileId());
        }
        return DeleteObjectAns.builder().build();
    }

    public static DeleteObjectAns deleteWithoutVersionId(Storage storage, BucketMetadata bucketMetadata, String key) {
        String returnedVersionId;
        Optional<ObjectMetadata> objectMetadataOpt = bucketMetadata.getObjectMetadata(key);
        if (objectMetadataOpt.isPresent()) {
            ObjectMetadata objectMetadata = objectMetadataOpt.get();
            VersionedObjectMetadata deleteMarker = DeleteObjectService.createDeleteMarker();
            String versionId = IdUtils.defaultGenerator().nextStrId();
            if (Boolean.TRUE.equals(bucketMetadata.getVersioningEnabled())) {
                objectMetadata.putVersionedObjectMetadata(versionId, deleteMarker);
                returnedVersionId = versionId;
            } else {
                VersionedObjectMetadata removed;
                objectMetadata.putVersionedObjectMetadata(versionId, deleteMarker);
                if (objectMetadata.getVirtualVersion().isPresent() && !(removed = objectMetadata.getVersionedObjectMap().remove(objectMetadata.getVirtualVersion().get())).isDeleted()) {
                    storage.delete(removed.getFileId());
                }
                objectMetadata.setVirtualVersion(versionId);
                returnedVersionId = "null";
            }
        } else {
            VersionedObjectMetadata deleteMarker = DeleteObjectService.createDeleteMarker();
            String versionId = returnedVersionId = IdUtils.defaultGenerator().nextStrId();
            ObjectMetadata objectMetadata = new ObjectMetadata(versionId, deleteMarker);
            if (!Boolean.TRUE.equals(bucketMetadata.getVersioningEnabled())) {
                objectMetadata.setVirtualVersion(versionId);
                returnedVersionId = "null";
            }
            bucketMetadata.putObjectMetadata(key, objectMetadata);
        }
        return DeleteObjectAns.builder().isDeleteMarker(true).versionId(returnedVersionId).build();
    }

    public static VersionedObjectMetadata createDeleteMarker() {
        VersionedObjectMetadata versionedObjectMetadata = new VersionedObjectMetadata();
        versionedObjectMetadata.setDeleted(true);
        versionedObjectMetadata.setCreationDate(System.currentTimeMillis());
        return versionedObjectMetadata;
    }

    public static DeleteObjectAns deleteWithVersionId(Storage storage, BucketMetadata bucketMetadata, String key, String versionId) {
        ObjectMetadata objectMetadata = ObjectAssertions.assertObjectExists(bucketMetadata, key);
        boolean isDeleteMarker = false;
        if ("null".equals(versionId)) {
            Optional<String> virtualVersionOpt = objectMetadata.getVirtualVersion();
            if (virtualVersionOpt.isPresent()) {
                VersionedObjectMetadata toRemove = objectMetadata.getVersionedObjectMap().remove(virtualVersionOpt.get());
                isDeleteMarker = toRemove.isDeleted();
                if (!isDeleteMarker) {
                    storage.delete(toRemove.getFileId());
                }
                objectMetadata.setVirtualVersion(null);
            }
        } else {
            Optional<VersionedObjectMetadata> versionedObjectMetadataOpt = objectMetadata.getVersionedObjectMetadata(versionId);
            if (versionedObjectMetadataOpt.isPresent()) {
                VersionedObjectMetadata removed;
                if (!objectMetadata.getVirtualVersion().map(versionId::equals).orElse(false).booleanValue() && !(isDeleteMarker = (removed = objectMetadata.getVersionedObjectMap().remove(versionId)).isDeleted())) {
                    storage.delete(removed.getFileId());
                }
            }
        }
        if (objectMetadata.getVersionedObjectMap().isEmpty()) {
            bucketMetadata.getObjectMap().remove(key);
        }
        return DeleteObjectAns.builder().isDeleteMarker(isDeleteMarker).versionId(versionId).build();
    }
}

