/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketChanged;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.model.Bucket;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;

public interface CreateBucketService
extends LocalS3MetadataApplicable {
    @BucketChanged(type=BucketChanged.Type.CREATE)
    @BucketWriteLock
    default public Bucket createBucket(String bucketName) {
        return this.createBucket(bucketName, null);
    }

    @BucketChanged(type=BucketChanged.Type.CREATE)
    @BucketWriteLock
    default public Bucket createBucket(String bucketName, String region) {
        BucketAssertions.assertBucketNameIsValid(bucketName);
        BucketAssertions.assertBucketNotExists(this.localS3Metadata(), bucketName);
        BucketMetadata bucketMetadata = new BucketMetadata();
        bucketMetadata.setBucketName(bucketName);
        bucketMetadata.setCreationDate(System.currentTimeMillis());
        bucketMetadata.setRegion(region);
        this.localS3Metadata().addBucketMetadata(bucketMetadata);
        return Bucket.fromBucketMetadata(bucketMetadata);
    }
}

