/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketChanged;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.asserionts.UploadAssertions;
import com.robothy.s3.core.exception.InvalidPartOrderException;
import com.robothy.s3.core.model.answers.CompleteMultipartUploadAns;
import com.robothy.s3.core.model.answers.PutObjectAns;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.UploadMetadata;
import com.robothy.s3.core.model.internal.UploadPartMetadata;
import com.robothy.s3.core.model.request.CompleteMultipartUploadPartOption;
import com.robothy.s3.core.model.request.PutObjectOptions;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import com.robothy.s3.core.service.PutObjectService;
import com.robothy.s3.core.service.StorageApplicable;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.stream.Collectors;

public interface CompleteMultipartUploadService
extends LocalS3MetadataApplicable,
StorageApplicable,
PutObjectService {
    @BucketChanged
    @BucketWriteLock
    default public CompleteMultipartUploadAns completeMultipartUpload(String bucket, String key, String uploadId, List<CompleteMultipartUploadPartOption> completeParts) {
        PutObjectAns putObjectAns;
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucket);
        UploadMetadata uploadMetadata = UploadAssertions.assertUploadExists(bucketMetadata, key, uploadId);
        if (completeParts.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 multipart upload part.");
        }
        int pre = -1;
        for (CompleteMultipartUploadPartOption partOption : completeParts) {
            if (partOption.getPartNumber() <= pre) {
                throw new InvalidPartOrderException();
            }
            pre = partOption.getPartNumber();
            UploadAssertions.assertPartNumberExists(uploadMetadata, partOption.getPartNumber());
        }
        NavigableMap<Integer, UploadPartMetadata> uploadedParts = uploadMetadata.getParts();
        List inputStreams = completeParts.stream().map(completePart -> (UploadPartMetadata)uploadedParts.get(completePart.getPartNumber())).map(uploadPartMetadata -> this.storage().getInputStream(uploadPartMetadata.getFileId())).collect(Collectors.toList());
        long size = completeParts.stream().map(CompleteMultipartUploadPartOption::getPartNumber).map(uploadedParts::get).map(UploadPartMetadata::getSize).reduce(0L, Long::sum);
        try (SequenceInputStream in = new SequenceInputStream(Collections.enumeration(inputStreams));){
            PutObjectOptions putObjectOptions = PutObjectOptions.builder().size(size).content(in).contentType(uploadMetadata.getContentType()).build();
            putObjectAns = this.putObject(bucket, key, putObjectOptions);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to concat multipart upload parts.", e);
        }
        uploadedParts.values().forEach(part -> this.storage().delete(part.getFileId()));
        NavigableMap<String, NavigableMap<String, UploadMetadata>> uploads = bucketMetadata.getUploads();
        ((NavigableMap)uploads.get(key)).remove(uploadId);
        if (((NavigableMap)uploads.get(key)).isEmpty()) {
            uploads.remove(key);
        }
        return CompleteMultipartUploadAns.builder().location("/" + bucket + "/" + key).versionId(putObjectAns.getVersionId()).etag(putObjectAns.getEtag()).build();
    }
}

