/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketReadLock;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import java.util.Collection;
import java.util.Map;

public interface BucketTaggingService
extends LocalS3MetadataApplicable {
    @BucketWriteLock
    default public void putTagging(String bucketName, Collection<Map<String, String>> tagging) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        bucketMetadata.setTagging(tagging);
    }

    @BucketReadLock
    default public Collection<Map<String, String>> getTagging(String bucketName) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        return BucketAssertions.assertBucketTaggingExist(bucketMetadata);
    }

    @BucketWriteLock
    default public void deleteTagging(String bucketName) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        bucketMetadata.setTagging(null);
    }
}

