/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketChanged;
import com.robothy.s3.core.annotations.BucketReadLock;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;

public interface BucketReplicationService
extends LocalS3MetadataApplicable {
    @BucketChanged
    @BucketWriteLock
    default public void putBucketReplication(String bucketName, String replicationConfig) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        bucketMetadata.setReplication(replicationConfig);
    }

    @BucketReadLock
    default public String getBucketReplication(String bucketName) {
        return BucketAssertions.assertBucketReplicationExist(this.localS3Metadata(), bucketName);
    }

    @BucketChanged
    @BucketWriteLock
    default public void deleteBucketReplication(String bucketName) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        bucketMetadata.setReplication(null);
    }
}

