/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketChanged;
import com.robothy.s3.core.annotations.BucketReadLock;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;

public interface BucketPolicyService
extends LocalS3MetadataApplicable {
    @BucketReadLock
    default public String getBucketPolicy(String bucketName) {
        return BucketAssertions.assertBucketPolicyExist(this.localS3Metadata(), bucketName);
    }

    @BucketChanged
    @BucketWriteLock
    default public void putBucketPolicy(String bucketName, String policyJson) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        bucketMetadata.setPolicy(policyJson);
    }

    @BucketChanged
    @BucketWriteLock
    default public void deleteBucketPolicy(String bucketName) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        bucketMetadata.setPolicy(null);
    }
}

